/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanAttributeInfo;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.FastMethodInvoker;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.MethodInvoker;

public class GBeanMBeanAttribute {
    private static final Log log;
    private final GBeanMBean gmbean;
    private final String name;
    private final Class type;
    private final boolean readable;
    private final MethodInvoker getInvoker;
    private final boolean writable;
    private final MethodInvoker setInvoker;
    private final boolean isConstructorArg;
    private final boolean persistent;
    private final MBeanAttributeInfo mbeanAttributeInfo;
    private Object persistentValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GBeanMBeanAttribute(GBeanMBean gmbean, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker) {
        if (gmbean == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (getInvoker == null && setInvoker == null) {
            throw new InvalidConfigurationException("An attribute must be readable, writable, or persistent: + name=" + name + " targetClass=" + gmbean.getType().getName());
        }
        this.gmbean = gmbean;
        this.name = name;
        this.type = type;
        this.readable = getInvoker != null;
        this.getInvoker = getInvoker;
        this.writable = setInvoker != null;
        this.setInvoker = setInvoker;
        this.isConstructorArg = false;
        this.persistent = false;
        this.mbeanAttributeInfo = new MBeanAttributeInfo(name, type.getName(), null, this.readable, this.writable, type == Boolean.TYPE);
    }

    public GBeanMBeanAttribute(GBeanMBean gmbean, GAttributeInfo attributeInfo, Class constructorType) throws InvalidConfigurationException {
        boolean isIs;
        if (gmbean == null || attributeInfo == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (attributeInfo.isReadable() == Boolean.FALSE && attributeInfo.isWritable() == Boolean.FALSE && !attributeInfo.isPersistent()) {
            throw new InvalidConfigurationException("An attribute must be readable, writable, or persistent: + name=" + attributeInfo.getName() + " targetClass=" + gmbean.getType().getName());
        }
        this.gmbean = gmbean;
        this.name = attributeInfo.getName();
        this.persistent = attributeInfo.isPersistent();
        boolean bl = this.isConstructorArg = constructorType != null;
        if (attributeInfo instanceof DynamicGAttributeInfo) {
            this.type = Object.class;
            this.readable = attributeInfo.isReadable();
            this.getInvoker = this.readable ? new MethodInvoker(){

                public Object invoke(Object target, Object[] arguments) throws Exception {
                    return ((DynamicGBean)target).getAttribute(GBeanMBeanAttribute.this.name);
                }
            } : null;
            this.writable = attributeInfo.isWritable();
            this.setInvoker = this.writable ? new MethodInvoker(){

                public Object invoke(Object target, Object[] arguments) throws Exception {
                    ((DynamicGBean)target).setAttribute(GBeanMBeanAttribute.this.name, arguments[0]);
                    return null;
                }
            } : null;
            isIs = false;
        } else {
            Method getterMethod = null;
            if (attributeInfo.isPersistent() || attributeInfo.isReadable() != Boolean.FALSE) {
                getterMethod = GBeanMBeanAttribute.searchForGetter(gmbean, attributeInfo);
            }
            if (getterMethod != null) {
                this.getInvoker = new FastMethodInvoker(getterMethod);
                this.readable = attributeInfo.isReadable() != Boolean.FALSE;
            } else {
                this.getInvoker = null;
                this.readable = false;
            }
            Method setterMethod = null;
            if (attributeInfo.isPersistent() || attributeInfo.isWritable() != Boolean.FALSE) {
                setterMethod = GBeanMBeanAttribute.searchForSetter(gmbean, attributeInfo);
            }
            if (setterMethod != null) {
                this.setInvoker = new FastMethodInvoker(setterMethod);
                this.writable = attributeInfo.isWritable() != Boolean.FALSE;
                isIs = setterMethod.getName().startsWith("is");
            } else {
                this.setInvoker = null;
                this.writable = false;
                isIs = false;
            }
            if (this.getInvoker != null && this.setInvoker != null && getterMethod.getReturnType() != setterMethod.getParameterTypes()[0]) {
                throw new InvalidConfigurationException("Getter and setter methods do not have the same types: name=" + attributeInfo.getName() + " getterMethod=" + getterMethod.getName() + " setterMethod=" + setterMethod.getName() + " targetClass=" + gmbean.getType().getName());
            }
            if (constructorType != null && getterMethod != null && constructorType != getterMethod.getReturnType()) {
                throw new InvalidConfigurationException("Constructor argument and getter method do not have the same type: name=" + attributeInfo.getName() + " constructorType=" + constructorType.getName() + " getterMethod=" + getterMethod.getName() + " getterMethod type=" + getterMethod.getReturnType().getName() + " targetClass=" + gmbean.getType().getName());
            }
            if (constructorType != null && setterMethod != null && constructorType != setterMethod.getParameterTypes()[0]) {
                throw new InvalidConfigurationException("Constructor argument and setter method do not have the same type: name=" + attributeInfo.getName() + " constructorType=" + constructorType.getName() + " setterMethod=" + setterMethod.getName() + " getterMethod type=" + setterMethod.getParameterTypes()[0].getName() + " targetClass=" + gmbean.getType().getName());
            }
            this.type = constructorType != null ? constructorType : (getterMethod != null ? getterMethod.getReturnType() : (setterMethod != null ? setterMethod.getParameterTypes()[0] : Object.class));
        }
        this.mbeanAttributeInfo = new MBeanAttributeInfo(attributeInfo.getName(), this.type.getName(), null, this.readable, this.writable, isIs);
        if (this.persistent && this.type.isPrimitive()) {
            this.persistentValue = this.type == Boolean.TYPE ? Boolean.FALSE : (this.type == Byte.TYPE ? new Byte(0) : (this.type == Short.TYPE ? new Short(0) : (this.type == Integer.TYPE ? new Integer(0) : (this.type == Long.TYPE ? new Long(0L) : (this.type == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(this.type == Float.TYPE ? (Number)new Float(0.0f) : (Number)new Double(0.0)))))));
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public MBeanAttributeInfo getMBeanAttributeInfo() {
        return this.mbeanAttributeInfo;
    }

    public void online() throws Exception {
        if (this.persistent && !this.isConstructorArg && this.setInvoker != null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.gmbean.getClassLoader());
                if (!$assertionsDisabled && this.gmbean.getTarget() == null) {
                    throw new AssertionError((Object)"online() invoked, however the corresponding GBeanMBean is not fully initialized (perhaps online() has been called directly instead by a Kernel)");
                }
                this.setInvoker.invoke(this.gmbean.getTarget(), new Object[]{this.persistentValue});
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offline() {
        if (this.persistent && this.getInvoker != null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.gmbean.getClassLoader());
                this.persistentValue = this.getInvoker.invoke(this.gmbean.getTarget(), null);
            }
            catch (Throwable throwable) {
                log.error((Object)("Could not get the current value of persistent attribute while going offline.  The persistent attribute will not reflect the current state attribute: name=" + this.name), throwable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    public Object getValue() throws ReflectionException {
        if (this.gmbean.isOffline()) {
            if (this.persistent) {
                return this.persistentValue;
            }
            throw new IllegalStateException("Only persistent attributes can be accessed while offline");
        }
        if (!this.readable) {
            if (this.persistent) {
                throw new IllegalStateException("This persistent attribute is not accessible while online");
            }
            throw new IllegalArgumentException("This attribute is not readable");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object value;
            Thread.currentThread().setContextClassLoader(this.gmbean.getClassLoader());
            Object object = value = this.getInvoker.invoke(this.gmbean.getTarget(), null);
            return object;
        }
        catch (Throwable throwable) {
            throw new ReflectionException(new InvocationTargetException(throwable));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object value) throws ReflectionException {
        if (this.gmbean.isOffline()) {
            if (!this.persistent) throw new IllegalStateException("Only persistent attributes can be modified while offline");
            if (value == null && this.type.isPrimitive()) {
                throw new IllegalArgumentException("Cannot assign null to a primitive attribute");
            }
            this.persistentValue = value;
            return;
        }
        if (!this.writable) {
            if (!this.persistent) throw new IllegalArgumentException("This attribute is not writable");
            throw new IllegalStateException("This persistent attribute is not modifable while online");
        }
        if (value == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute");
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.gmbean.getClassLoader());
            this.setInvoker.invoke(this.gmbean.getTarget(), new Object[]{value});
            return;
        }
        catch (Throwable throwable) {
            throw new ReflectionException(new InvocationTargetException(throwable));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static Method searchForGetter(GBeanMBean gMBean, GAttributeInfo attributeInfo) throws InvalidConfigurationException {
        if (attributeInfo.getGetterName() == null) {
            String getterName = "get" + attributeInfo.getName();
            String isName = "is" + attributeInfo.getName();
            Method[] methods = gMBean.getType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || !getterName.equalsIgnoreCase(method.getName()) && !isName.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
        } else {
            try {
                Method method = gMBean.getType().getMethod(attributeInfo.getGetterName(), null);
                if (method.getReturnType() != Void.TYPE) {
                    return method;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (attributeInfo.isReadable() == Boolean.TRUE) {
            throw new InvalidConfigurationException("Getter method not found on target: name=" + attributeInfo.getName() + " targetClass=" + gMBean.getType().getName());
        }
        return null;
    }

    private static Method searchForSetter(GBeanMBean gMBean, GAttributeInfo attributeInfo) throws InvalidConfigurationException {
        if (attributeInfo.getSetterName() == null) {
            String setterName = "set" + attributeInfo.getName();
            Method[] methods = gMBean.getType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !setterName.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
        } else {
            Method[] methods = gMBean.getType().getMethods();
            String setterName = attributeInfo.getSetterName();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !setterName.equals(method.getName())) continue;
                return method;
            }
        }
        if (attributeInfo.isWritable() == Boolean.TRUE) {
            throw new InvalidConfigurationException("Setter method not found on target: name=" + attributeInfo.getName() + " targetClass=" + gMBean.getType().getName());
        }
        return null;
    }

    static {
        $assertionsDisabled = !GBeanMBeanAttribute.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GBeanMBeanAttribute.class);
    }
}

