/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.gbean.jmx.CollectionProxy;
import org.apache.geronimo.gbean.jmx.FastMethodInvoker;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.MethodInvoker;
import org.apache.geronimo.gbean.jmx.Proxy;
import org.apache.geronimo.gbean.jmx.SingleProxy;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.management.NotificationType;

public class GBeanMBeanReference
implements NotificationListener {
    private static final Log log = LogFactory.getLog((Class)GBeanMBeanReference.class);
    private final String name;
    private final Class type;
    private final boolean singleValued;
    private final GBeanMBean gmbean;
    private final MethodInvoker setInvoker;
    private Set patterns = Collections.EMPTY_SET;
    private Proxy proxy;

    public GBeanMBeanReference(GBeanMBean gmbean, GReferenceInfo referenceInfo, Class constructorType) throws InvalidConfigurationException {
        Class<?> setterType;
        this.gmbean = gmbean;
        this.name = referenceInfo.getName();
        try {
            this.type = gmbean.getClassLoader().loadClass(referenceInfo.getType());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load reference type class: name=" + this.name + " class=" + referenceInfo.getType());
        }
        if (constructorType != null) {
            setterType = constructorType;
            this.setInvoker = null;
        } else {
            Method setterMethod = GBeanMBeanReference.searchForSetter(gmbean, referenceInfo);
            this.setInvoker = new FastMethodInvoker(setterMethod);
            setterType = setterMethod.getParameterTypes()[0];
        }
        if (Collection.class == setterType) {
            this.singleValued = false;
        } else if (setterType.isAssignableFrom(this.type)) {
            this.singleValued = true;
        } else {
            throw new IllegalArgumentException("Setter parameter or constructor type must be Collection or " + this.type);
        }
        if (Modifier.isFinal(this.type.getModifiers())) {
            throw new IllegalArgumentException("Proxy interface cannot be a final class: " + this.type.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public Set getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Set patterns) {
        if (!this.gmbean.isOffline()) {
            throw new IllegalStateException("Pattern set can not be modified while online");
        }
        this.patterns = patterns == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(patterns);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getProxy() {
        if (this.patterns.isEmpty()) {
            return null;
        }
        return this.proxy.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void online() throws Exception {
        block12: {
            try {
                this.proxy = this.singleValued ? new SingleProxy(this.gmbean, this.name, this.type, this.patterns) : new CollectionProxy(this.gmbean, this.name, this.type);
                try {
                    NotificationFilterSupport mbeanServerFilter = new NotificationFilterSupport();
                    mbeanServerFilter.enableType("JMX.mbean.registered");
                    mbeanServerFilter.enableType("JMX.mbean.unregistered");
                    this.gmbean.getServer().addNotificationListener(JMXUtil.DELEGATE_NAME, this, (NotificationFilter)mbeanServerFilter, null);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                HashSet registeredTargets = new HashSet();
                Iterator targetIterator = this.patterns.iterator();
                block10: while (targetIterator.hasNext()) {
                    ObjectName pattern = (ObjectName)targetIterator.next();
                    Set<ObjectName> names = this.gmbean.getServer().queryNames(pattern, null);
                    Iterator<ObjectName> objectNameIterator = names.iterator();
                    while (objectNameIterator.hasNext()) {
                        ObjectName target = objectNameIterator.next();
                        if (registeredTargets.contains(target)) continue;
                        try {
                            this.gmbean.getServer().addNotificationListener(target, this, NotificationType.STATE_CHANGE_FILTER, null);
                        }
                        catch (InstanceNotFoundException e) {
                            continue block10;
                        }
                        if (!this.isRunning(target)) continue;
                        this.proxy.addTarget(target);
                    }
                }
                if (this.setInvoker == null || this.patterns.size() <= 0) break block12;
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.gmbean.getClassLoader());
                    this.setInvoker.invoke(this.gmbean.getTarget(), new Object[]{this.proxy.getProxy()});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            catch (Exception e) {
                this.offline();
                throw e;
            }
            catch (Error error) {
                this.offline();
                throw error;
            }
        }
    }

    public synchronized void offline() {
        if (this.proxy == null) {
            return;
        }
        try {
            this.gmbean.getServer().removeNotificationListener(JMXUtil.DELEGATE_NAME, this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Set registeredTargets = this.proxy.getTargets();
        this.proxy.destroy();
        this.proxy = null;
        Iterator iterator = registeredTargets.iterator();
        while (iterator.hasNext()) {
            ObjectName target = (ObjectName)iterator.next();
            try {
                this.gmbean.getServer().removeNotificationListener(target, this, NotificationType.STATE_CHANGE_FILTER, null);
            }
            catch (Exception ignore) {}
        }
    }

    public synchronized void start() throws WaitingException {
        if (!this.patterns.isEmpty()) {
            this.proxy.start();
        }
    }

    public synchronized void stop() {
        if (!this.patterns.isEmpty()) {
            this.proxy.stop();
        }
    }

    public synchronized void handleNotification(Notification notification, Object o) {
        if (this.proxy == null) {
            log.debug((Object)("Offline reference recieved a notification: " + notification));
            return;
        }
        String type = notification.getType();
        if ("JMX.mbean.registered".equals(type)) {
            ObjectName source = ((MBeanServerNotification)notification).getMBeanName();
            if (!this.isPossiblePeer(source)) {
                return;
            }
            try {
                this.gmbean.getServer().addNotificationListener(source, this, NotificationType.STATE_CHANGE_FILTER, null);
            }
            catch (InstanceNotFoundException e) {
                return;
            }
            if (this.isRunning(source)) {
                this.proxy.addTarget(source);
            }
        } else if ("JMX.mbean.unregistered".equals(type)) {
            this.proxy.removeTarget(((MBeanServerNotification)notification).getMBeanName());
        } else if ("j2ee.state.running".equals(type)) {
            ObjectName source = (ObjectName)notification.getSource();
            if (this.isPossiblePeer(source)) {
                this.proxy.addTarget(source);
            }
        } else if ("j2ee.state.stopped".equals(type) || "j2ee.state.failed".equals(type)) {
            this.proxy.removeTarget((ObjectName)notification.getSource());
        }
    }

    private boolean isRunning(ObjectName objectName) {
        try {
            int state = (Integer)this.gmbean.getServer().getAttribute(objectName, "state");
            return state == 1;
        }
        catch (AttributeNotFoundException e) {
            return true;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private synchronized boolean isPossiblePeer(ObjectName objectName) {
        Iterator iterator = this.patterns.iterator();
        while (iterator.hasNext()) {
            ObjectName pattern = (ObjectName)iterator.next();
            if (!pattern.apply(objectName)) continue;
            return true;
        }
        return false;
    }

    private static Method searchForSetter(GBeanMBean gMBean, GReferenceInfo referenceInfo) throws InvalidConfigurationException {
        if (referenceInfo.getSetterName() == null) {
            String setterName = "set" + referenceInfo.getName();
            Method[] methods = gMBean.getType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !setterName.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
        } else {
            Method[] methods = gMBean.getType().getMethods();
            String setterName = referenceInfo.getSetterName();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE || !setterName.equals(method.getName())) continue;
                return method;
            }
        }
        throw new InvalidConfigurationException("Target does not have specified method: name=" + referenceInfo.getName() + " targetClass=" + gMBean.getType().getName());
    }
}

