/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.jmx.NoSuchOperationError;
import org.apache.geronimo.kernel.jmx.InvokeMBean;
import org.apache.geronimo.kernel.jmx.MBeanOperationSignature;
import org.objectweb.asm.Type;

public final class ProxyMethodInterceptor
implements MethodInterceptor {
    private final Class proxyType;
    private MBeanServer server;
    private ObjectName objectName;
    private InvokeMBean[] methodTable;
    private boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public ProxyMethodInterceptor(Class proxyType) {
        if (!$assertionsDisabled && proxyType == null) {
            throw new AssertionError();
        }
        this.proxyType = proxyType;
        this.stopped = true;
    }

    public synchronized void connect(MBeanServer server, ObjectName objectName) {
        this.connect(server, objectName, false);
    }

    public synchronized void connect(MBeanServer server, ObjectName objectName, boolean stopped) {
        if (!($assertionsDisabled || server != null && objectName != null)) {
            throw new AssertionError();
        }
        this.server = server;
        this.objectName = objectName;
        this.stopped = stopped;
        this.methodTable = ProxyMethodInterceptor.createMethodTable(server, objectName, this.proxyType);
    }

    public synchronized void disconnect() {
        this.stopped = true;
        this.server = null;
        this.objectName = null;
        this.methodTable = null;
    }

    public synchronized void start() {
        if (this.server == null || this.objectName == null) {
            throw new IllegalStateException("Server or objectName is null");
        }
        this.stopped = false;
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        ProxyMethodInterceptor proxyMethodInterceptor = this;
        synchronized (proxyMethodInterceptor) {
            if (this.stopped) {
                throw new IllegalStateException("Proxy is stopped");
            }
        }
        InvokeMBean invoker = this.methodTable[proxy.getSuperIndex()];
        if (invoker == null) {
            throw new NoSuchOperationError("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return invoker.invoke(this.server, this.objectName, args);
    }

    public static InvokeMBean[] createMethodTable(MBeanServer server, ObjectName objectName, Class proxyType) {
        MBeanInfo info = null;
        try {
            info = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get MBeanInfo for target object: " + objectName);
        }
        MBeanAttributeInfo[] attributeInfos = info.getAttributes();
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>(attributeInfos.length);
        for (int i = 0; i < attributeInfos.length; ++i) {
            MBeanAttributeInfo attributeInfo = attributeInfos[i];
            attributes.put(attributeInfo.getName(), attributeInfo);
        }
        MBeanOperationInfo[] operationInfos = info.getOperations();
        HashMap<MBeanOperationSignature, MBeanOperationInfo> operations = new HashMap<MBeanOperationSignature, MBeanOperationInfo>(operationInfos.length);
        for (int i = 0; i < operationInfos.length; ++i) {
            MBeanOperationInfo operationInfo = operationInfos[i];
            operations.put(new MBeanOperationSignature(operationInfo), operationInfo);
        }
        FastClass fastClass = FastClass.create((Class)proxyType);
        InvokeMBean[] methodTable = new InvokeMBean[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int index = ProxyMethodInterceptor.getSuperIndex(proxyType, method);
            if (index < 0) continue;
            if (operations.containsKey(new MBeanOperationSignature(method))) {
                methodTable[index] = new InvokeMBean(method, false, false);
                continue;
            }
            if (method.getName().startsWith("get") && attributes.containsKey(method.getName().substring(3))) {
                methodTable[index] = new InvokeMBean(method, true, true);
                continue;
            }
            if (method.getName().startsWith("is") && attributes.containsKey(method.getName().substring(2))) {
                methodTable[index] = new InvokeMBean(method, true, true);
                continue;
            }
            if (!method.getName().startsWith("set") || !attributes.containsKey(method.getName().substring(3))) continue;
            methodTable[index] = new InvokeMBean(method, true, false);
        }
        try {
            methodTable[ProxyMethodInterceptor.getSuperIndex((Class)proxyType, (Method)proxyType.getMethod((String)"equals", new Class[]{ProxyMethodInterceptor.class$java$lang$Object == null ? (ProxyMethodInterceptor.class$java$lang$Object = ProxyMethodInterceptor.class$((String)"java.lang.Object")) : ProxyMethodInterceptor.class$java$lang$Object}))] = new EqualsInvoke();
            methodTable[ProxyMethodInterceptor.getSuperIndex((Class)proxyType, (Method)proxyType.getMethod((String)"hashCode", null))] = new HashCodeInvoke();
            methodTable[ProxyMethodInterceptor.getSuperIndex((Class)proxyType, (Method)proxyType.getMethod((String)"toString", null))] = new ToStringInvoke(proxyType.getName());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return methodTable;
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType((Method)method), Type.getArgumentTypes((Method)method));
        MethodProxy methodProxy = MethodProxy.find((Class)proxyType, (Signature)signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    static {
        $assertionsDisabled = !ProxyMethodInterceptor.class.desiredAssertionStatus();
    }

    private static final class ToStringInvoke
    extends InvokeMBean {
        private final String interfaceName;

        public ToStringInvoke(String interfaceName) {
            super("toString", new String[0], new Class[0], false, false, 0);
            this.interfaceName = "[" + interfaceName + ": ";
        }

        public Object invoke(MBeanServer server, ObjectName objectName, Object[] arguments) throws Throwable {
            return this.interfaceName + objectName + "]";
        }
    }

    private static final class EqualsInvoke
    extends InvokeMBean {
        public EqualsInvoke() {
            super("hashCode", new String[]{"java.lang.Object"}, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ProxyMethodInterceptor.class$("java.lang.Object")) : class$java$lang$Object}, false, false, 1);
        }

        public Object invoke(MBeanServer server, ObjectName objectName, Object[] arguments) throws Throwable {
            return new Boolean(objectName.equals(arguments[0]));
        }
    }

    private static final class HashCodeInvoke
    extends InvokeMBean {
        public HashCodeInvoke() {
            super("hashCode", new String[0], new Class[0], false, false, 0);
        }

        public Object invoke(MBeanServer server, ObjectName objectName, Object[] arguments) throws Throwable {
            return new Integer(objectName.hashCode());
        }
    }
}

