/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.jmx.DependencyService;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.KernelMBean;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class Kernel
extends NotificationBroadcasterSupport
implements Serializable,
KernelMBean {
    public static final ObjectName KERNEL = JMXUtil.getObjectName("geronimo.boot:role=Kernel");
    public static final ObjectName DEPENDENCY_SERVICE = JMXUtil.getObjectName("geronimo.boot:role=DependencyService2");
    private static final Map kernels = new Hashtable();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private final String kernelName;
    private final String domainName;
    private transient Log log;
    private transient boolean running;
    private transient MBeanServer mbServer;
    private transient ConfigurationManager configurationManager;
    private transient GBeanMBean configurationManagerGBean;
    private static final String[] NO_TYPES = new String[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static final ObjectName CONFIGURATION_MANAGER_NAME = JMXUtil.getObjectName("geronimo.boot:role=ConfigurationManager");
    private static final ObjectName CONFIGURATION_STORE_PATTERN = JMXUtil.getObjectName("*:role=ConfigurationStore,*");

    public Kernel() {
        this.kernelName = null;
        this.domainName = null;
    }

    public Kernel(String domainName) {
        this(null, domainName);
    }

    public Kernel(String kernelName, String domainName) {
        this.kernelName = kernelName;
        this.domainName = domainName;
    }

    public MBeanServer getMBeanServer() {
        return this.mbServer;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getKernel(String name) {
        Map map = kernels;
        synchronized (map) {
            Kernel.processQueue();
            KernelReference ref = (KernelReference)kernels.get(name);
            if (ref != null) {
                return (Kernel)ref.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getSingleKernel() {
        Map map = kernels;
        synchronized (map) {
            Kernel.processQueue();
            int size = kernels.size();
            if (size > 1) {
                throw new IllegalStateException("More than one kernel has been registered.");
            }
            if (size < 1) {
                return null;
            }
            Kernel result = (Kernel)((KernelReference)kernels.values().iterator().next()).get();
            if (result == null) {
                kernels.clear();
            }
            return result;
        }
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws Exception {
        try {
            return this.mbServer.getAttribute(objectName, attributeName);
        }
        catch (JMException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public void setAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws Exception {
        try {
            this.mbServer.setAttribute(objectName, new Attribute(attributeName, attributeValue));
        }
        catch (JMException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public Object invoke(ObjectName objectName, String methodName) throws Exception {
        return this.invoke(objectName, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws Exception {
        try {
            return this.mbServer.invoke(objectName, methodName, args, types);
        }
        catch (JMException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public boolean isLoaded(ObjectName name) {
        return this.mbServer != null && this.mbServer.isRegistered(name);
    }

    public void loadGBean(ObjectName name, GBeanMBean gbean) throws InstanceAlreadyExistsException, InvalidConfigException {
        try {
            this.mbServer.registerMBean(gbean, name);
        }
        catch (MBeanRegistrationException e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
        catch (NotCompliantMBeanException e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void startGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "start");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void startRecursiveGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "startRecursive");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void stopGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "stop");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void unloadGBean(ObjectName name) throws InstanceNotFoundException {
        try {
            this.mbServer.unregisterMBean(name);
        }
        catch (MBeanRegistrationException e) {
            throw (IllegalStateException)new IllegalStateException("Error unloading GBean " + name).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.log = LogFactory.getLog((String)Kernel.class.getName());
        this.log.info((Object)"Starting boot");
        if (this.kernelName != null) {
            Map map = kernels;
            synchronized (map) {
                kernels.put(this.kernelName, new KernelReference(this.kernelName, this));
            }
        }
        this.mbServer = MBeanServerFactory.createMBeanServer(this.domainName);
        this.mbServer.registerMBean(this, KERNEL);
        this.mbServer.registerMBean(new DependencyService(), DEPENDENCY_SERVICE);
        this.configurationManagerGBean = new GBeanMBean(ConfigurationManager.GBEAN_INFO);
        this.configurationManagerGBean.setReferencePatterns("Kernel", Collections.singleton(KERNEL));
        this.configurationManagerGBean.setReferencePatterns("Stores", Collections.singleton(CONFIGURATION_STORE_PATTERN));
        this.mbServer.registerMBean(this.configurationManagerGBean, CONFIGURATION_MANAGER_NAME);
        this.configurationManagerGBean.start();
        this.configurationManager = (ConfigurationManager)this.configurationManagerGBean.getTarget();
        this.running = true;
        this.log.info((Object)"Booted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.info((Object)"Starting kernel shutdown");
        this.configurationManager = null;
        this.configurationManagerGBean = null;
        try {
            if (this.configurationManagerGBean != null) {
                this.configurationManagerGBean.stop();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.configurationManagerGBean != null) {
                this.mbServer.unregisterMBean(CONFIGURATION_MANAGER_NAME);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.configurationManagerGBean = null;
        try {
            this.mbServer.unregisterMBean(KERNEL);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.mbServer.unregisterMBean(DEPENDENCY_SERVICE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MBeanServerFactory.releaseMBeanServer(this.mbServer);
        this.mbServer = null;
        Object object = this;
        synchronized (object) {
            this.notify();
        }
        if (this.kernelName != null) {
            object = kernels;
            synchronized (object) {
                kernels.remove(this.kernelName);
            }
        }
        this.log.info((Object)"Kernel shutdown complete");
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        KernelReference kernelRef;
        while ((kernelRef = (KernelReference)queue.poll()) != null) {
            Map map = kernels;
            synchronized (map) {
                kernels.remove(kernelRef.key);
            }
        }
    }

    private static class KernelReference
    extends WeakReference {
        private final Object key;

        public KernelReference(Object key, Object kernel) {
            super(kernel, queue);
            this.key = key;
        }
    }
}

