/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.GBeanMBeanContext;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationParent;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;

public class Configuration
implements GBean {
    private static final Log log;
    private final URI id;
    private final URI parentID;
    private final ConfigurationParent parent;
    private final List classPath;
    private final List dependencies;
    private final byte[] gbeanState;
    private final Collection repositories;
    private GBeanMBeanContext context;
    private URL baseURL;
    private Map gbeans;
    private ClassLoader classLoader;
    private byte[] savedState;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public Configuration(URI id, URI parentID, ConfigurationParent parent, List classPath, byte[] gbeanState, Collection repositories, List dependencies) {
        this.id = id;
        this.parentID = parentID;
        this.parent = parent;
        this.gbeanState = gbeanState;
        this.classPath = classPath;
        this.dependencies = dependencies;
        this.repositories = repositories;
    }

    public void setGBeanContext(GBeanContext context) {
        this.context = (GBeanMBeanContext)context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        URI uri;
        URL[] urls = new URL[this.dependencies.size() + this.classPath.size()];
        int idx = 0;
        Iterator i = this.dependencies.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            URL url = null;
            Iterator j = this.repositories.iterator();
            while (j.hasNext()) {
                Repository repository = (Repository)j.next();
                if (!repository.hasURI(uri)) continue;
                url = repository.getURL(uri);
                break;
            }
            if (url == null) {
                throw new MissingDependencyException("Unable to resolve dependency " + uri);
            }
            urls[idx++] = url;
        }
        i = this.classPath.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            urls[idx++] = new URL(this.baseURL, uri.toString());
        }
        if (!$assertionsDisabled && idx != urls.length) {
            throw new AssertionError();
        }
        log.debug((Object)("ClassPath for " + this.id + " resolved to " + Arrays.asList(urls)));
        this.classLoader = this.parent == null ? new URLClassLoader(urls, this.getClass().getClassLoader()) : new URLClassLoader(urls, this.parent.getClassLoader());
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.gbeans = Configuration.loadGBeans(this.gbeanState, this.classLoader);
            MBeanServer mbServer = this.context.getServer();
            Iterator i2 = this.gbeans.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                ObjectName name = (ObjectName)entry.getKey();
                GBeanMBean gbean = (GBeanMBean)entry.getValue();
                log.trace((Object)("Registering GBean " + name));
                try {
                    mbServer.registerMBean(gbean, name);
                }
                catch (JMRuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw e;
                }
                mbServer.invoke(Kernel.DEPENDENCY_SERVICE, "addDependency", new Object[]{name, this.context.getObjectName()}, new String[]{(class$javax$management$ObjectName == null ? Configuration.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName(), (class$javax$management$ObjectName == null ? Configuration.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName()});
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        log.info((Object)("Started configuration " + this.id));
    }

    public void doStop() {
        log.info((Object)("Stopping configuration " + this.id));
        MBeanServer mbServer = this.context.getServer();
        Iterator i = this.gbeans.keySet().iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            try {
                mbServer.invoke(Kernel.DEPENDENCY_SERVICE, "removeDependency", new Object[]{name, this.context.getObjectName()}, new String[]{(class$javax$management$ObjectName == null ? Configuration.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName(), (class$javax$management$ObjectName == null ? Configuration.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName()});
            }
            catch (Exception e) {
                log.warn((Object)("Could not remove dependency for child " + name), (Throwable)e);
            }
            try {
                log.trace((Object)("Unregistering GBean " + name));
                mbServer.unregisterMBean(name);
            }
            catch (Exception e) {
                log.warn((Object)("Could not unregister child " + name), (Throwable)e);
            }
        }
        try {
            this.savedState = Configuration.storeGBeans(this.gbeans);
        }
        catch (InvalidConfigException e) {
            log.info((Object)e);
        }
        this.gbeans = null;
    }

    public void doFail() {
    }

    public URI getParentID() {
        return this.parentID;
    }

    public URI getID() {
        return this.id;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public byte[] getSavedState() {
        return this.savedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadGBeans(byte[] gbeanState, ClassLoader cl) throws InvalidConfigException {
        HashMap<ObjectName, GBeanMBean> gbeans = new HashMap<ObjectName, GBeanMBean>();
        ObjectName objectName = null;
        try {
            ConfigInputStream ois = new ConfigInputStream(new ByteArrayInputStream(gbeanState), cl);
            try {
                try {
                    while (true) {
                        objectName = null;
                        objectName = (ObjectName)ois.readObject();
                        GBeanInfo info = (GBeanInfo)ois.readObject();
                        GBeanMBean gbean = new GBeanMBean(info, cl);
                        Configuration.loadGMBeanState(gbean, ois);
                        gbeans.put(objectName, gbean);
                    }
                }
                catch (EOFException e) {
                    ois.close();
                }
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            return gbeans;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to deserialize GBeanState" + (objectName == null ? "" : " " + objectName), e);
        }
    }

    public static void loadGMBeanState(GBeanMBean gbean, ObjectInputStream ois) throws IOException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ClassNotFoundException {
        int attributeCount = ois.readInt();
        for (int i = 0; i < attributeCount; ++i) {
            gbean.setAttribute((String)ois.readObject(), ois.readObject());
        }
        int endpointCount = ois.readInt();
        for (int i = 0; i < endpointCount; ++i) {
            gbean.setReferencePatterns((String)ois.readObject(), (Set)ois.readObject());
        }
    }

    public static byte[] storeGBeans(Map gbeans) throws InvalidConfigException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            Iterator i = gbeans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ObjectName objectName = (ObjectName)entry.getKey();
                GBeanMBean gbean = (GBeanMBean)entry.getValue();
                oos.writeObject(objectName);
                oos.writeObject(gbean.getGBeanInfo());
                Configuration.storeGMBeanState(gbean, oos);
            }
            oos.flush();
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to serialize GBeanState", e);
        }
        return baos.toByteArray();
    }

    public static void storeGMBeanState(GBeanMBean gbean, ObjectOutputStream oos) throws IOException, AttributeNotFoundException, MBeanException, ReflectionException {
        List persistentAttributes = gbean.getGBeanInfo().getPersistentAttributes();
        oos.writeInt(persistentAttributes.size());
        Iterator j = persistentAttributes.iterator();
        while (j.hasNext()) {
            GAttributeInfo attributeInfo = (GAttributeInfo)j.next();
            oos.writeObject(attributeInfo.getName());
            oos.writeObject(gbean.getAttribute(attributeInfo.getName()));
        }
        Set endpointsSet = gbean.getGBeanInfo().getReferences();
        oos.writeInt(endpointsSet.size());
        Iterator iterator = endpointsSet.iterator();
        while (iterator.hasNext()) {
            GReferenceInfo gEndpointInfo = (GReferenceInfo)iterator.next();
            oos.writeObject(gEndpointInfo.getName());
            oos.writeObject(gbean.getReferencePatterns(gEndpointInfo.getName()));
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !Configuration.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)Configuration.class);
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(Configuration.class);
        infoFactory.addAttribute("ID", true);
        infoFactory.addAttribute("ParentID", true);
        infoFactory.addAttribute("ClassPath", true);
        infoFactory.addAttribute("Dependencies", true);
        infoFactory.addAttribute("GBeanState", true);
        infoFactory.addAttribute("BaseURL", false);
        infoFactory.addAttribute("ObjectName", false);
        infoFactory.addAttribute("ClassLoader", false);
        infoFactory.addAttribute("SavedState", false);
        infoFactory.addReference("Parent", ConfigurationParent.class);
        infoFactory.addReference("Repositories", Repository.class);
        infoFactory.setConstructor(new String[]{"ID", "ParentID", "Parent", "ClassPath", "GBeanState", "Repositories", "Dependencies"}, new Class[]{URI.class, URI.class, ConfigurationParent.class, List.class, [B.class, Collection.class, List.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ConfigInputStream
    extends ObjectInputStream {
        private final ClassLoader cl;

        public ConfigInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cl = cl;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return this.cl.loadClass(desc.getName());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
    }
}

