/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;

public class ConfigurationManager {
    private static final Log log = LogFactory.getLog((Class)ConfigurationManager.class);
    private final Kernel kernel;
    private final Collection stores;
    public static final GBeanInfo GBEAN_INFO;

    public ConfigurationManager() {
        this.kernel = null;
        this.stores = null;
    }

    public ConfigurationManager(Kernel kernel, Collection stores) {
        this.kernel = kernel;
        this.stores = stores;
    }

    public boolean isLoaded(URI configID) {
        try {
            ObjectName name = ConfigurationManager.getConfigObjectName(configID);
            return this.kernel.isLoaded(name);
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
    }

    public ObjectName load(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        Set storeSnapshot = this.getStoreSnapshot();
        Iterator iterator = storeSnapshot.iterator();
        while (iterator.hasNext()) {
            ConfigurationStore store = (ConfigurationStore)iterator.next();
            if (!store.containsConfiguration(configID)) continue;
            GBeanMBean config = store.getConfiguration(configID);
            URL baseURL = store.getBaseURL(configID);
            return this.load(config, baseURL);
        }
        throw new NoSuchConfigException("A configuration with the specifiec id could not be found: " + configID);
    }

    public ObjectName load(GBeanMBean config, URL rootURL) throws InvalidConfigException {
        ObjectName configName;
        URI configID;
        try {
            configID = (URI)config.getAttribute("ID");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Cannot get config ID", e);
        }
        try {
            configName = ConfigurationManager.getConfigObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert ID to ObjectName: ", e);
        }
        this.load(config, rootURL, configName);
        return configName;
    }

    public void load(GBeanMBean config, URL rootURL, ObjectName configName) throws InvalidConfigException {
        try {
            this.kernel.loadGBean(configName, config);
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to register configuraton", e);
        }
        try {
            config.setAttribute("BaseURL", rootURL);
        }
        catch (Exception e) {
            try {
                this.kernel.unloadGBean(configName);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new InvalidConfigException("Cannot set BaseURL", e);
        }
        log.info((Object)("Loaded Configuration " + configName));
    }

    public List loadRecursive(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        try {
            LinkedList<ObjectName> ancestors = new LinkedList<ObjectName>();
            while (configID != null && !this.isLoaded(configID)) {
                ObjectName name = this.load(configID);
                ancestors.addFirst(name);
                configID = (URI)this.kernel.getAttribute(name, "ParentID");
            }
            return ancestors;
        }
        catch (NoSuchConfigException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException(e);
        }
    }

    public void unload(URI configID) throws NoSuchConfigException {
        ObjectName configName;
        try {
            configName = ConfigurationManager.getConfigObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException("Cannot convert ID to ObjectName: ", e);
        }
        this.unload(configName);
    }

    public void unload(ObjectName configName) throws NoSuchConfigException {
        try {
            this.kernel.unloadGBean(configName);
        }
        catch (InstanceNotFoundException e) {
            throw new NoSuchConfigException("No config registered: " + configName, e);
        }
        log.info((Object)("Unloaded Configuration " + configName));
    }

    private Set getStoreSnapshot() {
        HashSet storeSnapshot = new HashSet(this.stores);
        if (storeSnapshot.size() == 0) {
            throw new UnsupportedOperationException("There are no installed ConfigurationStores");
        }
        return storeSnapshot;
    }

    public static ObjectName getConfigObjectName(URI configID) throws MalformedObjectNameException {
        return new ObjectName("geronimo.config:name=" + ObjectName.quote(configID.toString()));
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ConfigurationManager.class);
        infoFactory.addReference("Kernel", Kernel.class);
        infoFactory.addReference("Stores", ConfigurationStore.class);
        infoFactory.addOperation("isLoaded", new Class[]{URI.class});
        infoFactory.addOperation("load", new Class[]{URI.class});
        infoFactory.addOperation("load", new Class[]{GBeanMBean.class, URL.class});
        infoFactory.addOperation("load", new Class[]{GBeanMBean.class, URL.class, ObjectName.class});
        infoFactory.addOperation("loadRecursive", new Class[]{URI.class});
        infoFactory.addOperation("unload", new Class[]{URI.class});
        infoFactory.addOperation("unload", new Class[]{ObjectName.class});
        infoFactory.setConstructor(new String[]{"Kernel", "Stores"}, new Class[]{Kernel.class, Collection.class});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

