/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class InvokeMBean {
    private final String name;
    private final String[] argumentTypes;
    private final Class[] declaredExceptions;
    private final boolean isAttribute;
    private final boolean isGetter;
    private final int expectedArguments;

    protected InvokeMBean(String name, String[] argumentTypes, Class[] declaredExceptions, boolean attribute, boolean getter, int expectedArguments) {
        this.name = name;
        this.argumentTypes = argumentTypes;
        this.declaredExceptions = declaredExceptions;
        this.isAttribute = attribute;
        this.isGetter = getter;
        this.expectedArguments = expectedArguments;
    }

    public InvokeMBean(Method method, boolean isAttribute, boolean isGetter) {
        this.isAttribute = isAttribute;
        this.isGetter = isGetter;
        this.expectedArguments = method.getParameterTypes().length;
        if (isAttribute) {
            if (isGetter && (method.getReturnType() == Void.TYPE || method.getParameterTypes().length > 0)) {
                throw new IllegalArgumentException("Getter attribute must take no parameters and return a value");
            }
            if (!(isGetter || method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1)) {
                throw new IllegalArgumentException("Getter attribute must take one parameter and not return a value");
            }
        }
        this.name = isAttribute ? (method.getName().startsWith("is") ? method.getName().substring(2) : method.getName().substring(3)) : method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        this.argumentTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.argumentTypes[i] = parameters[i].getName();
        }
        this.declaredExceptions = method.getExceptionTypes();
    }

    /*
     * Unable to fully structure code
     */
    public Object invoke(MBeanServer server, ObjectName objectName, Object[] arguments) throws Throwable {
        if (arguments.length != this.expectedArguments) {
            throw new IllegalArgumentException("Wrong number of arguments: expected " + this.expectedArguments + " but got " + arguments.length);
        }
        try {
            if (this.isAttribute) {
                if (this.isGetter) {
                    return server.getAttribute(objectName, this.name);
                }
                server.setAttribute(objectName, new Attribute(this.name, arguments[0]));
                return null;
            }
            return server.invoke(objectName, this.name, arguments, this.argumentTypes);
        }
        catch (Throwable t) {
            throwable = t;
            while (true) lbl-1000:
            // 7 sources

            {
                for (i = 0; i < this.declaredExceptions.length; ++i) {
                    declaredException = this.declaredExceptions[i];
                    if (!declaredException.isInstance(throwable)) continue;
                    throw throwable;
                }
                if (throwable instanceof MBeanException) {
                    throwable = ((MBeanException)throwable).getTargetException();
                    ** continue;
                }
                if (throwable instanceof ReflectionException) {
                    throwable = ((ReflectionException)throwable).getTargetException();
                    ** continue;
                }
                if (throwable instanceof RuntimeOperationsException) {
                    throwable = ((RuntimeOperationsException)throwable).getTargetException();
                    ** continue;
                }
                if (throwable instanceof RuntimeMBeanException) {
                    throwable = ((RuntimeMBeanException)throwable).getTargetException();
                    ** continue;
                }
                if (!(throwable instanceof RuntimeErrorException)) break;
                throwable = ((RuntimeErrorException)throwable).getTargetError();
            }
            throw throwable;
        }
    }
}

