/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import java.net.URL;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.MLet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXKernel {
    private static final Log log = LogFactory.getLog((Class)JMXKernel.class);
    private final MBeanServer server;

    public JMXKernel(String domainName) {
        this.server = MBeanServerFactory.createMBeanServer(domainName);
    }

    public void release() {
        MBeanServerFactory.releaseMBeanServer(this.server);
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public String getMBeanServerId() {
        return JMXKernel.getMBeanServerId(this.server);
    }

    public static String getMBeanServerId(MBeanServer server) {
        try {
            return (String)server.getAttribute(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (MBeanException e) {
            log.info((Object)e);
        }
        catch (AttributeNotFoundException e) {
            log.info((Object)e);
        }
        catch (InstanceNotFoundException e) {
            log.info((Object)e);
        }
        catch (ReflectionException e) {
            log.info((Object)e);
        }
        catch (MalformedObjectNameException e) {
            log.info((Object)e);
        }
        throw new RuntimeException("could not get the MBeanServerId");
    }

    public Set bootMLet(URL mletURL) throws ServiceNotFoundException {
        ObjectName objectName;
        String urlString = mletURL.toString();
        log.info((Object)("Booting MLets from URL " + urlString));
        try {
            objectName = new ObjectName("geronimo.boot:type=BootMLet,bootURL=" + ObjectName.quote(urlString));
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException ex = new IllegalArgumentException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        MLet bootMLet = new MLet();
        try {
            this.server.registerMBean(bootMLet, objectName);
        }
        catch (Exception e) {
            IllegalStateException ex = new IllegalStateException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return bootMLet.getMBeansFromURL(mletURL);
    }
}

