/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.jmx;

import java.lang.reflect.Method;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public final class MBeanOperationSignature {
    private static final String[] NO_TYPES = new String[0];
    private final String name;
    private final String[] argumentTypes;

    public MBeanOperationSignature(Method method) {
        this.name = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        this.argumentTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.argumentTypes[i] = parameters[i].getName();
        }
    }

    public MBeanOperationSignature(MBeanOperationInfo operationInfo) {
        this.name = operationInfo.getName();
        MBeanParameterInfo[] parameters = operationInfo.getSignature();
        this.argumentTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.argumentTypes[i] = parameters[i].getType();
        }
    }

    public MBeanOperationSignature(String name, String[] argumentTypes) {
        this.name = name;
        this.argumentTypes = argumentTypes != null ? argumentTypes : NO_TYPES;
    }

    public MBeanOperationSignature(String name, List argumentTypes) {
        this.name = name;
        if (argumentTypes != null) {
            this.argumentTypes = new String[argumentTypes.size()];
            for (int i = 0; i < argumentTypes.size(); ++i) {
                this.argumentTypes[i] = (String)argumentTypes.get(i);
            }
        } else {
            this.argumentTypes = NO_TYPES;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MBeanOperationSignature)) {
            return false;
        }
        MBeanOperationSignature methodKey = (MBeanOperationSignature)object;
        if (!methodKey.name.equals(this.name)) {
            return false;
        }
        int length = methodKey.argumentTypes.length;
        if (length != this.argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (methodKey.argumentTypes[i].equals(this.argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.hashCode();
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            result = 37 * result + this.argumentTypes[i].hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name).append("(");
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.argumentTypes[i]);
        }
        return buffer.append(")").toString();
    }
}

