/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GNotificationInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;

public class GBeanInfoBuilder {
    private static final Class[] NO_ARGS = new Class[0];
    private final String name;
    private final String className;
    private final Map attributes = new HashMap();
    private GConstructorInfo constructor;
    private final Map operations = new HashMap();
    private final Set references = new HashSet();
    private final Set notifications = new HashSet();

    public GBeanInfoBuilder(String name) {
        this(name, name, null);
    }

    public GBeanInfoBuilder(Class clazz) {
        this(GBeanInfoBuilder.checkNotNull(clazz).getName(), clazz.getName(), null);
    }

    public GBeanInfoBuilder(String name, String className) {
        this(name, className, null);
    }

    public GBeanInfoBuilder(String name, Class clazz) {
        this(name, GBeanInfoBuilder.checkNotNull(clazz).getName(), null);
    }

    public GBeanInfoBuilder(Class clazz, GBeanInfo source) {
        this(GBeanInfoBuilder.checkNotNull(clazz).getName(), clazz.getName(), source);
    }

    public GBeanInfoBuilder(String name, GBeanInfo source) {
        this(GBeanInfoBuilder.checkNotNull(name), name, source);
    }

    public GBeanInfoBuilder(String name, ClassLoader cl) {
        this(GBeanInfoBuilder.checkNotNull(name), name, GBeanInfo.getGBeanInfo(name, cl));
    }

    public GBeanInfoBuilder(String name, Class clazz, GBeanInfo source) {
        this(name, GBeanInfoBuilder.checkNotNull(clazz).getName(), source);
    }

    public GBeanInfoBuilder(String name, String className, GBeanInfo source) {
        GBeanInfoBuilder.checkNotNull(name);
        GBeanInfoBuilder.checkNotNull(className);
        this.name = name;
        this.className = className;
        if (source != null) {
            Set sourceOperations;
            Set sourceAttributes = source.getAttributes();
            if (sourceAttributes != null && !sourceAttributes.isEmpty()) {
                Iterator it = sourceAttributes.iterator();
                while (it.hasNext()) {
                    GAttributeInfo attributeInfo = (GAttributeInfo)it.next();
                    this.attributes.put(attributeInfo.getName(), attributeInfo);
                }
            }
            if ((sourceOperations = source.getOperations()) != null && !sourceOperations.isEmpty()) {
                Iterator it = sourceOperations.iterator();
                while (it.hasNext()) {
                    GOperationInfo operationInfo = (GOperationInfo)it.next();
                    this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
                }
            }
            this.references.addAll(source.getReferences());
            this.notifications.addAll(source.getNotifications());
            this.constructor = source.getConstructor();
        }
    }

    private static Class checkNotNull(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return clazz;
    }

    private static String checkNotNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return string;
    }

    public void addInterface(Class intf) {
        this.addInterface(intf, new String[0]);
    }

    public void addInterface(Class intf, String[] persistentAttributes) {
        HashSet<String> persistentName = new HashSet<String>(Arrays.asList(persistentAttributes));
        Method[] methods = intf.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String type;
            String attributeName;
            Method method = methods[i];
            String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if ((name.startsWith("get") || name.startsWith("is")) && parameterTypes.length == 0) {
                attributeName = name.startsWith("get") ? name.substring(3) : name.substring(2);
                attributeName = Introspector.decapitalize(attributeName);
                GAttributeInfo attribute = (GAttributeInfo)this.attributes.get(attributeName);
                type = method.getReturnType().getName();
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, type, persistentName.contains(attributeName), name, null));
                    continue;
                }
                if (!type.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName);
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, type, attribute.isPersistent(), name, attribute.getSetterName()));
                continue;
            }
            if (name.startsWith("set") && parameterTypes.length == 1) {
                attributeName = name.substring(3);
                attributeName = Introspector.decapitalize(attributeName);
                GAttributeInfo attribute = (GAttributeInfo)this.attributes.get(attributeName);
                type = method.getParameterTypes()[0].getName();
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, type, persistentName.contains(attributeName), null, name));
                    continue;
                }
                if (!type.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName);
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, type, attribute.isPersistent(), attribute.getGetterName(), name));
                continue;
            }
            ArrayList<String> parameters = new ArrayList<String>(parameterTypes.length);
            for (int j = 0; j < parameterTypes.length; ++j) {
                parameters.add(parameterTypes[j].getName());
            }
            this.addOperation(new GOperationInfo(name, name, parameters));
        }
    }

    public void addAttribute(String name, Class type, boolean persistent) {
        this.addAttribute(new GAttributeInfo(name, type.getName(), persistent));
    }

    public void addAttribute(String name, String type, boolean persistent) {
        this.addAttribute(new GAttributeInfo(name, type, persistent));
    }

    public void addAttribute(GAttributeInfo info) {
        this.attributes.put(info.getName(), info);
    }

    public void setConstructor(GConstructorInfo constructor) {
        this.constructor = constructor;
    }

    public void setConstructor(String[] names) {
        this.constructor = new GConstructorInfo(names);
    }

    public void addOperation(GOperationInfo operationInfo) {
        this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
    }

    public void addOperation(String name) {
        this.addOperation(new GOperationInfo(name, NO_ARGS));
    }

    public void addOperation(String name, Class[] paramTypes) {
        this.addOperation(new GOperationInfo(name, paramTypes));
    }

    public void addReference(GReferenceInfo info) {
        this.references.add(info);
    }

    public void addReference(String name, Class type) {
        this.addReference(new GReferenceInfo(name, type));
    }

    public void addNotification(GNotificationInfo info) {
        this.notifications.add(info);
    }

    public GBeanInfo getBeanInfo() {
        return new GBeanInfo(this.name, this.className, this.attributes.values(), this.constructor, this.operations.values(), this.references, this.notifications);
    }
}

