/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.EventProvider;
import org.apache.geronimo.kernel.management.ManagedObject;
import org.apache.geronimo.kernel.management.NotificationType;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.management.StateManageable;

public abstract class AbstractManagedObject
implements ManagedObject,
StateManageable,
EventProvider,
NotificationListener,
MBeanRegistration,
NotificationEmitter {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected MBeanServer server;
    protected ObjectName objectName;
    private final Set notificationTypes = new HashSet();
    private DependencyManager dependencyManager;
    private long sequenceNumber;
    private long startTime;
    private ObjectName blocker;
    private boolean enabled = true;
    private volatile State state = State.STOPPED;
    protected final NotificationBroadcasterSupport notificationBroadcaster = new NotificationBroadcasterSupport();
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractManagedObject() {
        for (int i = 0; i < NotificationType.TYPES.length; ++i) {
            this.notificationTypes.add(NotificationType.TYPES[i]);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doFail() {
    }

    public synchronized ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        Kernel kernel;
        this.server = server;
        this.objectName = objectName;
        try {
            String kernelName = (String)server.getAttribute(Kernel.KERNEL, "KernelName");
            kernel = Kernel.getKernel(kernelName);
        }
        catch (Exception e) {
            throw new IllegalStateException("No kernel is registered in this MBeanServer");
        }
        this.dependencyManager = kernel.getDependencyManager();
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.sendNotification("j2ee.object.created");
        }
    }

    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeregister() {
        this.sendNotification("j2ee.object.deleted");
        AbstractManagedObject abstractManagedObject = this;
        synchronized (abstractManagedObject) {
            this.server = null;
            this.objectName = null;
            this.dependencyManager = null;
        }
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public final String getObjectName() {
        return this.objectName.getCanonicalName();
    }

    public final ObjectName getObjectNameObject() {
        return this.objectName;
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public final boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public final boolean isEventProvider() {
        return true;
    }

    public final String[] getEventTypes() {
        return this.notificationTypes.toArray(new String[this.notificationTypes.size()]);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(this.getEventTypes(), "javax.management.Notification", "J2EE Notifications")};
    }

    protected void addEventType(String eventType) {
        this.notificationTypes.add(eventType);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notificationBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendNotification(String type) {
        long seq;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        AbstractManagedObject abstractManagedObject = this;
        synchronized (abstractManagedObject) {
            seq = this.sequenceNumber++;
        }
        this.notificationBroadcaster.sendNotification(new Notification(type, this.objectName, seq));
    }

    public void sendNotification(Notification notification) {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        this.notificationBroadcaster.sendNotification(notification);
    }

    public final synchronized long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        AbstractManagedObject abstractManagedObject = this;
        synchronized (abstractManagedObject) {
            State state = this.getStateInstance();
            if (state == State.STARTING || state == State.RUNNING) {
                return;
            }
            if (!this.enabled) {
                throw new IllegalStateException("A disabled GBean can not be started: objectName=" + this.objectName);
            }
            this.setStateInstance(State.STARTING);
        }
        this.sendNotification(State.STARTING.getEventTypeValue());
        this.attemptFullStart();
    }

    public final void startRecursive() throws Exception {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        State state = this.getStateInstance();
        if (state != State.STOPPED && state != State.FAILED) {
            return;
        }
        this.start();
        Set dependents = this.dependencyManager.getChildren(this.objectName);
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            ObjectName dependent = (ObjectName)iterator.next();
            boolean enabled = true;
            try {
                enabled = (Boolean)this.server.getAttribute(dependent, "gbeanEnabled");
            }
            catch (AttributeNotFoundException e) {
                // empty catch block
            }
            if (!enabled) continue;
            try {
                this.server.invoke(dependent, "startRecursive", null, null);
            }
            catch (ReflectionException e) {
                if (e.getTargetException() instanceof NoSuchMethodException) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a syncrhonized lock on this");
        }
        AbstractManagedObject abstractManagedObject = this;
        synchronized (abstractManagedObject) {
            State state = this.getStateInstance();
            if (state == State.STOPPED || state == State.STOPPING) {
                return;
            }
            this.setStateInstance(State.STOPPING);
        }
        this.sendNotification(State.STOPPING.getEventTypeValue());
        Set dependents = this.dependencyManager.getChildren(this.objectName);
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            ObjectName child = (ObjectName)iterator.next();
            try {
                this.log.trace((Object)("Checking if child is running: child=" + child));
                if ((Integer)this.server.getAttribute(child, "state") != 1) continue;
                this.log.trace((Object)("Stopping child: child=" + child));
                this.server.invoke(child, "stop", null, null);
                this.log.trace((Object)("Stopped child: child=" + child));
            }
            catch (Exception ignore) {}
        }
        this.attemptFullStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fail() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        AbstractManagedObject abstractManagedObject = this;
        synchronized (abstractManagedObject) {
            State state = this.getStateInstance();
            if (state == State.STOPPED || state == State.FAILED) {
                return;
            }
            this.doSafeFail();
            this.setStateInstance(State.FAILED);
        }
        this.sendNotification(State.FAILED.getEventTypeValue());
    }

    /*
     * Exception decompiling
     */
    void attemptFullStart() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    void attemptFullStop() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doSafeFail() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method can only called while holding a synchronized lock on this");
        }
        try {
            this.doFail();
        }
        catch (RuntimeException e) {
            this.log.warn((Object)"RuntimeError thrown from doFail", (Throwable)e);
        }
        catch (Error e) {
            this.log.warn((Object)"RuntimeError thrown from doFail", (Throwable)e);
        }
    }

    public void handleNotification(Notification n, Object o) {
        ObjectName source;
        String type = n.getType();
        if ("JMX.mbean.unregistered".equals(type)) {
            MBeanServerNotification notification = (MBeanServerNotification)n;
            ObjectName source2 = notification.getMBeanName();
            if (source2.equals(this.blocker)) {
                try {
                    this.attemptFullStart();
                }
                catch (Exception e) {
                    this.log.warn((Object)"A problem occured while attempting to start", (Throwable)e);
                }
            }
        } else if ((type.equals("j2ee.state.stopped") || type.equals("j2ee.state.failed") || type.equals("j2ee.object.deleted")) && (source = (ObjectName)n.getSource()).equals(this.blocker)) {
            try {
                this.attemptFullStart();
            }
            catch (Exception e) {
                this.log.warn((Object)"A problem occured while attempting to start", (Throwable)e);
            }
        }
    }

    public int getState() {
        return this.state.toInt();
    }

    public final State getStateInstance() {
        return this.state;
    }

    private synchronized void setStateInstance(State newState) throws IllegalStateException {
        block0 : switch (this.state.toInt()) {
            case 3: {
                switch (newState.toInt()) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 0: {
                switch (newState.toInt()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 3: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 1: {
                switch (newState.toInt()) {
                    case 2: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 3: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 2: {
                switch (newState.toInt()) {
                    case 3: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 4: {
                switch (newState.toInt()) {
                    case 0: 
                    case 2: {
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
            }
        }
        this.log.debug((Object)(this.toString() + " State changed from " + this.state + " to " + newState));
        if (newState == State.RUNNING) {
            this.startTime = System.currentTimeMillis();
        }
        this.state = newState;
    }

    public String toString() {
        if (this.objectName == null) {
            return super.toString();
        }
        return this.objectName.toString();
    }

    static {
        $assertionsDisabled = !AbstractManagedObject.class.desiredAssertionStatus();
    }
}

