/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.jmx.GBeanInvoker;
import org.apache.geronimo.gbean.jmx.JMXGetAttributeInvoker;
import org.apache.geronimo.gbean.jmx.JMXOperationInvoker;
import org.apache.geronimo.gbean.jmx.JMXSetAttributeInvoker;
import org.apache.geronimo.gbean.jmx.NoSuchOperationError;
import org.apache.geronimo.gbean.jmx.ProxyMethodInterceptor;
import org.apache.geronimo.gbean.jmx.RawGetAttributeInvoker;
import org.apache.geronimo.gbean.jmx.RawInvoker;
import org.apache.geronimo.gbean.jmx.RawOperationInvoker;
import org.apache.geronimo.gbean.jmx.RawSetAttributeInvoker;
import org.objectweb.asm.Type;

public class CGLibMethodInterceptor
implements ProxyMethodInterceptor,
MethodInterceptor {
    private final Class proxyType;
    private ObjectName objectName;
    private GBeanInvoker[] gbeanInvokers;
    protected boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public CGLibMethodInterceptor(Class proxyType) {
        this.proxyType = proxyType;
        this.stopped = true;
    }

    public synchronized void connect(MBeanServerConnection server, ObjectName objectName) {
        this.connect(server, objectName, false);
    }

    public synchronized void connect(MBeanServerConnection server, ObjectName objectName, boolean stopped) {
        if (!($assertionsDisabled || server != null && objectName != null)) {
            throw new AssertionError();
        }
        this.objectName = objectName;
        this.stopped = stopped;
        this.gbeanInvokers = this.createGBeanInvokers(server, objectName);
    }

    public synchronized void disconnect() {
        this.stopped = true;
        this.objectName = null;
        this.gbeanInvokers = null;
    }

    public synchronized void start() {
        if (this.gbeanInvokers == null) {
            throw new IllegalStateException("Proxy is not connected");
        }
        this.stopped = false;
    }

    public synchronized void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        GBeanInvoker gbeanInvoker;
        int interfaceIndex = proxy.getSuperIndex();
        CGLibMethodInterceptor cGLibMethodInterceptor = this;
        synchronized (cGLibMethodInterceptor) {
            if (this.stopped) {
                throw new IllegalStateException("Proxy is stopped");
            }
            gbeanInvoker = this.gbeanInvokers[interfaceIndex];
        }
        if (gbeanInvoker == null) {
            throw new NoSuchOperationError("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.objectName, args);
    }

    private GBeanInvoker[] createGBeanInvokers(MBeanServerConnection server, ObjectName objectName) {
        GBeanInvoker[] invokers;
        try {
            RawInvoker rawInvoker = (RawInvoker)server.getAttribute(objectName, "$$RAW_INVOKER$$");
            invokers = this.createRawGBeanInvokers(rawInvoker, this.proxyType);
        }
        catch (Exception e) {
            invokers = this.createJMXGBeanInvokers(server, objectName, this.proxyType);
        }
        try {
            invokers[CGLibMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"equals", new Class[]{CGLibMethodInterceptor.class$java$lang$Object == null ? (CGLibMethodInterceptor.class$java$lang$Object = CGLibMethodInterceptor.class$((String)"java.lang.Object")) : CGLibMethodInterceptor.class$java$lang$Object}))] = new ProxyMethodInterceptor.EqualsInvoke();
            invokers[CGLibMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"hashCode", null))] = new ProxyMethodInterceptor.HashCodeInvoke();
            invokers[CGLibMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"toString", null))] = new ProxyMethodInterceptor.ToStringInvoke(this.proxyType.getName());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return invokers;
    }

    private GBeanInvoker[] createRawGBeanInvokers(RawInvoker rawInvoker, Class proxyType) {
        Map operations = rawInvoker.getOperationIndex();
        Map attributes = rawInvoker.getAttributeIndex();
        FastClass fastClass = FastClass.create((Class)proxyType);
        GBeanInvoker[] invokers = new GBeanInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = CGLibMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createRawGBeanInvoker(rawInvoker, method, operations, attributes);
        }
        return invokers;
    }

    private GBeanInvoker createRawGBeanInvoker(RawInvoker rawInvoker, Method method, Map operations, Map attributes) {
        Integer methodIndex;
        String attributeName;
        if (operations.containsKey(new GOperationSignature(method))) {
            int methodIndex2 = (Integer)operations.get(new GOperationSignature(method));
            return new RawOperationInvoker(rawInvoker, methodIndex2);
        }
        if (method.getName().startsWith("get")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = CGLibMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("is")) {
            attributeName = method.getName().substring(2);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = CGLibMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("set")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = CGLibMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        return null;
    }

    private GBeanInvoker[] createJMXGBeanInvokers(MBeanServerConnection server, ObjectName objectName, Class proxyType) {
        MBeanInfo info;
        try {
            info = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get MBeanInfo for target object: " + objectName);
        }
        MBeanAttributeInfo[] attributeInfos = info.getAttributes();
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>(attributeInfos.length);
        for (int i = 0; i < attributeInfos.length; ++i) {
            MBeanAttributeInfo attributeInfo = attributeInfos[i];
            attributes.put(attributeInfo.getName(), attributeInfo);
        }
        MBeanOperationInfo[] operationInfos = info.getOperations();
        HashMap<GOperationSignature, MBeanOperationInfo> operations = new HashMap<GOperationSignature, MBeanOperationInfo>(operationInfos.length);
        for (int i = 0; i < operationInfos.length; ++i) {
            MBeanOperationInfo operationInfo = operationInfos[i];
            operations.put(new GOperationSignature(operationInfo), operationInfo);
        }
        FastClass fastClass = FastClass.create((Class)proxyType);
        GBeanInvoker[] invokers = new GBeanInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = CGLibMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createJMXGBeanInvoker(server, method, operations, attributes);
        }
        return invokers;
    }

    private GBeanInvoker createJMXGBeanInvoker(MBeanServerConnection server, Method method, Map operations, Map attributes) {
        if (operations.containsKey(new GOperationSignature(method))) {
            return new JMXOperationInvoker(server, method);
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            String attrName = method.getName().substring(3);
            if (attributes.containsKey(attrName)) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
        } else if (name.startsWith("is")) {
            String attrName = method.getName().substring(2);
            if (attributes.containsKey(attrName)) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
        } else if (name.startsWith("set")) {
            String attrName = method.getName().substring(3);
            if (attributes.containsKey(attrName)) {
                return new JMXSetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXSetAttributeInvoker(server, method, attrName);
            }
        }
        return null;
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType((Method)method), Type.getArgumentTypes((Method)method));
        MethodProxy methodProxy = MethodProxy.find((Class)proxyType, (Signature)signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    private static Integer getMethodIndex(Map attributes, String attributeName) {
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.equalsIgnoreCase(attributeName)) continue;
            return (Integer)attributes.get(key);
        }
        return null;
    }

    static {
        $assertionsDisabled = !CGLibMethodInterceptor.class.desiredAssertionStatus();
    }
}

