/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.Proxy;
import org.apache.geronimo.gbean.jmx.ProxyFactory;
import org.apache.geronimo.gbean.jmx.ProxyMethodInterceptor;

public class CollectionProxy
implements Proxy {
    private static final Log log = LogFactory.getLog((Class)CollectionProxy.class);
    private GBeanMBean gmbean;
    public String name;
    private Map proxies = new HashMap();
    private Map interceptors = new HashMap();
    private ClientCollection proxy = new ClientCollection();
    private ProxyFactory factory;
    private boolean stopped;

    public CollectionProxy(GBeanMBean gmbean, String name, Class type) {
        this.gmbean = gmbean;
        this.name = name;
        this.factory = ProxyFactory.newProxyFactory(type);
    }

    public synchronized void destroy() {
        Iterator iterator = this.interceptors.values().iterator();
        while (iterator.hasNext()) {
            ProxyMethodInterceptor interceptor = (ProxyMethodInterceptor)iterator.next();
            interceptor.disconnect();
        }
        this.proxy.listeners = null;
        this.gmbean = null;
        this.name = null;
        this.proxies = null;
        this.interceptors = null;
        this.proxy = null;
        this.factory = null;
        this.stopped = true;
    }

    public synchronized Object getProxy() {
        return this.proxy;
    }

    public synchronized Set getTargets() {
        return Collections.unmodifiableSet(this.proxies.keySet());
    }

    public synchronized void addTarget(ObjectName target) {
        if (!this.proxies.containsKey(target)) {
            ProxyMethodInterceptor interceptor = this.factory.getMethodInterceptor();
            interceptor.connect(this.gmbean.getServer(), target, this.proxy.isStopped());
            this.interceptors.put(target, interceptor);
            Object targetProxy = this.factory.create(interceptor);
            this.proxies.put(target, targetProxy);
            if (!this.stopped) {
                this.proxy.fireMemberAdddedEvent(targetProxy);
            }
        }
    }

    public synchronized void removeTarget(ObjectName target) {
        Object targetProxy = this.proxies.remove(target);
        if (targetProxy != null) {
            ProxyMethodInterceptor interceptor;
            if (!this.stopped) {
                this.proxy.fireMemberRemovedEvent(targetProxy);
            }
            if ((interceptor = (ProxyMethodInterceptor)this.interceptors.remove(target)) != null) {
                interceptor.disconnect();
            }
        }
    }

    public synchronized void start() throws WaitingException {
        this.stopped = false;
        Iterator iterator = this.interceptors.values().iterator();
        while (iterator.hasNext()) {
            ProxyMethodInterceptor interceptor = (ProxyMethodInterceptor)iterator.next();
            interceptor.start();
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        Iterator iterator = this.interceptors.values().iterator();
        while (iterator.hasNext()) {
            ProxyMethodInterceptor interceptor = (ProxyMethodInterceptor)iterator.next();
            interceptor.stop();
        }
    }

    private class ClientCollection
    implements ReferenceCollection {
        private Set listeners = new HashSet();

        private ClientCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isStopped() {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                return CollectionProxy.this.stopped;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReferenceCollectionListener(ReferenceCollectionListener listener) {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeReferenceCollectionListener(ReferenceCollectionListener listener) {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireMemberAdddedEvent(Object member) {
            ArrayList listenerCopy;
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                listenerCopy = new ArrayList(this.listeners);
            }
            Iterator iterator = listenerCopy.iterator();
            while (iterator.hasNext()) {
                ReferenceCollectionListener listener = (ReferenceCollectionListener)iterator.next();
                try {
                    listener.memberAdded(new ReferenceCollectionEvent(CollectionProxy.this.name, member));
                }
                catch (Throwable t) {
                    log.error((Object)"Listener threw exception", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireMemberRemovedEvent(Object member) {
            ArrayList listenerCopy;
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                listenerCopy = new ArrayList(this.listeners);
            }
            Iterator iterator = listenerCopy.iterator();
            while (iterator.hasNext()) {
                ReferenceCollectionListener listener = (ReferenceCollectionListener)iterator.next();
                try {
                    listener.memberRemoved(new ReferenceCollectionEvent(CollectionProxy.this.name, member));
                }
                catch (Throwable t) {
                    log.error((Object)"Listener threw exception", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return 0;
                }
                return CollectionProxy.this.proxies.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return true;
                }
                return CollectionProxy.this.proxies.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return false;
                }
                return CollectionProxy.this.proxies.containsValue(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return new Iterator(){

                        public boolean hasNext() {
                            return false;
                        }

                        public Object next() {
                            throw new NoSuchElementException();
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                return new Iterator(this){
                    private final Iterator iterator;
                    private final /* synthetic */ ClientCollection this$1;
                    {
                        this.this$1 = this$1;
                        this.iterator = new ArrayList<V>(CollectionProxy.access$600(ClientCollection.access$700(this.this$1)).values()).iterator();
                    }

                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public Object next() {
                        return this.iterator.next();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return new Object[0];
                }
                return CollectionProxy.this.proxies.values().toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    if (a.length > 0) {
                        a[0] = null;
                    }
                    return a;
                }
                return CollectionProxy.this.proxies.values().toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection c) {
            CollectionProxy collectionProxy = CollectionProxy.this;
            synchronized (collectionProxy) {
                if (CollectionProxy.this.stopped) {
                    return c.isEmpty();
                }
                return CollectionProxy.this.proxies.values().containsAll(c);
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ CollectionProxy access$700(ClientCollection x0) {
            return x0.CollectionProxy.this;
        }
    }
}

