/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GBeanLifecycleController;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.AbstractManagedObject;
import org.apache.geronimo.gbean.jmx.GBeanMBeanAttribute;
import org.apache.geronimo.gbean.jmx.GBeanMBeanLifecycleController;
import org.apache.geronimo.gbean.jmx.GBeanMBeanOperation;
import org.apache.geronimo.gbean.jmx.GBeanMBeanReference;
import org.apache.geronimo.gbean.jmx.MethodInvoker;
import org.apache.geronimo.gbean.jmx.RawInvoker;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.management.NotificationType;

public class GBeanMBean
extends AbstractManagedObject
implements DynamicMBean {
    static final String RAW_INVOKER = "$$RAW_INVOKER$$";
    public static final String GBEAN_DATA = "$$GBEAN_DATA$$";
    private static final Log log;
    private final Constructor constructor;
    private final GBeanLifecycleController gbeanLifecycleController;
    private final GBeanMBeanAttribute[] attributes;
    private final Map attributeIndex = new HashMap();
    private final GBeanMBeanReference[] references;
    private final Map referenceIndex = new HashMap();
    private final GBeanMBeanOperation[] operations;
    private final Map operationIndex = new HashMap();
    private final Set notifications = new HashSet();
    private final ClassLoader classLoader;
    private final GBeanInfo gbeanInfo;
    private final MBeanInfo mbeanInfo;
    private final String name;
    private final Class type;
    private boolean offline = true;
    private Object target;
    private final RawInvoker rawInvoker;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = GBeanMBean.class.getClassLoader();
        }
        return classLoader;
    }

    public GBeanMBean(GBeanData gbeanData, ClassLoader classLoader) throws InvalidConfigurationException {
        this(gbeanData.getGBeanInfo(), classLoader);
        try {
            this.setGBeanData(gbeanData);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("GBeanData could not be loaded into the GBeanMBean", e);
        }
    }

    public GBeanMBean(GBeanInfo gbeanInfo, ClassLoader classLoader) throws InvalidConfigurationException {
        this.gbeanInfo = gbeanInfo;
        this.classLoader = classLoader;
        try {
            this.type = classLoader.loadClass(gbeanInfo.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load GBeanInfo class from classloader:  className=" + gbeanInfo.getClassName());
        }
        this.name = gbeanInfo.getName();
        this.constructor = GBeanMBean.searchForConstructor(gbeanInfo, this.type);
        Class<?>[] constructorParameterTypes = this.constructor.getParameterTypes();
        HashMap constructorTypes = new HashMap(constructorParameterTypes.length);
        List constructorAttributeNames = this.gbeanInfo.getConstructor().getAttributeNames();
        for (int i = 0; i < constructorParameterTypes.length; ++i) {
            Class<?> type = constructorParameterTypes[i];
            constructorTypes.put(constructorAttributeNames.get(i), type);
        }
        HashMap<String, GBeanMBeanAttribute> attributesMap = new HashMap<String, GBeanMBeanAttribute>();
        Iterator iterator = gbeanInfo.getAttributes().iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attributeInfo = (GAttributeInfo)iterator.next();
            attributesMap.put(attributeInfo.getName(), new GBeanMBeanAttribute(this, attributeInfo, constructorTypes.containsKey(attributeInfo.getName())));
        }
        this.addManagedObjectAttributes(attributesMap);
        this.attributes = attributesMap.values().toArray(new GBeanMBeanAttribute[attributesMap.size()]);
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributeIndex.put(this.attributes[i].getName(), new Integer(i));
        }
        HashSet<GBeanMBeanReference> referencesSet = new HashSet<GBeanMBeanReference>();
        Iterator iterator2 = gbeanInfo.getReferences().iterator();
        while (iterator2.hasNext()) {
            GReferenceInfo referenceInfo = (GReferenceInfo)iterator2.next();
            referencesSet.add(new GBeanMBeanReference(this, referenceInfo, (Class)constructorTypes.get(referenceInfo.getName())));
        }
        this.references = referencesSet.toArray(new GBeanMBeanReference[gbeanInfo.getReferences().size()]);
        for (int i = 0; i < this.references.length; ++i) {
            this.referenceIndex.put(this.references[i].getName(), new Integer(i));
        }
        HashMap<GOperationSignature, GBeanMBeanOperation> operationsMap = new HashMap<GOperationSignature, GBeanMBeanOperation>();
        Iterator iterator3 = gbeanInfo.getOperations().iterator();
        while (iterator3.hasNext()) {
            GOperationInfo operationInfo = (GOperationInfo)iterator3.next();
            GBeanMBeanOperation operation = new GBeanMBeanOperation(this, operationInfo);
            GOperationSignature signature = new GOperationSignature(operation.getName(), operation.getParameterTypes());
            operationsMap.put(signature, operation);
        }
        this.addManagedObjectOperations(operationsMap);
        this.operations = new GBeanMBeanOperation[operationsMap.size()];
        int opCounter = 0;
        Iterator iterator4 = operationsMap.entrySet().iterator();
        while (iterator4.hasNext()) {
            Map.Entry entry = iterator4.next();
            this.operations[opCounter] = (GBeanMBeanOperation)entry.getValue();
            this.operationIndex.put(entry.getKey(), new Integer(opCounter));
            ++opCounter;
        }
        this.notifications.add(new MBeanNotificationInfo(NotificationType.TYPES, "javax.management.Notification", "J2EE Notifications"));
        ArrayList<MBeanAttributeInfo> mbeanAttributesList = new ArrayList<MBeanAttributeInfo>(this.attributes.length);
        for (int i = 0; i < this.attributes.length; ++i) {
            MBeanAttributeInfo mbeanAttributeInfo = this.attributes[i].getMBeanAttributeInfo();
            if (mbeanAttributeInfo == null) continue;
            mbeanAttributesList.add(mbeanAttributeInfo);
        }
        MBeanAttributeInfo[] mbeanAttributes = mbeanAttributesList.toArray(new MBeanAttributeInfo[mbeanAttributesList.size()]);
        MBeanOperationInfo[] mbeanOperations = new MBeanOperationInfo[this.operations.length];
        for (int i = 0; i < this.operations.length; ++i) {
            mbeanOperations[i] = this.operations[i].getMbeanOperationInfo();
        }
        this.mbeanInfo = new MBeanInfo(gbeanInfo.getClassName(), null, mbeanAttributes, new MBeanConstructorInfo[0], mbeanOperations, this.notifications.toArray(new MBeanNotificationInfo[this.notifications.size()]));
        this.rawInvoker = new RawInvoker(this);
        this.gbeanLifecycleController = new GBeanMBeanLifecycleController(this);
    }

    private static Constructor searchForConstructor(GBeanInfo beanInfo, Class type) throws InvalidConfigurationException {
        Set attributes = beanInfo.getAttributes();
        HashMap<String, String> attributeTypes = new HashMap<String, String>(attributes.size());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attribute = (GAttributeInfo)iterator.next();
            attributeTypes.put(attribute.getName(), attribute.getType());
        }
        Set references = beanInfo.getReferences();
        HashMap<String, String> referenceTypes = new HashMap<String, String>(references.size());
        Iterator iterator2 = references.iterator();
        while (iterator2.hasNext()) {
            GReferenceInfo reference = (GReferenceInfo)iterator2.next();
            referenceTypes.put(reference.getName(), reference.getType());
        }
        List arguments = beanInfo.getConstructor().getAttributeNames();
        String[] argumentTypes = new String[arguments.size()];
        boolean[] isReference = new boolean[arguments.size()];
        for (int i = 0; i < argumentTypes.length; ++i) {
            String argumentName = (String)arguments.get(i);
            if (attributeTypes.containsKey(argumentName)) {
                argumentTypes[i] = (String)attributeTypes.get(argumentName);
                isReference[i] = false;
                continue;
            }
            if (!referenceTypes.containsKey(argumentName)) continue;
            argumentTypes[i] = (String)referenceTypes.get(argumentName);
            isReference[i] = true;
        }
        Constructor<?>[] constructors = type.getConstructors();
        HashSet validConstructors = new HashSet();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (!GBeanMBean.isValidConstructor(constructor, argumentTypes, isReference)) continue;
            validConstructors.add(constructor);
        }
        if (validConstructors.isEmpty()) {
            throw new InvalidConfigurationException("Could not find a valid constructor for GBean: " + beanInfo.getName());
        }
        if (validConstructors.size() > 1) {
            throw new InvalidConfigurationException("More then one valid constructors found for GBean: " + beanInfo.getName());
        }
        return (Constructor)validConstructors.iterator().next();
    }

    private static boolean isValidConstructor(Constructor constructor, String[] argumentTypes, boolean[] isReference) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i].getName();
            if (!(isReference[i] ? !parameterType.equals(argumentTypes[i]) && !parameterType.equals((class$java$util$Collection == null ? GBeanMBean.class$("java.util.Collection") : class$java$util$Collection).getName()) && !parameterType.equals((class$java$util$Set == null ? GBeanMBean.class$("java.util.Set") : class$java$util$Set).getName()) : !parameterType.equals(argumentTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public GBeanMBean(GBeanInfo beanInfo) throws InvalidConfigurationException {
        this(beanInfo, GBeanMBean.getContextClassLoader());
    }

    public GBeanMBean(String className, ClassLoader classLoader) throws Exception {
        this(GBeanInfo.getGBeanInfo(className, classLoader), classLoader);
    }

    public GBeanMBean(String className) throws Exception {
        this(className, ClassLoader.getSystemClassLoader());
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Class getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public Map getAttributeIndex() {
        return Collections.unmodifiableMap(new HashMap(this.attributeIndex));
    }

    public Map getOperationIndex() {
        return Collections.unmodifiableMap(new HashMap(this.operationIndex));
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public synchronized ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        int i;
        ObjectName returnValue = super.preRegister(server, objectName);
        this.setAttribute("objectName", (Object)this.getObjectName());
        this.setAttribute("gbeanLifecycleController", (Object)this.gbeanLifecycleController);
        this.setAttribute("classLoader", (Object)this.classLoader);
        try {
            String kernelName = (String)server.getAttribute(Kernel.KERNEL, "KernelName");
            Kernel kernel = Kernel.getKernel(kernelName);
            this.setAttribute("kernel", (Object)kernel);
        }
        catch (Exception e) {
            this.setAttribute("kernel", null);
        }
        GConstructorInfo constructorInfo = this.gbeanInfo.getConstructor();
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        Iterator names = constructorInfo.getAttributeNames().iterator();
        for (i = 0; i < parameters.length; ++i) {
            String name = (String)names.next();
            if (this.attributeIndex.containsKey(name)) {
                parameters[i] = this.getAttribute(name);
            } else if (this.referenceIndex.containsKey(name)) {
                GBeanMBeanReference reference = this.getReferenceByName(name);
                reference.online();
                parameters[i] = reference.getProxy();
            } else {
                throw new InvalidConfigurationException("Unknown attribute or reference name in constructor: name=" + name);
            }
            if (!($assertionsDisabled || parameters[i] == null || parameterTypes[i].isPrimitive() || parameterTypes[i].isAssignableFrom(parameters[i].getClass()))) {
                throw new AssertionError((Object)("Attempting to construct " + objectName + " of type " + this.gbeanInfo.getClassName() + ". Constructor parameter " + i + " should be " + parameterTypes[i].getName() + " but is " + parameters[i].getClass().getName()));
            }
        }
        try {
            this.target = this.constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Constructor mismatch for " + returnValue), (Throwable)e);
            throw e;
        }
        for (i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].online();
        }
        for (i = 0; i < this.references.length; ++i) {
            GBeanMBeanReference reference = this.references[i];
            if (constructorInfo.getAttributeNames().contains(reference.getName())) continue;
            reference.online();
        }
        return returnValue;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (registrationDone.booleanValue()) {
            this.offline = false;
        } else {
            for (int i = 0; i < this.references.length; ++i) {
                this.references[i].offline();
            }
            this.target = null;
        }
    }

    public void postDeregister() {
        int i;
        for (i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].offline();
        }
        for (i = 0; i < this.references.length; ++i) {
            this.references[i].offline();
        }
        this.offline = true;
        this.target = null;
        super.postDeregister();
    }

    protected void doStart() throws Exception {
        for (int i = 0; i < this.references.length; ++i) {
            this.references[i].start();
        }
        if (this.target instanceof GBeanLifecycle) {
            ((GBeanLifecycle)this.target).doStart();
        }
    }

    protected void doStop() throws Exception {
        if (this.target instanceof GBeanLifecycle) {
            ((GBeanLifecycle)this.target).doStop();
        }
        for (int i = 0; i < this.references.length; ++i) {
            this.references[i].stop();
        }
    }

    protected void doFail() {
        if (this.target instanceof GBeanLifecycle) {
            ((GBeanLifecycle)this.target).doFail();
        }
        for (int i = 0; i < this.references.length; ++i) {
            this.references[i].stop();
        }
    }

    public Object getAttribute(int index) throws ReflectionException {
        GBeanMBeanAttribute attribute = this.attributes[index];
        return attribute.getValue();
    }

    public Object getAttribute(String attributeName) throws ReflectionException, AttributeNotFoundException {
        try {
            return this.getAttributeByName(attributeName).getValue();
        }
        catch (AttributeNotFoundException e) {
            if (attributeName.equals(RAW_INVOKER)) {
                return this.rawInvoker;
            }
            if (attributeName.equals(GBEAN_DATA)) {
                return this.getGBeanData();
            }
            throw e;
        }
    }

    public GBeanData getGBeanData() {
        String name;
        int i;
        GBeanData gbeanData = new GBeanData(this.objectName, this.gbeanInfo);
        for (i = 0; i < this.attributes.length; ++i) {
            GBeanMBeanAttribute attribute = this.attributes[i];
            if (!attribute.isPersistent()) continue;
            name = attribute.getName();
            Object value = attribute.getPersistentValue();
            gbeanData.setAttribute(name, value);
        }
        for (i = 0; i < this.references.length; ++i) {
            GBeanMBeanReference reference = this.references[i];
            name = reference.getName();
            Set patterns = reference.getPatterns();
            gbeanData.setReferencePatterns(name, patterns);
        }
        return gbeanData;
    }

    public void setGBeanData(GBeanData gbeanData) throws ReflectionException, AttributeNotFoundException {
        Map attributes = gbeanData.getAttributes();
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setAttribute(name, value);
        }
        Map references = gbeanData.getReferences();
        Iterator iterator2 = references.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            String name = (String)entry.getKey();
            Set patterns = (Set)entry.getValue();
            this.setReferencePatterns(name, patterns);
        }
    }

    public void setAttribute(int index, Object value) throws ReflectionException, IndexOutOfBoundsException {
        GBeanMBeanAttribute attribute = this.attributes[index];
        attribute.setValue(value);
    }

    public void setAttribute(String attributeName, Object value) throws ReflectionException, AttributeNotFoundException {
        GBeanMBeanAttribute attribute = this.getAttributeByName(attributeName);
        attribute.setValue(value);
    }

    public void setAttribute(Attribute attributeValue) throws ReflectionException, AttributeNotFoundException {
        GBeanMBeanAttribute attribute = this.getAttributeByName(attributeValue.getName());
        attribute.setValue(attributeValue.getValue());
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList results = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(name);
                results.add(new Attribute(name, value));
                continue;
            }
            catch (JMException e) {
                log.warn((Object)("Exception while getting attribute " + name), (Throwable)e);
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
                results.add(attribute);
            }
            catch (JMException e) {
                log.warn((Object)("Exception while setting attribute " + attribute.getName()), (Throwable)e);
            }
        }
        return results;
    }

    private GBeanMBeanAttribute getAttributeByName(String name) throws AttributeNotFoundException {
        Integer index = (Integer)this.attributeIndex.get(name);
        if (index == null) {
            throw new AttributeNotFoundException("Unknown attribute " + name);
        }
        GBeanMBeanAttribute attribute = this.attributes[index];
        return attribute;
    }

    public Object invoke(int index, Object[] arguments) throws ReflectionException {
        GBeanMBeanOperation operation = this.operations[index];
        return operation.invoke(arguments);
    }

    public Object invoke(String operationName, Object[] arguments, String[] types) throws ReflectionException {
        GOperationSignature signature = new GOperationSignature(operationName, types);
        Integer index = (Integer)this.operationIndex.get(signature);
        if (index == null) {
            throw new ReflectionException(new NoSuchMethodException("Unknown operation " + signature));
        }
        GBeanMBeanOperation operation = this.operations[index];
        return operation.invoke(arguments);
    }

    public Set getReferencePatterns(String name) {
        return this.getReferenceByName(name).getPatterns();
    }

    public void setReferencePattern(String name, ObjectName pattern) {
        this.getReferenceByName(name).setPatterns(Collections.singleton(pattern));
    }

    public void setReferencePatterns(String name, Set patterns) {
        this.getReferenceByName(name).setPatterns(patterns);
    }

    private GBeanMBeanReference getReferenceByName(String name) {
        Integer index = (Integer)this.referenceIndex.get(name);
        if (index == null) {
            throw new IllegalArgumentException("Unknown reference " + name);
        }
        GBeanMBeanReference reference = this.references[index];
        return reference;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mbeanInfo.getNotifications();
    }

    private void addManagedObjectAttributes(Map attributesMap) {
        attributesMap.put("objectName", new GBeanMBeanAttribute((GBeanMBeanAttribute)attributesMap.get("objectName"), this, "objectName", String.class, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return GBeanMBean.this.getObjectName();
            }
        }));
        attributesMap.put("gbeanInfo", new GBeanMBeanAttribute((GBeanMBeanAttribute)attributesMap.get("gbeanInfo"), this, "gbeanInfo", GBeanInfo.class, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return GBeanMBean.this.getGBeanInfo();
            }
        }));
        attributesMap.put("classLoader", new GBeanMBeanAttribute((GBeanMBeanAttribute)attributesMap.get("classLoader"), this, "classLoader", ClassLoader.class, null));
        attributesMap.put("gbeanLifecycleController", new GBeanMBeanAttribute((GBeanMBeanAttribute)attributesMap.get("gbeanLifecycleController"), this, "gbeanLifecycleController", GBeanLifecycleController.class, null));
        attributesMap.put("kernel", new GBeanMBeanAttribute((GBeanMBeanAttribute)attributesMap.get("kernel"), this, "kernel", Kernel.class, null));
        attributesMap.put("gbeanEnabled", new GBeanMBeanAttribute(this, "gbeanEnabled", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isEnabled());
            }
        }, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                Boolean enabled = (Boolean)arguments[0];
                GBeanMBean.this.setEnabled(enabled);
                return null;
            }
        }, true, Boolean.TRUE));
        attributesMap.put("state", new GBeanMBeanAttribute(this, "state", Integer.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Integer(GBeanMBean.this.getState());
            }
        }, null));
        attributesMap.put("startTime", new GBeanMBeanAttribute(this, "startTime", Long.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Long(GBeanMBean.this.getStartTime());
            }
        }, null));
        attributesMap.put("stateManageable", new GBeanMBeanAttribute(this, "stateManageable", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isStateManageable());
            }
        }, null));
        attributesMap.put("statisticsProvider", new GBeanMBeanAttribute(this, "statisticsProvider", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isStatisticsProvider());
            }
        }, null));
        attributesMap.put("eventProvider", new GBeanMBeanAttribute(this, "eventProvider", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isEventProvider());
            }
        }, null));
    }

    private void addManagedObjectOperations(Map operationsMap) {
        operationsMap.put(new GOperationSignature("start", Collections.EMPTY_LIST), new GBeanMBeanOperation(this, "start", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.start();
                return null;
            }
        }));
        operationsMap.put(new GOperationSignature("startRecursive", Collections.EMPTY_LIST), new GBeanMBeanOperation(this, "startRecursive", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.startRecursive();
                return null;
            }
        }));
        operationsMap.put(new GOperationSignature("stop", Collections.EMPTY_LIST), new GBeanMBeanOperation(this, "stop", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.stop();
                return null;
            }
        }));
    }

    static {
        $assertionsDisabled = !GBeanMBean.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GBeanMBean.class);
    }
}

