/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanAttributeInfo;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.FastMethodInvoker;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.MethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;

public class GBeanMBeanAttribute {
    private static final Log log;
    private final GBeanMBean gmbean;
    private final String name;
    private final Class type;
    private final boolean readable;
    private final MethodInvoker getInvoker;
    private final boolean writable;
    private final MethodInvoker setInvoker;
    private final boolean isConstructorArg;
    private final boolean persistent;
    private final MBeanAttributeInfo mbeanAttributeInfo;
    private Object persistentValue;
    private final boolean special;
    static final /* synthetic */ boolean $assertionsDisabled;

    GBeanMBeanAttribute(GBeanMBeanAttribute attribute, GBeanMBean gmbean, String name, Class type, MethodInvoker getInvoker) {
        if (gmbean == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (attribute != null) {
            if (!$assertionsDisabled && gmbean != attribute.gmbean) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !name.equals(attribute.name)) {
                throw new AssertionError();
            }
            if (type != attribute.type) {
                throw new InvalidConfigurationException("Special attribute " + name + " must have the type " + type.getName() + ", but is " + attribute.type.getName() + ": targetClass=" + gmbean.getType().getName());
            }
            if (attribute.isPersistent()) {
                throw new InvalidConfigurationException("Special attributes must not be persistent: name=" + name + ", targetClass=" + gmbean.getType().getName());
            }
        }
        this.gmbean = gmbean;
        this.name = name;
        this.type = type;
        this.getInvoker = getInvoker != null ? getInvoker : (attribute != null ? attribute.getInvoker : null);
        this.readable = this.getInvoker != null;
        this.writable = false;
        if (attribute != null) {
            this.setInvoker = attribute.setInvoker;
            this.isConstructorArg = attribute.isConstructorArg;
        } else {
            this.setInvoker = null;
            this.isConstructorArg = false;
        }
        this.persistent = false;
        this.special = true;
        this.mbeanAttributeInfo = this.getInvoker == null ? null : new MBeanAttributeInfo(name, type.getName(), null, this.readable, this.writable, type == Boolean.TYPE);
    }

    GBeanMBeanAttribute(GBeanMBean gmbean, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker) {
        this(gmbean, name, type, getInvoker, setInvoker, false, null);
    }

    GBeanMBeanAttribute(GBeanMBean gmbean, String name, Class type, MethodInvoker getInvoker, MethodInvoker setInvoker, boolean persistent, Object persistentValue) {
        if (gmbean == null || name == null || type == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (getInvoker == null && setInvoker == null) {
            throw new InvalidConfigurationException("An attribute must be readable, writable, or persistent: + name=" + name + ", targetClass=" + gmbean.getType().getName());
        }
        this.gmbean = gmbean;
        this.name = name;
        this.type = type;
        this.readable = getInvoker != null;
        this.getInvoker = getInvoker;
        this.writable = setInvoker != null;
        this.setInvoker = setInvoker;
        this.isConstructorArg = false;
        this.persistent = persistent;
        this.initializePersistentValue(persistentValue);
        this.mbeanAttributeInfo = !this.readable && !this.writable ? null : new MBeanAttributeInfo(name, type.getName(), null, this.readable, this.writable, type == Boolean.TYPE);
        this.special = false;
    }

    public GBeanMBeanAttribute(GBeanMBean gmbean, GAttributeInfo attributeInfo) throws InvalidConfigurationException {
        this(gmbean, attributeInfo, false);
    }

    public GBeanMBeanAttribute(GBeanMBean gmbean, GAttributeInfo attributeInfo, boolean isConstructorArg) throws InvalidConfigurationException {
        boolean isIs;
        if (gmbean == null || attributeInfo == null) {
            throw new IllegalArgumentException("null param(s) supplied");
        }
        if (attributeInfo.isReadable() == Boolean.FALSE && attributeInfo.isWritable() == Boolean.FALSE && !attributeInfo.isPersistent()) {
            throw new InvalidConfigurationException("An attribute must be readable, writable, or persistent: + name=" + attributeInfo.getName() + " targetClass=" + gmbean.getType().getName());
        }
        this.gmbean = gmbean;
        this.name = attributeInfo.getName();
        this.isConstructorArg = isConstructorArg;
        try {
            this.type = ClassLoading.loadClass(attributeInfo.getType(), gmbean.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load attribute class: " + attributeInfo.getType());
        }
        this.persistent = attributeInfo.isPersistent();
        if (attributeInfo instanceof DynamicGAttributeInfo) {
            this.readable = attributeInfo.isReadable();
            this.getInvoker = this.readable ? new DynamicGetterMethodInvoker(this.name) : null;
            this.writable = attributeInfo.isWritable();
            this.setInvoker = this.writable ? new DynamicSetterMethodInvoker(this.name) : null;
            isIs = false;
        } else {
            Method getterMethod = null;
            if (attributeInfo.isPersistent() || attributeInfo.isReadable() != Boolean.FALSE) {
                getterMethod = GBeanMBeanAttribute.searchForGetter(gmbean, attributeInfo, this.type);
            }
            if (getterMethod != null) {
                this.getInvoker = new FastMethodInvoker(getterMethod);
                this.readable = attributeInfo.isReadable() != Boolean.FALSE;
            } else {
                this.getInvoker = null;
                this.readable = false;
            }
            Method setterMethod = null;
            if (attributeInfo.isPersistent() || attributeInfo.isWritable() != Boolean.FALSE) {
                setterMethod = GBeanMBeanAttribute.searchForSetter(gmbean, attributeInfo, this.type);
            }
            if (setterMethod != null) {
                this.setInvoker = new FastMethodInvoker(setterMethod);
                this.writable = attributeInfo.isWritable() != Boolean.FALSE;
                isIs = setterMethod.getName().startsWith("is");
            } else {
                this.setInvoker = null;
                this.writable = false;
                isIs = false;
            }
        }
        this.mbeanAttributeInfo = new MBeanAttributeInfo(attributeInfo.getName(), this.type.getName(), null, this.readable, this.writable, isIs);
        this.initializePersistentValue(null);
        this.special = false;
    }

    private void initializePersistentValue(Object value) {
        if (this.persistent) {
            if (value == null && this.type.isPrimitive()) {
                value = this.type == Boolean.TYPE ? Boolean.FALSE : (this.type == Byte.TYPE ? new Byte(0) : (this.type == Short.TYPE ? new Short(0) : (this.type == Integer.TYPE ? new Integer(0) : (this.type == Long.TYPE ? new Long(0L) : (this.type == Character.TYPE ? (Serializable)new Character('\u0000') : (Serializable)(this.type == Float.TYPE ? (Number)new Float(0.0f) : (Number)new Double(0.0)))))));
            }
            this.persistentValue = value;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public MBeanAttributeInfo getMBeanAttributeInfo() {
        return this.mbeanAttributeInfo;
    }

    public void online() throws Exception {
        if ((this.persistent || this.special) && !this.isConstructorArg && this.setInvoker != null) {
            try {
                if (!$assertionsDisabled && this.gmbean.getTarget() == null) {
                    throw new AssertionError((Object)"online() invoked, however the corresponding GBeanMBean is not fully initialized (perhaps online() has been called directly instead by a Kernel)");
                }
                this.setInvoker.invoke(this.gmbean.getTarget(), new Object[]{this.persistentValue});
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                throw e;
            }
        }
    }

    public void offline() {
        if (this.persistent && this.getInvoker != null) {
            try {
                this.persistentValue = this.getInvoker.invoke(this.gmbean.getTarget(), null);
            }
            catch (Throwable throwable) {
                log.error((Object)("Could not get the current value of persistent attribute while going offline.  The persistent attribute will not reflect the current state attribute. " + this.getDescription()), throwable);
            }
        }
    }

    public Object getValue() throws ReflectionException {
        if (this.gmbean.isOffline()) {
            if (this.persistent || this.special) {
                return this.persistentValue;
            }
            throw new IllegalStateException("Only persistent or special attributes can be accessed while offline. " + this.getDescription());
        }
        if (!this.readable) {
            if (this.persistent) {
                throw new IllegalStateException("This persistent attribute is not accessible while online. " + this.getDescription());
            }
            throw new IllegalArgumentException("This attribute is not readable. " + this.getDescription());
        }
        try {
            Object value = this.getInvoker.invoke(this.gmbean.getTarget(), null);
            return value;
        }
        catch (Throwable throwable) {
            throw new ReflectionException(new InvocationTargetException(throwable));
        }
    }

    public Object getPersistentValue() {
        if (!this.persistent) {
            throw new IllegalStateException("Attribute is not persistent " + this.getDescription());
        }
        if (this.getInvoker != null && this.gmbean.getTarget() != null) {
            try {
                this.persistentValue = this.getInvoker.invoke(this.gmbean.getTarget(), null);
            }
            catch (Throwable throwable) {
                log.error((Object)("Could not get the current value of persistent attribute.  The persistent attribute will not reflect the current state attribute. " + this.getDescription()), throwable);
            }
        }
        return this.persistentValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object value) throws ReflectionException {
        if (this.gmbean.isOffline()) {
            if (!this.persistent && !this.special) throw new IllegalStateException("Only persistent attributes can be modified while offline. " + this.getDescription());
            if (value == null && this.type.isPrimitive()) {
                throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
            }
            this.persistentValue = value;
            return;
        }
        if (!this.writable) {
            if (!this.persistent) throw new IllegalArgumentException("This attribute is not writable. " + this.getDescription());
            throw new IllegalStateException("This persistent attribute is not modifable while online. " + this.getDescription());
        }
        if (value == null && this.type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot assign null to a primitive attribute. " + this.getDescription());
        }
        try {
            this.setInvoker.invoke(this.gmbean.getTarget(), new Object[]{value});
            return;
        }
        catch (Throwable throwable) {
            throw new ReflectionException(new InvocationTargetException(throwable));
        }
    }

    private String getDescription() {
        return "Attribute Name: " + this.getName() + ", Type: " + this.getType() + ", GBean: " + this.gmbean.getName();
    }

    private static Method searchForGetter(GBeanMBean gMBean, GAttributeInfo attributeInfo, Class type) throws InvalidConfigurationException {
        Method getterMethod = null;
        if (attributeInfo.getGetterName() == null) {
            String getterName = "get" + attributeInfo.getName();
            String isName = "is" + attributeInfo.getName();
            Method[] methods = gMBean.getType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == Void.TYPE || !getterName.equalsIgnoreCase(methods[i].getName()) && !isName.equalsIgnoreCase(methods[i].getName())) continue;
                getterMethod = methods[i];
                break;
            }
        } else {
            try {
                getterMethod = gMBean.getType().getMethod(attributeInfo.getGetterName(), null);
                if (getterMethod.getReturnType() == Void.TYPE) {
                    throw new InvalidConfigurationException("Getter method return VOID: name=" + attributeInfo.getName() + ", type=" + type.getName() + ", targetClass=" + gMBean.getType().getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (getterMethod != null && !type.equals(getterMethod.getReturnType())) {
            throw new InvalidConfigurationException("Incorrect return type for getter method: name=" + attributeInfo.getName() + ", targetClass=" + gMBean.getType().getName() + ", getter type=" + getterMethod.getReturnType() + ", expected type=" + type.getName());
        }
        if (getterMethod == null && attributeInfo.isReadable() == Boolean.TRUE) {
            throw new InvalidConfigurationException("Getter method not found on target: name=" + attributeInfo.getName() + ", type=" + type.getName() + ", targetClass=" + gMBean.getType().getName());
        }
        return getterMethod;
    }

    private static Method searchForSetter(GBeanMBean gMBean, GAttributeInfo attributeInfo, Class type) throws InvalidConfigurationException {
        if (attributeInfo.getSetterName() == null) {
            String setterName = "set" + attributeInfo.getName();
            Method[] methods = gMBean.getType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(type) || method.getReturnType() != Void.TYPE || !setterName.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
        } else {
            try {
                Method method = gMBean.getType().getMethod(attributeInfo.getSetterName(), type);
                if (method.getReturnType() != Void.TYPE) {
                    throw new InvalidConfigurationException("Setter method must return VOID: name=" + attributeInfo.getName() + ", type=" + type.getName() + ", targetClass=" + gMBean.getType().getName());
                }
                return method;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (attributeInfo.isWritable() == Boolean.TRUE) {
            throw new InvalidConfigurationException("Setter method not found on target: name=" + attributeInfo.getName() + ", type=" + type.getName() + ", targetClass=" + gMBean.getType().getName());
        }
        return null;
    }

    static {
        $assertionsDisabled = !GBeanMBeanAttribute.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GBeanMBeanAttribute.class);
    }

    private static final class DynamicSetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicSetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            ((DynamicGBean)target).setAttribute(this.name, arguments[0]);
            return null;
        }
    }

    private static final class DynamicGetterMethodInvoker
    implements MethodInvoker {
        private final String name;

        public DynamicGetterMethodInvoker(String name) {
            this.name = name;
        }

        public Object invoke(Object target, Object[] arguments) throws Exception {
            return ((DynamicGBean)target).getAttribute(this.name);
        }
    }
}

