/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGOperationInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.FastMethodInvoker;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.MethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;

public final class GBeanMBeanOperation {
    private final GBeanMBean gmbean;
    private final String name;
    private final List parameterTypes;
    private final MBeanOperationInfo mbeanOperationInfo;
    private final MethodInvoker methodInvoker;

    public GBeanMBeanOperation(GBeanMBean gMBean, String name, List parameterTypes, Class returnType, MethodInvoker methodInvoker) {
        this.gmbean = gMBean;
        this.name = name;
        this.parameterTypes = Collections.unmodifiableList(new ArrayList(parameterTypes));
        this.methodInvoker = methodInvoker;
        MBeanParameterInfo[] signature = new MBeanParameterInfo[parameterTypes.size()];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = new MBeanParameterInfo("arg" + i, (String)parameterTypes.get(i), null);
        }
        this.mbeanOperationInfo = new MBeanOperationInfo(name, null, signature, returnType.getName(), 3);
    }

    /*
     * WARNING - void declaration
     */
    public GBeanMBeanOperation(GBeanMBean gMBean, GOperationInfo operationInfo) throws InvalidConfigurationException {
        void var5_6;
        Class returnType;
        this.gmbean = gMBean;
        this.name = operationInfo.getName();
        this.parameterTypes = Collections.unmodifiableList(new ArrayList(operationInfo.getParameterList()));
        Class[] types = new Class[this.parameterTypes.size()];
        ClassLoader classLoader = gMBean.getClassLoader();
        for (int i = 0; i < types.length; ++i) {
            String type = (String)this.parameterTypes.get(i);
            try {
                types[i] = ClassLoading.loadClass((String)this.parameterTypes.get(i), classLoader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new InvalidConfigurationException("Could not load operation parameter class: name=" + operationInfo.getName() + " class=" + type);
            }
        }
        if (operationInfo instanceof DynamicGOperationInfo) {
            returnType = Object.class;
            this.methodInvoker = new MethodInvoker(){
                private String[] types;
                {
                    this.types = GBeanMBeanOperation.this.parameterTypes.toArray(new String[GBeanMBeanOperation.this.parameterTypes.size()]);
                }

                public Object invoke(Object target, Object[] arguments) throws Exception {
                    DynamicGBean dynamicGBean = (DynamicGBean)GBeanMBeanOperation.this.gmbean.getTarget();
                    dynamicGBean.invoke(GBeanMBeanOperation.this.name, arguments, this.types);
                    return null;
                }
            };
        } else {
            try {
                Method javaMethod = gMBean.getType().getMethod(operationInfo.getMethodName(), types);
                returnType = javaMethod.getReturnType();
                this.methodInvoker = new FastMethodInvoker(javaMethod);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Target does not have specified method: name=" + operationInfo.getName() + " methodName=" + operationInfo.getMethodName() + " targetClass=" + gMBean.getType().getName());
            }
        }
        MBeanParameterInfo[] signature = new MBeanParameterInfo[this.parameterTypes.size()];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = new MBeanParameterInfo("arg" + i, (String)this.parameterTypes.get(i), null);
        }
        this.mbeanOperationInfo = new MBeanOperationInfo(operationInfo.getName(), null, signature, var5_6.getName(), 3);
    }

    public String getName() {
        return this.name;
    }

    public List getParameterTypes() {
        return this.parameterTypes;
    }

    public MBeanOperationInfo getMbeanOperationInfo() {
        return this.mbeanOperationInfo;
    }

    public Object invoke(Object[] arguments) throws ReflectionException {
        if (this.gmbean.isOffline()) {
            throw new IllegalStateException("Operations can not be called while offline");
        }
        try {
            return this.methodInvoker.invoke(this.gmbean.getTarget(), arguments);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
        catch (Throwable throwable) {
            throw new ReflectionException(new InvocationTargetException(throwable));
        }
    }
}

