/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.util.Map;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ReflectionException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;

public final class RawInvoker {
    private final GBeanMBean gbean;
    private final Map attributeIndex;
    private final Map operationIndex;

    public RawInvoker(GBeanMBean gbean) {
        this.gbean = gbean;
        this.attributeIndex = gbean.getAttributeIndex();
        this.operationIndex = gbean.getOperationIndex();
    }

    public Map getAttributeIndex() {
        return this.attributeIndex;
    }

    public Map getOperationIndex() {
        return this.operationIndex;
    }

    public Object getAttribute(int index) throws Exception {
        try {
            return this.gbean.getAttribute(index);
        }
        catch (ReflectionException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && ((Throwable)cause).getCause() != null) {
                cause = ((Throwable)cause).getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public void setAttribute(int index, Object value) throws Exception {
        try {
            this.gbean.setAttribute(index, value);
        }
        catch (ReflectionException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && ((Throwable)cause).getCause() != null) {
                cause = ((Throwable)cause).getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public Object invoke(int index, Object[] args) throws Exception {
        try {
            return this.gbean.invoke(index, args);
        }
        catch (ReflectionException e) {
            Throwable cause = e;
            while ((cause instanceof JMException || cause instanceof JMRuntimeException) && ((Throwable)cause).getCause() != null) {
                cause = ((Throwable)cause).getCause();
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }
}

