/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.gbean.jmx.Proxy;
import org.apache.geronimo.gbean.jmx.ProxyFactory;
import org.apache.geronimo.gbean.jmx.ProxyMethodInterceptor;
import org.apache.geronimo.kernel.management.State;

public class SingleProxy
implements Proxy {
    private static final Log log = LogFactory.getLog((Class)SingleProxy.class);
    private GBeanMBean gmbean;
    private String name;
    private Set patterns;
    private Set targets = new HashSet();
    private Object proxy;
    private boolean waitingForMe = false;
    private ProxyMethodInterceptor methodInterceptor;

    public SingleProxy(GBeanMBean gmbean, String name, Class type, Set patterns) throws Exception {
        this.gmbean = gmbean;
        this.name = name;
        this.patterns = patterns;
        ProxyFactory factory = ProxyFactory.newProxyFactory(type);
        this.methodInterceptor = factory.getMethodInterceptor();
        this.proxy = factory.create(this.methodInterceptor);
    }

    public synchronized void destroy() {
        this.methodInterceptor.disconnect();
        this.gmbean = null;
        this.name = null;
        this.patterns = null;
        this.targets = null;
        this.proxy = null;
        this.waitingForMe = false;
        this.methodInterceptor = null;
    }

    public synchronized Object getProxy() {
        return this.proxy;
    }

    public synchronized Set getTargets() {
        return this.targets;
    }

    public synchronized void addTarget(ObjectName target) {
        if (!this.targets.contains(target)) {
            if (this.targets.size() == 1) {
                ObjectName currentTarget = (ObjectName)this.targets.iterator().next();
                this.gmbean.getDependencyManager().removeDependency(this.gmbean.getObjectNameObject(), currentTarget);
            }
            this.targets.add(target);
            if (this.gmbean.getStateInstance() == State.RUNNING) {
                this.gmbean.fail();
            } else if (this.targets.size() == 1) {
                this.gmbean.getDependencyManager().addDependency(this.gmbean.getObjectNameObject(), target);
                if (this.waitingForMe) {
                    this.attemptFullStart();
                }
            }
        }
    }

    public synchronized void removeTarget(ObjectName target) {
        boolean wasTarget = this.targets.remove(target);
        if (wasTarget) {
            if (this.gmbean.getStateInstance() == State.RUNNING) {
                this.gmbean.fail();
            } else if (this.targets.size() == 1) {
                ObjectName remainingTarget = (ObjectName)this.targets.iterator().next();
                this.gmbean.getDependencyManager().addDependency(this.gmbean.getObjectNameObject(), remainingTarget);
                if (this.waitingForMe) {
                    this.attemptFullStart();
                }
            } else if (this.targets.isEmpty()) {
                this.gmbean.getDependencyManager().removeDependency(this.gmbean.getObjectNameObject(), target);
            }
        }
    }

    private synchronized void attemptFullStart() {
        try {
            this.waitingForMe = false;
            this.gmbean.attemptFullStart();
        }
        catch (Exception e) {
            log.warn((Object)("Exception occured while attempting to fully start: objectName=" + this.gmbean.getObjectName()), (Throwable)e);
        }
    }

    public synchronized void start() throws WaitingException {
        if (this.targets.size() == 0) {
            this.waitingForMe = true;
            throw new WaitingException("No targets are running for " + this.name + " reference");
        }
        if (this.targets.size() > 1) {
            this.waitingForMe = true;
            throw new WaitingException("More then one targets are running for " + this.name + " reference");
        }
        this.waitingForMe = false;
        this.gmbean.getDependencyManager().addStartHolds(this.gmbean.getObjectNameObject(), this.patterns);
        this.methodInterceptor.connect(this.gmbean.getServer(), (ObjectName)this.targets.iterator().next());
    }

    public synchronized void stop() {
        this.waitingForMe = false;
        this.methodInterceptor.disconnect();
        this.gmbean.getDependencyManager().removeStartHolds(this.gmbean.getObjectNameObject(), this.patterns);
    }
}

