/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.beans.Introspector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.jmx.GBeanInvoker;
import org.apache.geronimo.gbean.jmx.JMXGetAttributeInvoker;
import org.apache.geronimo.gbean.jmx.JMXOperationInvoker;
import org.apache.geronimo.gbean.jmx.JMXSetAttributeInvoker;
import org.apache.geronimo.gbean.jmx.NoSuchOperationError;
import org.apache.geronimo.gbean.jmx.ProxyMethodInterceptor;

public class VMMethodInterceptor
implements ProxyMethodInterceptor,
InvocationHandler {
    private final Class proxyType;
    private ObjectName objectName;
    private boolean stopped;
    private Map gbeanInvokers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VMMethodInterceptor(Class proxyType) {
        this.proxyType = proxyType;
    }

    public void connect(MBeanServerConnection server, ObjectName objectName) {
        this.connect(server, objectName, false);
    }

    public void connect(MBeanServerConnection server, ObjectName objectName, boolean stopped) {
        if (!($assertionsDisabled || server != null && objectName != null)) {
            throw new AssertionError();
        }
        this.objectName = objectName;
        this.stopped = stopped;
        this.gbeanInvokers = this.createGBeanInvokers(server, objectName);
    }

    public void disconnect() {
        this.stopped = true;
        this.objectName = null;
        this.gbeanInvokers = null;
    }

    public void start() {
        if (this.gbeanInvokers == null) {
            throw new IllegalStateException("Proxy is not connected");
        }
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        GBeanInvoker gbeanInvoker;
        VMMethodInterceptor vMMethodInterceptor = this;
        synchronized (vMMethodInterceptor) {
            if (this.stopped) {
                throw new IllegalStateException("Proxy is stopped");
            }
            gbeanInvoker = (GBeanInvoker)this.gbeanInvokers.get(method);
        }
        if (gbeanInvoker == null) {
            throw new NoSuchOperationError("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.objectName, args);
    }

    private Map createGBeanInvokers(MBeanServerConnection server, ObjectName objectName) {
        Map invokers = this.createJMXGBeanInvokers(server, objectName, this.proxyType);
        try {
            invokers.put(Object.class.getMethod("equals", Object.class), new ProxyMethodInterceptor.EqualsInvoke());
            invokers.put(Object.class.getMethod("hashCode", null), new ProxyMethodInterceptor.HashCodeInvoke());
            invokers.put(Object.class.getMethod("toString", null), new ProxyMethodInterceptor.ToStringInvoke(this.proxyType.getName()));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return invokers;
    }

    private Map createJMXGBeanInvokers(MBeanServerConnection server, ObjectName objectName, Class proxyType) {
        MBeanInfo info;
        try {
            info = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get MBeanInfo for target object: " + objectName);
        }
        MBeanAttributeInfo[] attributeInfos = info.getAttributes();
        HashMap<String, MBeanAttributeInfo> attributes = new HashMap<String, MBeanAttributeInfo>(attributeInfos.length);
        for (int i = 0; i < attributeInfos.length; ++i) {
            MBeanAttributeInfo attributeInfo = attributeInfos[i];
            attributes.put(attributeInfo.getName(), attributeInfo);
        }
        MBeanOperationInfo[] operationInfos = info.getOperations();
        HashMap<GOperationSignature, MBeanOperationInfo> operations = new HashMap<GOperationSignature, MBeanOperationInfo>(operationInfos.length);
        for (int i = 0; i < operationInfos.length; ++i) {
            MBeanOperationInfo operationInfo = operationInfos[i];
            operations.put(new GOperationSignature(operationInfo), operationInfo);
        }
        Method[] methods = proxyType.getMethods();
        HashMap<Method, GBeanInvoker> invokers = new HashMap<Method, GBeanInvoker>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            invokers.put(method, this.createJMXGBeanInvoker(server, method, operations, attributes));
        }
        return invokers;
    }

    private GBeanInvoker createJMXGBeanInvoker(MBeanServerConnection server, Method method, Map operations, Map attributes) {
        if (operations.containsKey(new GOperationSignature(method))) {
            return new JMXOperationInvoker(server, method);
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            String attrName = method.getName().substring(3);
            if (attributes.containsKey(attrName)) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
        } else if (name.startsWith("is")) {
            String attrName = method.getName().substring(2);
            if (attributes.containsKey(attrName)) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXGetAttributeInvoker(server, method, attrName);
            }
        } else if (name.startsWith("set")) {
            String attrName = method.getName().substring(3);
            if (attributes.containsKey(attrName)) {
                return new JMXSetAttributeInvoker(server, method, attrName);
            }
            if (attributes.containsKey(attrName = Introspector.decapitalize(attrName))) {
                return new JMXSetAttributeInvoker(server, method, attrName);
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !VMMethodInterceptor.class.desiredAssertionStatus();
    }
}

