/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class DependencyManager
implements NotificationListener {
    private MBeanServer mbeanServer;
    private final Map childToParentMap = new HashMap();
    private final Map parentToChildMap = new HashMap();
    private final Map startHoldsMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public DependencyManager(MBeanServer mbeanServer) throws Exception {
        if (!$assertionsDisabled && mbeanServer == null) {
            throw new AssertionError();
        }
        this.mbeanServer = mbeanServer;
        NotificationFilterSupport mbeanServerFilter = new NotificationFilterSupport();
        mbeanServerFilter.enableType("JMX.mbean.unregistered");
        mbeanServer.addNotificationListener(JMXUtil.DELEGATE_NAME, this, (NotificationFilter)mbeanServerFilter, null);
    }

    public synchronized void close() {
        try {
            this.mbeanServer.removeNotificationListener(JMXUtil.DELEGATE_NAME, this);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        this.mbeanServer = null;
        this.childToParentMap.clear();
        this.parentToChildMap.clear();
        this.startHoldsMap.clear();
    }

    public synchronized void addDependency(ObjectName child, ObjectName parent) {
        HashSet<ObjectName> parents = (HashSet<ObjectName>)this.childToParentMap.get(child);
        if (parents == null) {
            parents = new HashSet<ObjectName>();
            this.childToParentMap.put(child, parents);
        }
        parents.add(parent);
        HashSet<ObjectName> children = (HashSet<ObjectName>)this.parentToChildMap.get(parent);
        if (children == null) {
            children = new HashSet<ObjectName>();
            this.parentToChildMap.put(parent, children);
        }
        children.add(child);
    }

    public synchronized void removeDependency(ObjectName child, ObjectName parent) {
        Set children;
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents != null) {
            parents.remove(parent);
        }
        if ((children = (Set)this.parentToChildMap.get(parent)) != null) {
            children.remove(child);
        }
    }

    public synchronized void removeAllDependencies(ObjectName child) {
        Set parents = (Set)this.childToParentMap.remove(child);
        if (parents == null) {
            return;
        }
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            ObjectName parent = (ObjectName)iterator.next();
            Set children = (Set)this.parentToChildMap.get(parent);
            if (children == null) continue;
            children.remove(child);
        }
    }

    public synchronized void addDependencies(ObjectName child, Set parents) {
        HashSet existingParents = (HashSet)this.childToParentMap.get(child);
        if (existingParents == null) {
            existingParents = new HashSet(parents);
            this.childToParentMap.put(child, existingParents);
        } else {
            existingParents.addAll(parents);
        }
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Object startParent = i.next();
            HashSet<ObjectName> children = (HashSet<ObjectName>)this.parentToChildMap.get(startParent);
            if (children == null) {
                children = new HashSet<ObjectName>();
                this.parentToChildMap.put(startParent, children);
            }
            children.add(child);
        }
    }

    public synchronized Set getParents(ObjectName child) {
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents == null) {
            return Collections.EMPTY_SET;
        }
        return parents;
    }

    public synchronized Set getChildren(ObjectName parent) {
        Set children = (Set)this.parentToChildMap.get(parent);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        return children;
    }

    public synchronized void addStartHolds(ObjectName objectName, Collection holds) {
        LinkedList currentHolds = (LinkedList)this.startHoldsMap.get(objectName);
        if (currentHolds == null) {
            currentHolds = new LinkedList(holds);
            this.startHoldsMap.put(objectName, currentHolds);
        } else {
            currentHolds.addAll(holds);
        }
    }

    public synchronized void removeStartHolds(ObjectName objectName, Collection holds) {
        Collection currentHolds = (Collection)this.startHoldsMap.get(objectName);
        if (currentHolds != null) {
            currentHolds.removeAll(holds);
        }
    }

    public synchronized void removeAllStartHolds(ObjectName objectName) {
        this.startHoldsMap.remove(objectName);
    }

    public synchronized ObjectName checkBlocker(ObjectName objectName) {
        Iterator iterator = this.startHoldsMap.keySet().iterator();
        while (iterator.hasNext()) {
            ObjectName blocker = (ObjectName)iterator.next();
            List holds = (List)this.startHoldsMap.get(blocker);
            Iterator holdsIterator = holds.iterator();
            while (holdsIterator.hasNext()) {
                ObjectName pattern = (ObjectName)holdsIterator.next();
                if (!pattern.apply(objectName)) continue;
                return blocker;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification n, Object handback) {
        String type = n.getType();
        if ("JMX.mbean.unregistered".equals(type)) {
            MBeanServerNotification notification = (MBeanServerNotification)n;
            ObjectName source = notification.getMBeanName();
            DependencyManager dependencyManager = this;
            synchronized (dependencyManager) {
                this.removeAllDependencies(source);
                this.removeAllStartHolds(source);
            }
        }
    }

    static {
        $assertionsDisabled = !DependencyManager.class.desiredAssertionStatus();
    }
}

