/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.KernelMBean;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationManagerImpl;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class Kernel
extends NotificationBroadcasterSupport
implements KernelMBean {
    public static final ObjectName KERNEL;
    private static final Map kernels;
    private static final ReferenceQueue queue;
    private static final String[] NO_TYPES;
    private static final Object[] NO_ARGS;
    private static final ObjectName CONFIGURATION_MANAGER_NAME;
    private static final ObjectName CONFIGURATION_STORE_PATTERN;
    private final String kernelName;
    private final String domainName;
    private Log log;
    private boolean running;
    private Date bootTime;
    private MBeanServer mbServer;
    private LinkedList shutdownHooks = new LinkedList();
    private DependencyManager dependencyManager;
    private ConfigurationManager configurationManager;
    private GBeanMBean configurationManagerGBean;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Kernel() {
        this.kernelName = null;
        this.domainName = null;
    }

    public Kernel(String kernelName) {
        this.kernelName = kernelName;
        this.domainName = kernelName;
    }

    public Kernel(String kernelName, String domainName) {
        this.kernelName = kernelName;
        this.domainName = domainName;
    }

    public MBeanServer getMBeanServer() {
        return this.mbServer;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getKernel(String name) {
        if (name == null) {
            return Kernel.getSingleKernel();
        }
        Map map = kernels;
        synchronized (map) {
            Kernel.processQueue();
            KernelReference ref = (KernelReference)kernels.get(name);
            if (ref != null) {
                return (Kernel)ref.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kernel getSingleKernel() {
        Map map = kernels;
        synchronized (map) {
            Kernel.processQueue();
            int size = kernels.size();
            if (size > 1) {
                throw new IllegalStateException("More than one kernel has been registered.");
            }
            if (size < 1) {
                return null;
            }
            Kernel result = (Kernel)((KernelReference)kernels.values().iterator().next()).get();
            if (result == null) {
                kernels.clear();
            }
            return result;
        }
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws Exception {
        try {
            return this.mbServer.getAttribute(objectName, attributeName);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public void setAttribute(ObjectName objectName, String attributeName, Object attributeValue) throws Exception {
        try {
            this.mbServer.setAttribute(objectName, new Attribute(attributeName, attributeValue));
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public Object invoke(ObjectName objectName, String methodName) throws Exception {
        return this.invoke(objectName, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] types) throws Exception {
        try {
            return this.mbServer.invoke(objectName, methodName, args, types);
        }
        catch (Exception e) {
            Throwable cause = this.unwrapJMException(e);
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    private Throwable unwrapJMException(Throwable cause) {
        while ((cause instanceof JMException || cause instanceof JMRuntimeException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public boolean isLoaded(ObjectName name) {
        return this.mbServer != null && this.mbServer.isRegistered(name);
    }

    public GBeanInfo getGBeanInfo(ObjectName name) throws InstanceNotFoundException {
        try {
            return (GBeanInfo)this.getAttribute(name, "gbeanInfo");
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GBeanData getGBeanData(ObjectName name) throws InstanceNotFoundException {
        try {
            return (GBeanData)this.getAttribute(name, "$$GBEAN_DATA$$");
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"getGBeanData can not throw checked exceptions"))).initCause(e));
        }
    }

    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws InstanceAlreadyExistsException, InvalidConfigException {
        try {
            GBeanMBean gbean = new GBeanMBean(gbeanData, classLoader);
            this.mbServer.registerMBean(gbean, gbeanData.getName());
        }
        catch (JMRuntimeException e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + gbeanData.getName(), this.unwrapJMException(e));
        }
        catch (JMException e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + gbeanData.getName(), this.unwrapJMException(e));
        }
    }

    public void loadGBean(ObjectName name, GBeanMBean gbean) throws InstanceAlreadyExistsException, InvalidConfigException {
        try {
            this.mbServer.registerMBean(gbean, name);
        }
        catch (InstanceAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, this.unwrapJMException(e));
        }
    }

    public void startGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "start");
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, this.unwrapJMException(e));
        }
    }

    public void startRecursiveGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "startRecursive");
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void stopGBean(ObjectName name) throws InstanceNotFoundException, InvalidConfigException {
        try {
            this.invoke(name, "stop");
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Invalid GBean configuration for " + name, e);
        }
    }

    public void unloadGBean(ObjectName name) throws InstanceNotFoundException {
        try {
            this.mbServer.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (JMException e) {
            throw (IllegalStateException)new IllegalStateException("Error unloading GBean " + name).initCause(this.unwrapJMException(e));
        }
    }

    public Set listGBeans(ObjectName query) {
        return this.mbServer.queryNames(query, null);
    }

    public List listConfigurationStores() {
        return this.getConfigurationManager().listStores();
    }

    public List listConfigurations(ObjectName storeName) throws NoSuchStoreException {
        return this.getConfigurationManager().listConfigurations(storeName);
    }

    public ObjectName startConfiguration(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        ObjectName configName = this.getConfigurationManager().load(configID);
        try {
            this.startRecursiveGBean(configName);
        }
        catch (InstanceNotFoundException e) {
            throw new InvalidConfigException(e);
        }
        return configName;
    }

    public void stopConfiguration(URI configID) throws NoSuchConfigException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        try {
            ObjectName configName = Configuration.getConfigurationObjectName(configID);
            this.stopGBean(configName);
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new NoSuchConfigException(e);
        }
        catch (InvalidConfigException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        configurationManager.unload(configID);
    }

    public int getConfigurationState(URI configID) throws NoSuchConfigException {
        try {
            ObjectName configName = Configuration.getConfigurationObjectName(configID);
            return (Integer)this.getAttribute(configName, "state");
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new NoSuchConfigException(e);
        }
        catch (InvalidConfigException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (Exception e) {
            throw new NoSuchConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.bootTime = new Date();
        this.log = LogFactory.getLog((String)Kernel.class.getName());
        this.log.info((Object)"Starting boot");
        Map map = kernels;
        synchronized (map) {
            if (kernels.containsKey(this.kernelName)) {
                throw new IllegalStateException("A kernel is already running this kernel name: " + this.kernelName);
            }
            kernels.put(this.kernelName, new KernelReference(this.kernelName, this));
        }
        this.mbServer = MBeanServerFactory.createMBeanServer(this.domainName);
        this.mbServer.registerMBean(this, KERNEL);
        this.dependencyManager = new DependencyManager(this.mbServer);
        this.configurationManagerGBean = new GBeanMBean(ConfigurationManagerImpl.GBEAN_INFO);
        this.configurationManagerGBean.setReferencePatterns("Stores", Collections.singleton(CONFIGURATION_STORE_PATTERN));
        this.mbServer.registerMBean(this.configurationManagerGBean, CONFIGURATION_MANAGER_NAME);
        this.configurationManagerGBean.start();
        this.configurationManager = (ConfigurationManager)this.configurationManagerGBean.getTarget();
        this.running = true;
        this.log.info((Object)"Booted");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook(Runnable hook) {
        if (!$assertionsDisabled && hook == null) {
            throw new AssertionError((Object)"Shutdown hook was null");
        }
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShutdownHook(Runnable hook) {
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.info((Object)"Starting kernel shutdown");
        this.notifyShutdownHooks();
        this.shutdownConfigManager();
        try {
            this.mbServer.unregisterMBean(KERNEL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dependencyManager.close();
        this.dependencyManager = null;
        MBeanServerFactory.releaseMBeanServer(this.mbServer);
        this.mbServer = null;
        Object object = this;
        synchronized (object) {
            this.notify();
        }
        object = kernels;
        synchronized (object) {
            kernels.remove(this.kernelName);
        }
        this.log.info((Object)"Kernel shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownHooks() {
        while (!this.shutdownHooks.isEmpty()) {
            Runnable hook;
            LinkedList linkedList = this.shutdownHooks;
            synchronized (linkedList) {
                hook = (Runnable)this.shutdownHooks.removeFirst();
            }
            try {
                hook.run();
            }
            catch (Throwable e) {
                this.log.warn((Object)"Error from kernel shutdown hook", e);
            }
        }
    }

    private void shutdownConfigManager() {
        this.configurationManager = null;
        try {
            if (this.configurationManagerGBean != null) {
                this.configurationManagerGBean.stop();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.configurationManagerGBean != null) {
                this.mbServer.unregisterMBean(CONFIGURATION_MANAGER_NAME);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.configurationManagerGBean = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.mbServer.getClassLoaderFor(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() {
        KernelReference kernelRef;
        while ((kernelRef = (KernelReference)queue.poll()) != null) {
            Map map = kernels;
            synchronized (map) {
                kernels.remove(kernelRef.key);
            }
        }
    }

    static {
        $assertionsDisabled = !Kernel.class.desiredAssertionStatus();
        KERNEL = JMXUtil.getObjectName("geronimo.boot:role=Kernel");
        kernels = new HashMap();
        queue = new ReferenceQueue();
        NO_TYPES = new String[0];
        NO_ARGS = new Object[0];
        CONFIGURATION_MANAGER_NAME = JMXUtil.getObjectName("geronimo.boot:role=ConfigurationManager");
        CONFIGURATION_STORE_PATTERN = JMXUtil.getObjectName("*:role=ConfigurationStore,*");
    }

    private static class KernelReference
    extends WeakReference {
        private final Object key;

        public KernelReference(Object key, Object kernel) {
            super(kernel, queue);
            this.key = key;
        }
    }
}

