/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationParent;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;

public class Configuration
implements GBeanLifecycle {
    private static final Log log;
    private final Kernel kernel;
    private final String objectNameString;
    private final ObjectName objectName;
    private final URI id;
    private final ConfigurationModuleType moduleType;
    private final URI parentID;
    private final ConfigurationParent parent;
    private final List classPath;
    private final List dependencies;
    private byte[] gbeanState;
    private final Collection repositories;
    private final ConfigurationStore configurationStore;
    private URL baseURL;
    private Map gbeans;
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ObjectName getConfigurationObjectName(URI configID) throws MalformedObjectNameException {
        return new ObjectName("geronimo.config:name=" + ObjectName.quote(configID.toString()));
    }

    public Configuration(Kernel kernel, String objectName, URI id, ConfigurationModuleType moduleType, URI parentID, ConfigurationParent parent, List classPath, byte[] gbeanState, Collection repositories, List dependencies, ConfigurationStore configurationStore) {
        this.kernel = kernel;
        this.objectNameString = objectName;
        this.objectName = JMXUtil.getObjectName(objectName);
        this.id = id;
        this.moduleType = moduleType;
        this.parentID = parentID;
        this.parent = parent;
        this.gbeanState = gbeanState;
        this.classPath = classPath == null ? Collections.EMPTY_LIST : classPath;
        this.dependencies = dependencies == null ? Collections.EMPTY_LIST : dependencies;
        this.repositories = repositories;
        this.configurationStore = configurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        URI uri;
        URL[] urls = new URL[this.dependencies.size() + this.classPath.size()];
        int idx = 0;
        Iterator i = this.dependencies.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            URL url = null;
            Iterator j = this.repositories.iterator();
            while (j.hasNext()) {
                Repository repository = (Repository)j.next();
                if (!repository.hasURI(uri)) continue;
                url = repository.getURL(uri);
                break;
            }
            if (url == null) {
                throw new MissingDependencyException("Unable to resolve dependency " + uri);
            }
            urls[idx++] = url;
        }
        i = this.classPath.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            urls[idx++] = new URL(this.baseURL, uri.toString());
        }
        if (!$assertionsDisabled && idx != urls.length) {
            throw new AssertionError();
        }
        log.debug((Object)("ClassPath for " + this.id + " resolved to " + Arrays.asList(urls)));
        this.classLoader = this.parent == null ? new URLClassLoader(urls, this.getClass().getClassLoader()) : new URLClassLoader(urls, this.parent.getClassLoader());
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.gbeans = Configuration.loadGBeans(this.gbeanState, this.classLoader);
            Iterator<Object> i2 = this.gbeans.values().iterator();
            while (i2.hasNext()) {
                GBeanMBean gbean = (GBeanMBean)i2.next();
                Configuration.setGBeanBaseUrl(gbean, this.baseURL);
            }
            i2 = this.gbeans.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = (Map.Entry)i2.next();
                ObjectName name = (ObjectName)entry.getKey();
                GBeanMBean gbean = (GBeanMBean)entry.getValue();
                log.trace((Object)("Registering GBean " + name));
                try {
                    this.kernel.loadGBean(name, gbean);
                }
                catch (JMRuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw e;
                }
                this.kernel.getDependencyManager().addDependency(name, this.objectName);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        log.info((Object)("Started configuration " + this.id));
    }

    public String getObjectName() {
        return this.objectNameString;
    }

    private static void setGBeanBaseUrl(GBeanMBean gbean, URL baseUrl) throws ReflectionException, AttributeNotFoundException {
        GBeanInfo gbeanInfo = gbean.getGBeanInfo();
        Set attributes = gbeanInfo.getAttributes();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attribute = (GAttributeInfo)iterator.next();
            if (!attribute.getName().equals("configurationBaseUrl") || !attribute.getType().equals("java.net.URL")) continue;
            gbean.setAttribute("configurationBaseUrl", (Object)baseUrl);
            return;
        }
    }

    public void doStop() throws Exception {
        log.info((Object)("Stopping configuration " + this.id));
        if (this.gbeans == null) {
            return;
        }
        Iterator i = this.gbeans.keySet().iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            this.kernel.getDependencyManager().removeDependency(name, this.objectName);
            try {
                log.trace((Object)("Unregistering GBean " + name));
                this.kernel.unloadGBean(name);
            }
            catch (Exception e) {
                log.warn((Object)("Could not unregister child " + name), (Throwable)e);
            }
        }
        try {
            this.gbeanState = Configuration.storeGBeans(this.gbeans);
        }
        catch (InvalidConfigException e) {
            log.info((Object)e);
        }
        if (this.configurationStore != null) {
            this.configurationStore.updateConfiguration(this);
        }
        this.gbeans = null;
    }

    public void doFail() {
    }

    public URI getParentID() {
        return this.parentID;
    }

    public URI getID() {
        return this.id;
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public byte[] getGbeanState() {
        return this.gbeanState;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadGBeans(byte[] gbeanState, ClassLoader cl) throws InvalidConfigException {
        HashMap<ObjectName, GBeanMBean> gbeans = new HashMap<ObjectName, GBeanMBean>();
        try {
            ConfigInputStream ois = new ConfigInputStream(new ByteArrayInputStream(gbeanState), cl);
            try {
                try {
                    while (true) {
                        GBeanData gbeanData = new GBeanData();
                        gbeanData.readExternal(ois);
                        GBeanMBean gbean = new GBeanMBean(gbeanData, cl);
                        gbeans.put(gbeanData.getName(), gbean);
                    }
                }
                catch (EOFException e) {
                    ois.close();
                }
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            return gbeans;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to deserialize GBeanState", e);
        }
    }

    public static byte[] storeGBeans(Map gbeans) throws InvalidConfigException {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(baos);
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to initialize ObjectOutputStream"))).initCause(e));
        }
        Iterator i = gbeans.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ObjectName objectName = (ObjectName)entry.getKey();
            GBeanMBean gbean = (GBeanMBean)entry.getValue();
            try {
                GBeanData gbeanData = gbean.getGBeanData();
                gbeanData.setName(objectName);
                gbeanData.writeExternal(oos);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to serialize GBeanState for " + objectName, e);
            }
        }
        try {
            oos.flush();
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to flush ObjectOutputStream"))).initCause(e));
        }
        return baos.toByteArray();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !Configuration.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)Configuration.class);
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(Configuration.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("ID", URI.class, true);
        infoFactory.addAttribute("type", ConfigurationModuleType.class, true);
        infoFactory.addAttribute("parentID", URI.class, true);
        infoFactory.addAttribute("classPath", List.class, true);
        infoFactory.addAttribute("dependencies", List.class, true);
        infoFactory.addAttribute("gBeanState", [B.class, true);
        infoFactory.addAttribute("baseURL", URL.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addReference("Parent", ConfigurationParent.class);
        infoFactory.addReference("Repositories", Repository.class);
        infoFactory.addReference("ConfigurationStore", ConfigurationStore.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "ID", "type", "parentID", "Parent", "classPath", "gBeanState", "Repositories", "dependencies", "ConfigurationStore"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ConfigInputStream
    extends ObjectInputStream {
        private final ClassLoader cl;

        public ConfigInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cl = cl;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return this.cl.loadClass(desc.getName());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
    }
}

