/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.management.State;

public class ConfigurationManagerImpl
implements ConfigurationManager,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ConfigurationManagerImpl.class);
    private final Kernel kernel;
    private final Collection stores;
    private static final ObjectName CONFIG_QUERY = JMXUtil.getObjectName("geronimo.config:*");
    public static final GBeanInfo GBEAN_INFO;

    public ConfigurationManagerImpl(Kernel kernel, Collection stores) {
        this.kernel = kernel;
        this.stores = stores;
    }

    public List listStores() {
        List storeSnapshot = this.getStores();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(storeSnapshot.size());
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            result.add(JMXUtil.getObjectName(store.getObjectName()));
        }
        return result;
    }

    public List listConfigurations(ObjectName storeName) throws NoSuchStoreException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!storeName.equals(JMXUtil.getObjectName(store.getObjectName()))) continue;
            List ids = store.listConfiguations();
            ArrayList<ConfigurationInfo> result = new ArrayList<ConfigurationInfo>(ids.size());
            for (int j = 0; j < ids.size(); ++j) {
                State state;
                ObjectName configName;
                URI configID = (URI)ids.get(j);
                try {
                    configName = Configuration.getConfigurationObjectName(configID);
                }
                catch (MalformedObjectNameException e) {
                    throw new AssertionError((Object)("Store returned invalid configID: " + configID));
                }
                if (this.kernel.isLoaded(configName)) {
                    try {
                        state = State.fromInteger((Integer)this.kernel.getAttribute(configName, "state"));
                    }
                    catch (Exception e) {
                        state = null;
                    }
                } else {
                    state = State.STOPPED;
                }
                ConfigurationModuleType type = null;
                try {
                    GBeanMBean bean = store.getConfiguration(configID);
                    type = (ConfigurationModuleType)bean.getAttribute("type");
                }
                catch (Exception e) {
                    log.error((Object)(store + " defines configID " + configID + " which can not be loaded."));
                }
                result.add(new ConfigurationInfo(storeName, configID, state, type));
            }
            return result;
        }
        throw new NoSuchStoreException("No such store: " + storeName);
    }

    public boolean isLoaded(URI configID) {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            return this.kernel.isLoaded(name);
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
    }

    public ObjectName load(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configID)) continue;
            GBeanMBean config = store.getConfiguration(configID);
            URL baseURL = store.getBaseURL(configID);
            return this.load(config, baseURL);
        }
        throw new NoSuchConfigException("No configuration with id: " + configID);
    }

    public ObjectName load(GBeanMBean config, URL rootURL) throws InvalidConfigException {
        ObjectName configName;
        URI configID;
        try {
            configID = (URI)config.getAttribute("ID");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Cannot get config ID", e);
        }
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert ID to ObjectName: ", e);
        }
        this.load(config, rootURL, configName);
        return configName;
    }

    public void load(GBeanData config, URL rootURL, ClassLoader classLoader) throws InvalidConfigException {
        GBeanMBean mbean = new GBeanMBean(config, classLoader);
        this.load(mbean, rootURL, config.getName());
    }

    public void load(GBeanMBean config, URL rootURL, ObjectName configName) throws InvalidConfigException {
        try {
            this.kernel.loadGBean(configName, config);
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to register configuration", e);
        }
        try {
            config.setAttribute("baseURL", (Object)rootURL);
        }
        catch (Exception e) {
            try {
                this.kernel.unloadGBean(configName);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new InvalidConfigException("Cannot set baseURL", e);
        }
        log.info((Object)("Loaded Configuration " + configName));
    }

    public List loadRecursive(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        try {
            LinkedList<ObjectName> ancestors = new LinkedList<ObjectName>();
            while (configID != null && !this.isLoaded(configID)) {
                ObjectName name = this.load(configID);
                ancestors.addFirst(name);
                configID = (URI)this.kernel.getAttribute(name, "parentID");
            }
            return ancestors;
        }
        catch (NoSuchConfigException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException(e);
        }
    }

    public void unload(URI configID) throws NoSuchConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException("Cannot convert ID to ObjectName: ", e);
        }
        this.unload(configName);
    }

    public void unload(ObjectName configName) throws NoSuchConfigException {
        try {
            this.kernel.unloadGBean(configName);
        }
        catch (InstanceNotFoundException e) {
            throw new NoSuchConfigException("No config registered: " + configName, e);
        }
        log.info((Object)("Unloaded Configuration " + configName));
    }

    private List getStores() {
        return new ArrayList(this.stores);
    }

    public void doStart() {
    }

    public void doStop() {
        Set configs;
        block5: while (!(configs = this.kernel.listGBeans(CONFIG_QUERY)).isEmpty()) {
            Iterator i = configs.iterator();
            while (true) {
                if (!i.hasNext()) continue block5;
                ObjectName configName = (ObjectName)i.next();
                if (!this.kernel.isLoaded(configName)) continue;
                try {
                    this.kernel.stopGBean(configName);
                }
                catch (InstanceNotFoundException e) {
                }
                catch (InvalidConfigException e) {
                    log.warn((Object)("Could not stop configuration: " + configName), (Throwable)e);
                }
                try {
                    this.kernel.unloadGBean(configName);
                }
                catch (InstanceNotFoundException e) {
                }
            }
            break;
        }
        return;
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ConfigurationManagerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("Stores", ConfigurationStore.class);
        infoFactory.addInterface(ConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

