/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import [Ljava.lang.String;;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.log.GeronimoLogging;

public class Run {
    private static final String[] MAIN_ARGS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ObjectName gbeanName;
        ClassLoader cl = Run.class.getClassLoader();
        try {
            InputStream is = cl.getResourceAsStream("META-INF/MANIFEST.MF");
            try {
                Manifest mf = new Manifest(is);
                Attributes attrs = mf.getMainAttributes();
                gbeanName = new ObjectName(attrs.getValue("Geronimo-GBean"));
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            throw new AssertionError();
        }
        final Kernel kernel = new Kernel("geronimo.kernel", "geronimo");
        try {
            GBeanMBean config;
            kernel.boot();
            ObjectInputStream ois = new ObjectInputStream(cl.getResourceAsStream("META-INF/config.ser"));
            try {
                GBeanData gbeanData = new GBeanData();
                gbeanData.readExternal(ois);
                config = new GBeanMBean(gbeanData, cl);
            }
            finally {
                ois.close();
            }
            final ObjectName configName = kernel.getConfigurationManager().load(config, cl.getResource("/"));
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown Thread"){

                public void run() {
                    try {
                        kernel.stopGBean(configName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    kernel.shutdown();
                }
            });
            kernel.startGBean(configName);
            kernel.getMBeanServer().invoke(gbeanName, "main", new Object[]{args}, MAIN_ARGS);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
            throw new AssertionError();
        }
    }

    static {
        GeronimoLogging.initialize(GeronimoLogging.INFO);
        MAIN_ARGS = new String[]{String;.class.getName()};
    }
}

