/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.management;

import javax.management.Notification;
import javax.management.NotificationFilter;

public final class NotificationType {
    public static final String OBJECT_CREATED = "j2ee.object.created";
    public static final String OBJECT_DELETED = "j2ee.object.deleted";
    public static final String STATE_STARTING = "j2ee.state.starting";
    public static final String STATE_RUNNING = "j2ee.state.running";
    public static final String STATE_STOPPING = "j2ee.state.stopping";
    public static final String STATE_STOPPED = "j2ee.state.stopped";
    public static final String STATE_FAILED = "j2ee.state.failed";
    public static final String ATTRIBUTE_CHANGED = "j2ee.attribute.changed";
    public static final String[] TYPES = new String[]{"j2ee.object.created", "j2ee.object.deleted", "j2ee.state.starting", "j2ee.state.running", "j2ee.state.stopping", "j2ee.state.stopped", "j2ee.state.failed", "j2ee.attribute.changed"};
    public static final NotificationFilter NOTIFICATION_FILTER = new J2EENotificationFilter();
    public static final NotificationFilter STATE_CHANGE_FILTER = new J2EEStateChangeFilter();

    private NotificationType() {
    }

    private static final class J2EEStateChangeFilter
    implements NotificationFilter {
        private J2EEStateChangeFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            String type = notification.getType();
            return NotificationType.STATE_STARTING.equals(type) || NotificationType.STATE_RUNNING.equals(type) || NotificationType.STATE_STOPPING.equals(type) || NotificationType.STATE_STOPPED.equals(type) || NotificationType.STATE_FAILED.equals(type);
        }
    }

    private static final class J2EENotificationFilter
    implements NotificationFilter {
        private J2EENotificationFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            String type = notification.getType();
            for (int i = 0; i < TYPES.length; ++i) {
                if (!TYPES[i].equals(type)) continue;
                return true;
            }
            return false;
        }
    }
}

