/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.State;

public class GBeanInstanceState {
    private static final Log log;
    private final GBeanInstance gbeanInstance;
    private final Kernel kernel;
    private final ObjectName objectName;
    private final DependencyManager dependencyManager;
    private final LifecycleBroadcaster lifecycleBroadcaster;
    private LifecycleListener blockerListener;
    private volatile State state = State.STOPPED;
    static final /* synthetic */ boolean $assertionsDisabled;

    GBeanInstanceState(ObjectName objectName, Kernel kernel, DependencyManager dependencyManager, GBeanInstance gbeanInstance, LifecycleBroadcaster lifecycleBroadcaster) {
        this.objectName = objectName;
        this.kernel = kernel;
        this.dependencyManager = dependencyManager;
        this.gbeanInstance = gbeanInstance;
        this.lifecycleBroadcaster = lifecycleBroadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        State originalState;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        GBeanInstanceState gBeanInstanceState = this;
        synchronized (gBeanInstanceState) {
            originalState = this.getStateInstance();
            if (originalState == State.RUNNING) {
                return;
            }
            if (originalState != State.STARTING) {
                this.setStateInstance(State.STARTING);
            }
        }
        if (originalState != State.STARTING) {
            this.lifecycleBroadcaster.fireStartingEvent();
        }
        this.attemptFullStart();
    }

    public final void startRecursive() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        State state = this.getStateInstance();
        if (state != State.STOPPED && state != State.FAILED) {
            return;
        }
        this.start();
        Set dependents = this.dependencyManager.getChildren(this.objectName);
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            ObjectName dependent = (ObjectName)iterator.next();
            try {
                if (!((Boolean)this.kernel.getAttribute(dependent, "gbeanEnabled")).booleanValue()) continue;
                this.kernel.startRecursiveGBean(dependent);
            }
            catch (NoSuchAttributeException e) {
            }
            catch (GBeanNotFoundException e) {
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        State originalState;
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        GBeanInstanceState gBeanInstanceState = this;
        synchronized (gBeanInstanceState) {
            originalState = this.getStateInstance();
            if (originalState == State.STOPPED) {
                return;
            }
            if (originalState != State.STOPPING) {
                this.setStateInstance(State.STOPPING);
            }
        }
        if (originalState != State.STOPPING) {
            this.lifecycleBroadcaster.fireStoppingEvent();
        }
        Set dependents = this.dependencyManager.getChildren(this.objectName);
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            ObjectName child = (ObjectName)iterator.next();
            try {
                log.trace((Object)("Checking if child is running: child=" + child));
                if (this.kernel.getGBeanState(child) != 1) continue;
                log.trace((Object)("Stopping child: child=" + child));
                this.kernel.stopGBean(child);
                log.trace((Object)("Stopped child: child=" + child));
            }
            catch (Exception ignore) {}
        }
        this.attemptFullStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fail() {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
        }
        GBeanInstanceState gBeanInstanceState = this;
        synchronized (gBeanInstanceState) {
            State state = this.getStateInstance();
            if (state == State.STOPPED || state == State.FAILED) {
                return;
            }
        }
        try {
            if (this.gbeanInstance.destroyInstance(false)) {
                return;
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Problem in doFail", e);
        }
        this.setStateInstance(State.FAILED);
        this.lifecycleBroadcaster.fireFailedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptFullStart() {
        block17: {
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
            }
            GBeanInstanceState gBeanInstanceState = this;
            synchronized (gBeanInstanceState) {
                if (this.getStateInstance() != State.STARTING) {
                    return;
                }
                if (this.blockerListener != null) {
                    log.trace((Object)"Cannot run because gbean is still being blocked");
                    return;
                }
                final ObjectName blocker = this.dependencyManager.checkBlocker(this.objectName);
                if (blocker != null) {
                    this.blockerListener = new LifecycleAdapter(){

                        public void stopped(ObjectName objectName) {
                            this.checkBlocker(objectName);
                        }

                        public void failed(ObjectName objectName) {
                            this.checkBlocker(objectName);
                        }

                        public void unloaded(ObjectName objectName) {
                            this.checkBlocker(objectName);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void checkBlocker(ObjectName objectName) {
                            GBeanInstanceState gBeanInstanceState = GBeanInstanceState.this;
                            synchronized (gBeanInstanceState) {
                                if (!objectName.equals(blocker)) {
                                    return;
                                }
                                GBeanInstanceState.this.kernel.getLifecycleMonitor().removeLifecycleListener(this);
                                GBeanInstanceState.this.blockerListener = null;
                            }
                            try {
                                GBeanInstanceState.this.attemptFullStart();
                            }
                            catch (Exception e) {
                                log.warn((Object)"A problem occured while attempting to start", (Throwable)e);
                            }
                        }
                    };
                    this.kernel.getLifecycleMonitor().addLifecycleListener(this.blockerListener, blocker);
                    return;
                }
                Set parents = this.dependencyManager.getParents(this.objectName);
                Iterator i = parents.iterator();
                while (i.hasNext()) {
                    ObjectName parent = (ObjectName)i.next();
                    if (!this.kernel.isLoaded(parent)) {
                        log.trace((Object)("Cannot run because parent is not registered: parent=" + parent));
                        return;
                    }
                    try {
                        log.trace((Object)("Checking if parent is running: parent=" + parent));
                        if (this.kernel.getGBeanState(parent) != 1) {
                            log.trace((Object)("Cannot run because parent is not running: parent=" + parent));
                            return;
                        }
                        log.trace((Object)("Parent is running: parent=" + parent));
                    }
                    catch (GBeanNotFoundException e) {
                        log.trace((Object)("Cannot run because parent is not registered: parent=" + parent));
                        return;
                    }
                    catch (Exception e) {
                        log.trace((Object)("Cannot run because an error occurred while checking if parent is running: parent=" + parent));
                        return;
                    }
                }
            }
            try {
                if (!this.gbeanInstance.createInstance()) {
                    return;
                }
            }
            catch (Throwable t) {
                log.error((Object)("Error while starting; GBean is now in the FAILED state: objectName=\"" + this.objectName + "\""), t);
                this.setStateInstance(State.FAILED);
                this.lifecycleBroadcaster.fireFailedEvent();
                if (t instanceof Exception) break block17;
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error(t);
            }
        }
        this.setStateInstance(State.RUNNING);
        this.lifecycleBroadcaster.fireRunningEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptFullStop() {
        block14: {
            if (!$assertionsDisabled && Thread.holdsLock(this)) {
                throw new AssertionError((Object)"This method cannot be called while holding a synchronized lock on this");
            }
            GBeanInstanceState gBeanInstanceState = this;
            synchronized (gBeanInstanceState) {
                if (this.getStateInstance() != State.STOPPING) {
                    return;
                }
                Set children = this.dependencyManager.getChildren(this.objectName);
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    ObjectName child = (ObjectName)i.next();
                    if (!this.kernel.isLoaded(child)) continue;
                    try {
                        log.trace((Object)("Checking if child is stopped: child=" + child));
                        int state = (Integer)this.kernel.getAttribute(child, "State");
                        if (state != 1) continue;
                        log.trace((Object)("Cannot stop because child is still running: child=" + child));
                        return;
                    }
                    catch (NoSuchAttributeException e) {
                        log.trace((Object)"Child does not have a State attibute");
                    }
                    catch (GBeanNotFoundException e) {
                    }
                    catch (Exception e) {
                        log.trace((Object)("Cannot run because an error occurred while checking if child is stopped: child=" + child));
                        return;
                    }
                }
            }
            try {
                if (!this.gbeanInstance.destroyInstance(true)) {
                    return;
                }
            }
            catch (Throwable t) {
                log.error((Object)("Error while stopping; GBean is now in the FAILED state: objectName=\"" + this.objectName + "\""), t);
                this.setStateInstance(State.FAILED);
                this.lifecycleBroadcaster.fireFailedEvent();
                if (t instanceof Exception) break block14;
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error(t);
            }
        }
        this.setStateInstance(State.STOPPED);
        this.lifecycleBroadcaster.fireStoppedEvent();
    }

    public int getState() {
        return this.state.toInt();
    }

    public final State getStateInstance() {
        return this.state;
    }

    private synchronized void setStateInstance(State newState) throws IllegalStateException {
        block0 : switch (this.state.toInt()) {
            case 3: {
                switch (newState.toInt()) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 0: {
                switch (newState.toInt()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 3: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 1: {
                switch (newState.toInt()) {
                    case 2: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 3: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 2: {
                switch (newState.toInt()) {
                    case 3: 
                    case 4: {
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
                break;
            }
            case 4: {
                switch (newState.toInt()) {
                    case 0: 
                    case 2: {
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        throw new IllegalStateException("Cannot transition to " + newState + " state from " + this.state);
                    }
                }
            }
        }
        log.debug((Object)(this.toString() + " State changed from " + this.state + " to " + newState));
        this.state = newState;
    }

    public String toString() {
        return "GBeanInstanceState for: " + this.objectName;
    }

    static {
        $assertionsDisabled = !GBeanInstanceState.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GBeanInstanceState.class);
    }
}

