/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelGBean;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.basic.BasicDependencyManager;
import org.apache.geronimo.kernel.basic.BasicLifecycleMonitor;
import org.apache.geronimo.kernel.basic.BasicProxyManager;
import org.apache.geronimo.kernel.basic.BasicRegistry;
import org.apache.geronimo.kernel.basic.LifecycleMonitorFlyweight;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class BasicKernel
implements Kernel {
    private static final String[] NO_TYPES;
    private static final Object[] NO_ARGS;
    private final String kernelName;
    private Log log;
    private boolean running;
    private Date bootTime;
    private final BasicRegistry registry;
    private LinkedList shutdownHooks = new LinkedList();
    private DependencyManager dependencyManager;
    private BasicLifecycleMonitor lifecycleMonitor;
    private LifecycleMonitor publicLifecycleMonitor;
    private ProxyManager proxyManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicKernel(String kernelName) {
        if (kernelName.indexOf(58) >= 0 || kernelName.indexOf(42) >= 0 || kernelName.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Kernel name may not contain a ':', '*' or '?' character");
        }
        this.kernelName = kernelName;
        this.registry = new BasicRegistry(kernelName);
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public LifecycleMonitor getLifecycleMonitor() {
        return this.publicLifecycleMonitor;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public Object getAttribute(ObjectName name, String attributeName) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getAttribute(attributeName);
    }

    public void setAttribute(ObjectName name, String attributeName, Object attributeValue) throws GBeanNotFoundException, NoSuchAttributeException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.setAttribute(attributeName, attributeValue);
    }

    public Object invoke(ObjectName name, String methodName) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        return this.invoke(name, methodName, NO_ARGS, NO_TYPES);
    }

    public Object invoke(ObjectName name, String methodName, Object[] args, String[] types) throws GBeanNotFoundException, NoSuchOperationException, InternalKernelException, Exception {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.invoke(methodName, args, types);
    }

    public boolean isLoaded(ObjectName name) {
        return this.registry.isRegistered(name);
    }

    public GBeanInfo getGBeanInfo(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanInfo();
    }

    public GBeanData getGBeanData(ObjectName name) throws GBeanNotFoundException, InternalKernelException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getGBeanData();
    }

    public void loadGBean(GBeanData gbeanData, ClassLoader classLoader) throws GBeanAlreadyExistsException, InternalKernelException {
        ObjectName name = gbeanData.getName();
        GBeanInstance gbeanInstance = new GBeanInstance(gbeanData, this, this.dependencyManager, this.lifecycleMonitor.createLifecycleBroadcaster(name), classLoader);
        this.registry.register(gbeanInstance);
    }

    public void startGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.start();
    }

    public void startRecursiveGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.startRecursive();
    }

    public void stopGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.stop();
    }

    public void unloadGBean(ObjectName name) throws GBeanNotFoundException, InternalKernelException, IllegalStateException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.die();
        this.registry.unregister(name);
    }

    public int getGBeanState(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getState();
    }

    public long getGBeanStartTime(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getStartTime();
    }

    public boolean isGBeanEnabled(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.isEnabled();
    }

    public void setGBeanEnabled(ObjectName name, boolean enabled) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        gbeanInstance.setEnabled(enabled);
    }

    public Set listGBeans(ObjectName pattern) {
        return this.registry.listGBeans(pattern);
    }

    public Set listGBeans(Set patterns) {
        HashSet gbeans = new HashSet();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            ObjectName pattern = (ObjectName)iterator.next();
            gbeans.addAll(this.listGBeans(pattern));
        }
        return gbeans;
    }

    public void boot() throws Exception {
        if (this.running) {
            return;
        }
        this.bootTime = new Date();
        this.log = LogFactory.getLog((String)BasicKernel.class.getName());
        this.log.info((Object)"Starting boot");
        KernelRegistry.registerKernel(this);
        this.registry.start(this);
        this.lifecycleMonitor = new BasicLifecycleMonitor(this);
        this.publicLifecycleMonitor = new LifecycleMonitorFlyweight(this.lifecycleMonitor);
        this.dependencyManager = new BasicDependencyManager(this.publicLifecycleMonitor);
        this.proxyManager = new BasicProxyManager(this);
        GBeanData kernelGBeanData = new GBeanData(KERNEL, KernelGBean.GBEAN_INFO);
        this.loadGBean(kernelGBeanData, this.getClass().getClassLoader());
        this.startGBean(KERNEL);
        this.running = true;
        this.log.info((Object)"Booted");
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShutdownHook(Runnable hook) {
        if (!$assertionsDisabled && hook == null) {
            throw new AssertionError((Object)"Shutdown hook was null");
        }
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShutdownHook(Runnable hook) {
        LinkedList linkedList = this.shutdownHooks;
        synchronized (linkedList) {
            this.shutdownHooks.remove(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.log.info((Object)"Starting kernel shutdown");
        this.notifyShutdownHooks();
        this.registry.stop();
        this.dependencyManager.close();
        this.dependencyManager = null;
        BasicKernel basicKernel = this;
        synchronized (basicKernel) {
            this.notify();
        }
        KernelRegistry.unregisterKernel(this);
        this.log.info((Object)"Kernel shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdownHooks() {
        while (!this.shutdownHooks.isEmpty()) {
            Runnable hook;
            LinkedList linkedList = this.shutdownHooks;
            synchronized (linkedList) {
                hook = (Runnable)this.shutdownHooks.removeFirst();
            }
            try {
                hook.run();
            }
            catch (Throwable e) {
                this.log.warn((Object)"Error from kernel shutdown hook", e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance gbeanInstance = this.registry.getGBeanInstance(name);
        return gbeanInstance.getClassLoader();
    }

    static {
        $assertionsDisabled = !BasicKernel.class.desiredAssertionStatus();
        NO_TYPES = new String[0];
        NO_ARGS = new Object[0];
    }
}

