/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;

public class BasicRegistry {
    private final Map registry = new HashMap();
    private final Map domainIndex = new HashMap();
    private String defaultDomainName;

    public BasicRegistry(String defaultDomainName) {
        this.defaultDomainName = defaultDomainName;
    }

    public void start(Kernel kernel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            this.registry.clear();
            this.domainIndex.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName name) {
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            return this.registry.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void register(GBeanInstance gbeanInstance) throws GBeanAlreadyExistsException {
        ObjectName name = gbeanInstance.getObjectNameObject();
        if (this.registry.containsKey(name)) {
            throw new GBeanAlreadyExistsException("GBean already registered: " + name.getCanonicalName());
        }
        String domainName = name.getDomain();
        if (domainName.length() == 0) {
            domainName = this.defaultDomainName;
        }
        HashMap<String, String> properties = new HashMap<String, String>(name.getKeyPropertyList());
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            this.registry.put(name, gbeanInstance);
            HashMap<ObjectName, HashMap<String, String>> nameToProperties = (HashMap<ObjectName, HashMap<String, String>>)this.domainIndex.get(domainName);
            if (nameToProperties == null) {
                nameToProperties = new HashMap<ObjectName, HashMap<String, String>>();
                this.domainIndex.put(domainName, nameToProperties);
            }
            nameToProperties.put(name, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(ObjectName name) throws GBeanNotFoundException, InternalKernelException {
        String domainName = name.getDomain();
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            this.registry.remove(name);
            Map nameToProperties = (Map)this.domainIndex.get(domainName);
            if (nameToProperties != null) {
                nameToProperties.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GBeanInstance getGBeanInstance(ObjectName name) throws GBeanNotFoundException {
        GBeanInstance instance;
        BasicRegistry basicRegistry = this;
        synchronized (basicRegistry) {
            instance = (GBeanInstance)this.registry.get(name);
        }
        if (instance == null) {
            throw new GBeanNotFoundException(name);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listGBeans(ObjectName pattern) {
        Object map;
        ArrayList nameToProperties;
        BasicRegistry basicRegistry;
        if (pattern == null) {
            BasicRegistry basicRegistry2 = this;
            synchronized (basicRegistry2) {
                return new HashSet(this.registry.keySet());
            }
        }
        String patternDomain = pattern.getDomain();
        if (patternDomain.length() == 0) {
            patternDomain = this.defaultDomainName;
        }
        if (!pattern.isDomainPattern()) {
            basicRegistry = this;
            synchronized (basicRegistry) {
                nameToProperties = new ArrayList(this.registry.size());
                Map map2 = (Map)this.domainIndex.get(patternDomain);
                if (map2 != null) {
                    nameToProperties.addAll(map2.entrySet());
                }
            }
        }
        if (patternDomain.equals("*")) {
            basicRegistry = this;
            synchronized (basicRegistry) {
                nameToProperties = new ArrayList(this.registry.size());
                Iterator iterator = this.domainIndex.values().iterator();
                while (iterator.hasNext()) {
                    map = (Map)iterator.next();
                    nameToProperties.addAll(map.entrySet());
                }
            }
        }
        String perl5Pattern = BasicRegistry.domainPatternToPerl5(patternDomain);
        Pattern domainPattern = Pattern.compile(perl5Pattern);
        map = this;
        synchronized (map) {
            nameToProperties = new ArrayList(this.registry.size());
            Iterator iterator = this.domainIndex.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String domain = (String)entry.getKey();
                if (!domainPattern.matcher(domain).matches()) continue;
                Map map3 = (Map)entry.getValue();
                nameToProperties.addAll(map3.entrySet());
            }
        }
        if (nameToProperties.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashMap<String, String> patternProperties = new HashMap<String, String>(pattern.getKeyPropertyList());
        patternProperties.remove("*");
        boolean isMatchAll = patternProperties.isEmpty();
        boolean isPropertyPattern = pattern.isPropertyPattern();
        HashSet matchingNames = new HashSet();
        Iterator iterator = nameToProperties.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Map properties = (Map)entry.getValue();
            if (isMatchAll) {
                matchingNames.add(entry.getKey());
                continue;
            }
            if (isPropertyPattern) {
                if (!properties.entrySet().containsAll(patternProperties.entrySet())) continue;
                matchingNames.add(entry.getKey());
                continue;
            }
            if (!((Object)properties.entrySet()).equals(patternProperties.entrySet())) continue;
            matchingNames.add(entry.getKey());
        }
        return matchingNames;
    }

    private static String domainPatternToPerl5(String pattern) {
        char[] patternCharacters = pattern.toCharArray();
        StringBuffer buffer = new StringBuffer(2 * patternCharacters.length);
        block4: for (int position = 0; position < patternCharacters.length; ++position) {
            char character = patternCharacters[position];
            switch (character) {
                case '*': {
                    buffer.append(".*");
                    continue block4;
                }
                case '?': {
                    buffer.append('.');
                    continue block4;
                }
                default: {
                    if (BasicRegistry.isPerl5MetaCharacter(character)) {
                        buffer.append('\\');
                    }
                    buffer.append(character);
                }
            }
        }
        return buffer.toString();
    }

    private static boolean isPerl5MetaCharacter(char character) {
        return "'*?+[]()|^$.{}\\".indexOf(character) >= 0;
    }
}

