/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.reflect.FastClass;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.runtime.RawInvoker;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.KernelGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.KernelOperationInvoker;
import org.apache.geronimo.kernel.basic.KernelSetAttributeInvoker;
import org.apache.geronimo.kernel.basic.ProxyInvoker;
import org.apache.geronimo.kernel.basic.RawGetAttributeInvoker;
import org.apache.geronimo.kernel.basic.RawOperationInvoker;
import org.apache.geronimo.kernel.basic.RawSetAttributeInvoker;
import org.apache.geronimo.kernel.proxy.DeadProxyException;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class ProxyMethodInterceptor
implements MethodInterceptor {
    private final Class proxyType;
    private final ObjectName objectName;
    private ProxyInvoker[] gbeanInvokers;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public ProxyMethodInterceptor(Class proxyType, Kernel kernel, ObjectName objectName) {
        if (!$assertionsDisabled && proxyType == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && kernel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && objectName == null) {
            throw new AssertionError();
        }
        this.proxyType = proxyType;
        this.objectName = objectName;
        this.gbeanInvokers = this.createGBeanInvokers(kernel, objectName);
    }

    public synchronized void destroy() {
        this.gbeanInvokers = null;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        ProxyInvoker gbeanInvoker;
        int interfaceIndex = proxy.getSuperIndex();
        ProxyMethodInterceptor proxyMethodInterceptor = this;
        synchronized (proxyMethodInterceptor) {
            if (this.gbeanInvokers == null) {
                throw new DeadProxyException("Proxy is no longer valid");
            }
            gbeanInvoker = this.gbeanInvokers[interfaceIndex];
        }
        if (gbeanInvoker == null) {
            throw new UnsupportedOperationException("No implementation method: objectName=" + this.objectName + ", method=" + method);
        }
        return gbeanInvoker.invoke(this.objectName, args);
    }

    private ProxyInvoker[] createGBeanInvokers(Kernel kernel, ObjectName objectName) {
        ProxyInvoker[] invokers;
        try {
            RawInvoker rawInvoker = (RawInvoker)kernel.getAttribute(objectName, "$$RAW_INVOKER$$");
            invokers = this.createRawGBeanInvokers(rawInvoker, this.proxyType);
        }
        catch (Exception e) {
            invokers = this.createKernelGBeanInvokers(kernel, objectName, this.proxyType);
        }
        try {
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"equals", new Class[]{ProxyMethodInterceptor.class$java$lang$Object == null ? (ProxyMethodInterceptor.class$java$lang$Object = ProxyMethodInterceptor.class$((String)"java.lang.Object")) : ProxyMethodInterceptor.class$java$lang$Object}))] = new EqualsInvoke(kernel.getProxyManager());
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"hashCode", null))] = new HashCodeInvoke();
            invokers[ProxyMethodInterceptor.getSuperIndex((Class)this.proxyType, (Method)this.proxyType.getMethod((String)"toString", null))] = new ToStringInvoke(this.proxyType.getName());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return invokers;
    }

    private ProxyInvoker[] createRawGBeanInvokers(RawInvoker rawInvoker, Class proxyType) {
        Map operations = rawInvoker.getOperationIndex();
        Map attributes = rawInvoker.getAttributeIndex();
        FastClass fastClass = FastClass.create((Class)proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = ProxyMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createRawGBeanInvoker(rawInvoker, method, operations, attributes);
        }
        return invokers;
    }

    private ProxyInvoker createRawGBeanInvoker(RawInvoker rawInvoker, Method method, Map operations, Map attributes) {
        Integer methodIndex;
        String attributeName;
        if (operations.containsKey(new GOperationSignature(method))) {
            int methodIndex2 = (Integer)operations.get(new GOperationSignature(method));
            return new RawOperationInvoker(rawInvoker, methodIndex2);
        }
        if (method.getName().startsWith("get")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("is")) {
            attributeName = method.getName().substring(2);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawGetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        if (method.getName().startsWith("set")) {
            attributeName = method.getName().substring(3);
            methodIndex = (Integer)attributes.get(attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
            methodIndex = ProxyMethodInterceptor.getMethodIndex(attributes, attributeName);
            if (methodIndex != null) {
                return new RawSetAttributeInvoker(rawInvoker, methodIndex);
            }
        }
        return null;
    }

    private ProxyInvoker[] createKernelGBeanInvokers(Kernel kernel, ObjectName objectName, Class proxyType) {
        GBeanInfo info;
        try {
            info = kernel.getGBeanInfo(objectName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + objectName);
        }
        Set attributeInfos = info.getAttributes();
        HashSet<String> attributeNames = new HashSet<String>(attributeInfos.size());
        Iterator iterator = attributeInfos.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attributeInfo = (GAttributeInfo)iterator.next();
            attributeNames.add(attributeInfo.getName());
        }
        Set operationInfos = info.getOperations();
        HashSet<GOperationSignature> operationSignatures = new HashSet<GOperationSignature>(operationInfos.size());
        Iterator iterator2 = operationInfos.iterator();
        while (iterator2.hasNext()) {
            GOperationInfo operationInfo = (GOperationInfo)iterator2.next();
            operationSignatures.add(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()));
        }
        FastClass fastClass = FastClass.create((Class)proxyType);
        ProxyInvoker[] invokers = new ProxyInvoker[fastClass.getMaxIndex() + 1];
        Method[] methods = proxyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int interfaceIndex = ProxyMethodInterceptor.getSuperIndex(proxyType, method);
            if (interfaceIndex < 0) continue;
            invokers[interfaceIndex] = this.createJMXGBeanInvoker(kernel, method, operationSignatures, attributeNames);
        }
        return invokers;
    }

    private ProxyInvoker createJMXGBeanInvoker(Kernel kernel, Method method, Set operationSignatures, Set attributeNames) {
        if (operationSignatures.contains(new GOperationSignature(method))) {
            return new KernelOperationInvoker(kernel, method);
        }
        String name = method.getName();
        if (name.startsWith("get")) {
            String attributeName = method.getName().substring(3);
            if (attributeNames.contains(attributeName)) {
                return new KernelGetAttributeInvoker(kernel, attributeName);
            }
            if (attributeNames.contains(attributeName = Introspector.decapitalize(attributeName))) {
                return new KernelGetAttributeInvoker(kernel, attributeName);
            }
        } else if (name.startsWith("is")) {
            String attrName = method.getName().substring(2);
            if (attributeNames.contains(attrName)) {
                return new KernelGetAttributeInvoker(kernel, attrName);
            }
            if (attributeNames.contains(attrName = Introspector.decapitalize(attrName))) {
                return new KernelGetAttributeInvoker(kernel, attrName);
            }
        } else if (name.startsWith("set")) {
            String attrName = method.getName().substring(3);
            if (attributeNames.contains(attrName)) {
                return new KernelSetAttributeInvoker(kernel, attrName);
            }
            if (attributeNames.contains(attrName = Introspector.decapitalize(attrName))) {
                return new KernelSetAttributeInvoker(kernel, attrName);
            }
        }
        return null;
    }

    private static int getSuperIndex(Class proxyType, Method method) {
        Signature signature = new Signature(method.getName(), Type.getReturnType((Method)method), Type.getArgumentTypes((Method)method));
        MethodProxy methodProxy = MethodProxy.find((Class)proxyType, (Signature)signature);
        if (methodProxy != null) {
            return methodProxy.getSuperIndex();
        }
        return -1;
    }

    private static Integer getMethodIndex(Map attributes, String attributeName) {
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.equalsIgnoreCase(attributeName)) continue;
            return (Integer)attributes.get(key);
        }
        return null;
    }

    static {
        $assertionsDisabled = !ProxyMethodInterceptor.class.desiredAssertionStatus();
    }

    static final class ToStringInvoke
    implements ProxyInvoker {
        private final String interfaceName;

        public ToStringInvoke(String interfaceName) {
            this.interfaceName = "[" + interfaceName + ": ";
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return this.interfaceName + objectName + "]";
        }
    }

    static final class EqualsInvoke
    implements ProxyInvoker {
        private final ProxyManager proxyManager;

        public EqualsInvoke(ProxyManager proxyManager) {
            this.proxyManager = proxyManager;
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            ObjectName proxyTarget = this.proxyManager.getProxyTarget(arguments[0]);
            return objectName.equals(proxyTarget);
        }
    }

    static final class HashCodeInvoke
    implements ProxyInvoker {
        HashCodeInvoke() {
        }

        public Object invoke(ObjectName objectName, Object[] arguments) throws Throwable {
            return new Integer(objectName.hashCode());
        }
    }
}

