/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectInputStreamExt;
import org.apache.geronimo.kernel.config.ConfigurationClassLoader;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationParent;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;

public class Configuration
implements GBeanLifecycle {
    private static final Log log;
    private final Kernel kernel;
    private final String objectNameString;
    private final ObjectName objectName;
    private final URI id;
    private final ConfigurationModuleType moduleType;
    private final URI parentId;
    private final ConfigurationStore configurationStore;
    private final List dependencies;
    private final List classPath;
    private final String domain;
    private final String server;
    private Set objectNames;
    private ConfigurationClassLoader configurationClassLoader;
    private byte[] gbeanState;
    private final URL baseURL;
    private final ConfigurationParent parent;
    private final Collection repositories;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ObjectName getConfigurationObjectName(URI configId) throws MalformedObjectNameException {
        return new ObjectName("geronimo.config:name=" + ObjectName.quote(configId.toString()));
    }

    public Configuration() {
        this.kernel = null;
        this.objectNameString = null;
        this.objectName = null;
        this.id = null;
        this.moduleType = null;
        this.parentId = null;
        this.configurationStore = null;
        this.domain = null;
        this.server = null;
        this.objectNames = null;
        this.configurationClassLoader = null;
        this.dependencies = null;
        this.classPath = null;
        this.baseURL = null;
        this.parent = null;
        this.repositories = null;
    }

    public Configuration(Kernel kernel, String objectName, URI id, ConfigurationModuleType moduleType, URL baseURL, URI parentId, ConfigurationParent parent, String domain, String server, List classPath, byte[] gbeanState, Collection repositories, List dependencies, ConfigurationStore configurationStore) throws Exception {
        this.kernel = kernel;
        this.objectNameString = objectName;
        this.objectName = JMXUtil.getObjectName(objectName);
        this.id = id;
        this.moduleType = moduleType;
        this.baseURL = baseURL;
        this.parentId = parentId;
        this.parent = parent;
        this.gbeanState = gbeanState;
        this.repositories = repositories;
        this.classPath = classPath != null ? classPath : Collections.EMPTY_LIST;
        this.dependencies = dependencies != null ? dependencies : Collections.EMPTY_LIST;
        this.configurationStore = configurationStore;
        this.domain = domain;
        this.server = server;
    }

    public String getObjectName() {
        return this.objectNameString;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        URL[] urls = Configuration.resolveClassPath(this.classPath, this.baseURL, this.dependencies, this.repositories);
        log.debug((Object)("ClassPath for " + this.id + " resolved to " + Arrays.asList(urls)));
        this.configurationClassLoader = this.parent == null ? new ConfigurationClassLoader(this.id, urls, this.getClass().getClassLoader()) : new ConfigurationClassLoader(this.id, urls, this.parent.getConfigurationClassLoader());
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.configurationClassLoader);
            Collection gbeans = Configuration.loadGBeans(this.gbeanState, this.configurationClassLoader);
            Iterator i = gbeans.iterator();
            while (i.hasNext()) {
                GBeanData gbeanData = (GBeanData)i.next();
                Configuration.setGBeanBaseUrl(gbeanData, this.baseURL);
            }
            HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
            Iterator i2 = gbeans.iterator();
            while (i2.hasNext()) {
                GBeanData gbeanData = (GBeanData)i2.next();
                ObjectName name = gbeanData.getName();
                log.trace((Object)("Registering GBean " + name));
                this.kernel.loadGBean(gbeanData, this.configurationClassLoader);
                objectNames.add(name);
                this.kernel.getDependencyManager().addDependency(name, this.objectName);
            }
            this.objectNames = objectNames;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        log.info((Object)("Started configuration " + this.id));
    }

    private static URL[] resolveClassPath(List classPath, URL baseURL, List dependencies, Collection repositories) throws MalformedURLException, MissingDependencyException {
        URI uri;
        if (classPath == null) {
            classPath = Collections.EMPTY_LIST;
        }
        if (dependencies == null) {
            dependencies = Collections.EMPTY_LIST;
        }
        URL[] urls = new URL[dependencies.size() + classPath.size()];
        int idx = 0;
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            URL url = null;
            Iterator j = repositories.iterator();
            while (j.hasNext()) {
                Repository repository = (Repository)j.next();
                if (!repository.hasURI(uri)) continue;
                url = repository.getURL(uri);
                break;
            }
            if (url == null) {
                throw new MissingDependencyException("Unable to resolve dependency " + uri);
            }
            urls[idx++] = url;
        }
        i = classPath.iterator();
        while (i.hasNext()) {
            uri = (URI)i.next();
            urls[idx++] = new URL(baseURL, uri.toString());
        }
        if (!$assertionsDisabled && idx != urls.length) {
            throw new AssertionError();
        }
        return urls;
    }

    private static void setGBeanBaseUrl(GBeanData gbeanData, URL baseUrl) {
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        Set attributes = gbeanInfo.getAttributes();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attribute = (GAttributeInfo)iterator.next();
            if (!attribute.getName().equals("configurationBaseUrl") || !attribute.getType().equals("java.net.URL")) continue;
            gbeanData.setAttribute("configurationBaseUrl", baseUrl);
            return;
        }
    }

    public void doStop() throws Exception {
        log.info((Object)("Stopping configuration " + this.id));
        GBeanData[] gbeans = new GBeanData[this.objectNames.size()];
        Iterator iterator = this.objectNames.iterator();
        for (int i = 0; i < gbeans.length; ++i) {
            ObjectName objectName = (ObjectName)iterator.next();
            try {
                gbeans[i] = this.kernel.getGBeanData(objectName);
                continue;
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to serialize GBeanData for " + objectName, e);
            }
        }
        try {
            this.gbeanState = Configuration.storeGBeans(gbeans);
        }
        catch (InvalidConfigException e) {
            log.info((Object)"Unable to update persistent state during shutdown", (Throwable)e);
        }
        this.shutdown();
        if (this.configurationStore != null) {
            ConfigurationData configurationData = new ConfigurationData();
            configurationData.setId(this.id);
            configurationData.setModuleType(this.moduleType);
            configurationData.setDomain(this.domain);
            configurationData.setServer(this.server);
            configurationData.setParentId(this.parentId);
            configurationData.setGBeans(Arrays.asList(gbeans));
            configurationData.setDependencies(this.dependencies);
            configurationData.setClassPath(this.classPath);
            this.configurationStore.updateConfiguration(configurationData);
        }
    }

    private void shutdown() {
        Iterator i = this.objectNames.iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            this.kernel.getDependencyManager().removeDependency(name, this.objectName);
            try {
                log.trace((Object)("Unregistering GBean " + name));
                this.kernel.unloadGBean(name);
            }
            catch (Exception e) {
                log.warn((Object)("Could not unregister child " + name), (Throwable)e);
            }
        }
        if (this.configurationClassLoader != null) {
            this.configurationClassLoader.destroy();
            this.configurationClassLoader = null;
        }
    }

    public void doFail() {
        this.shutdown();
    }

    public URI getParentId() {
        return this.parentId;
    }

    public URI getId() {
        return this.id;
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public byte[] getGBeanState() {
        return this.gbeanState;
    }

    public ClassLoader getConfigurationClassLoader() {
        return this.configurationClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection loadGBeans(byte[] gbeanState, ClassLoader cl) throws InvalidConfigException {
        HashMap<ObjectName, GBeanData> gbeans = new HashMap<ObjectName, GBeanData>();
        try {
            ObjectInputStreamExt ois = new ObjectInputStreamExt(new ByteArrayInputStream(gbeanState), cl);
            try {
                try {
                    while (true) {
                        GBeanData gbeanData = new GBeanData();
                        gbeanData.readExternal(ois);
                        gbeans.put(gbeanData.getName(), gbeanData);
                    }
                }
                catch (EOFException e) {
                    ois.close();
                }
            }
            catch (Throwable throwable) {
                ois.close();
                throw throwable;
            }
            return gbeans.values();
        }
        catch (Exception e) {
            throw new InvalidConfigException("Unable to deserialize GBeanState", e);
        }
    }

    public static byte[] storeGBeans(GBeanData[] gbeans) throws InvalidConfigException {
        return Configuration.storeGBeans(Arrays.asList(gbeans));
    }

    public static byte[] storeGBeans(List gbeans) throws InvalidConfigException {
        ObjectOutputStream oos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(baos);
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to initialize ObjectOutputStream"))).initCause(e));
        }
        Iterator iterator = gbeans.iterator();
        while (iterator.hasNext()) {
            GBeanData gbeanData = (GBeanData)iterator.next();
            try {
                gbeanData.writeExternal(oos);
            }
            catch (Exception e) {
                throw new InvalidConfigException("Unable to serialize GBeanData for " + gbeanData.getName(), e);
            }
        }
        try {
            oos.flush();
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to flush ObjectOutputStream"))).initCause(e));
        }
        return baos.toByteArray();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !Configuration.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)Configuration.class);
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(Configuration.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("id", URI.class, true);
        infoFactory.addAttribute("type", ConfigurationModuleType.class, true);
        infoFactory.addAttribute("parentId", URI.class, true);
        infoFactory.addAttribute("domain", String.class, true);
        infoFactory.addAttribute("server", String.class, true);
        infoFactory.addAttribute("classPath", List.class, true);
        infoFactory.addAttribute("dependencies", List.class, true);
        infoFactory.addAttribute("gBeanState", [B.class, true);
        infoFactory.addAttribute("baseURL", URL.class, true);
        infoFactory.addAttribute("configurationClassLoader", ClassLoader.class, false);
        infoFactory.addReference("Parent", ConfigurationParent.class);
        infoFactory.addReference("Repositories", Repository.class, "GBean");
        infoFactory.addReference("ConfigurationStore", ConfigurationStore.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "id", "type", "baseURL", "parentId", "Parent", "domain", "server", "classPath", "gBeanState", "Repositories", "dependencies", "ConfigurationStore"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

