/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;

public class ConfigurationData {
    private URI id;
    private ConfigurationModuleType moduleType;
    private URI parentId;
    private String domain;
    private String server;
    private final LinkedHashSet dependencies = new LinkedHashSet();
    private final LinkedHashSet classPath = new LinkedHashSet();
    private final List gbeans = new ArrayList();
    private final List childConfigurations = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConfigurationData() {
    }

    public ConfigurationData(ConfigurationData configurationData) {
        this.id = configurationData.id;
        this.moduleType = configurationData.moduleType;
        this.parentId = configurationData.getParentId();
        this.domain = configurationData.domain;
        this.server = configurationData.server;
        this.setDependencies(new ArrayList(configurationData.dependencies));
        this.setClassPath(new ArrayList(configurationData.classPath));
        this.setGBeans(configurationData.gbeans);
        this.setChildConfigurations(configurationData.childConfigurations);
    }

    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    public ConfigurationModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ConfigurationModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public URI getParentId() {
        return this.parentId;
    }

    public void setParentId(URI parentId) {
        this.parentId = parentId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public List getDependencies() {
        return Collections.unmodifiableList(new ArrayList(this.dependencies));
    }

    public void setDependencies(List dependencies) {
        this.dependencies.clear();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            URI dependency = (URI)iterator.next();
            this.addDependency(dependency);
        }
    }

    public void addDependency(URI dependency) {
        if (!$assertionsDisabled && dependency == null) {
            throw new AssertionError();
        }
        this.dependencies.add(dependency);
    }

    public List getClassPath() {
        return Collections.unmodifiableList(new ArrayList(this.classPath));
    }

    public void setClassPath(List classPath) {
        this.classPath.clear();
        Iterator iterator = classPath.iterator();
        while (iterator.hasNext()) {
            URI location = (URI)iterator.next();
            this.addClassPathLocation(location);
        }
    }

    public void addClassPathLocation(URI location) {
        if (!$assertionsDisabled && location == null) {
            throw new AssertionError();
        }
        this.classPath.add(location);
    }

    public List getGBeans() {
        return Collections.unmodifiableList(this.gbeans);
    }

    public void setGBeans(List gbeans) {
        this.gbeans.clear();
        Iterator iterator = gbeans.iterator();
        while (iterator.hasNext()) {
            GBeanData gbeanData = (GBeanData)iterator.next();
            this.addGBean(gbeanData);
        }
    }

    public void addGBean(GBeanData gbeanData) {
        if (!$assertionsDisabled && gbeanData == null) {
            throw new AssertionError();
        }
        this.gbeans.add(gbeanData);
    }

    public List getChildConfigurations() {
        return Collections.unmodifiableList(this.childConfigurations);
    }

    public void setChildConfigurations(List childConfigurations) {
        this.childConfigurations.clear();
        Iterator iterator = childConfigurations.iterator();
        while (iterator.hasNext()) {
            ConfigurationData configurationData = (ConfigurationData)iterator.next();
            this.addChildConfiguration(configurationData);
        }
    }

    public void addChildConfiguration(ConfigurationData configurationData) {
        if (!$assertionsDisabled && configurationData == null) {
            throw new AssertionError();
        }
        this.childConfigurations.add(configurationData);
    }

    static {
        $assertionsDisabled = !ConfigurationData.class.desiredAssertionStatus();
    }
}

