/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public final class ConfigurationUtil {
    private static final ObjectName CONFIGURATION_MANAGER_QUERY = JMXUtil.getObjectName("*:j2eeType=ConfigurationManager,*");

    private ConfigurationUtil() {
    }

    public static ConfigurationManager getConfigurationManager(Kernel kernel) {
        Set names = kernel.listGBeans(CONFIGURATION_MANAGER_QUERY);
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            try {
                if (kernel.getGBeanState(objectName) == 1) continue;
                iterator.remove();
            }
            catch (GBeanNotFoundException e) {
                iterator.remove();
            }
        }
        if (names.isEmpty()) {
            throw new IllegalStateException("Configuration mananger could not be found in kernel: " + CONFIGURATION_MANAGER_QUERY);
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More then one configuration mananger was found in kernel: " + CONFIGURATION_MANAGER_QUERY);
        }
        ObjectName configurationManagerName = (ObjectName)names.iterator().next();
        return (ConfigurationManager)kernel.getProxyManager().createProxy(configurationManagerName, ConfigurationManager.class);
    }
}

