/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;

public class GBeanInfoBuilder {
    public static final String DEFAULT_J2EE_TYPE = "GBean";
    private static final Class[] NO_ARGS;
    private final String name;
    private final String j2eeType;
    private final Class gbeanType;
    private final Map attributes = new HashMap();
    private GConstructorInfo constructor = new GConstructorInfo();
    private final Map operations = new HashMap();
    private final Map references = new HashMap();
    private final Set interfaces = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public GBeanInfoBuilder(Class gbeanType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, null, null);
    }

    public GBeanInfoBuilder(Class gbeanType, String j2eeType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, null, j2eeType);
    }

    public GBeanInfoBuilder(String name, Class gbeanType) {
        this(name, GBeanInfoBuilder.checkNotNull(gbeanType), null, null);
    }

    public GBeanInfoBuilder(String name, Class gbeanType, String j2eeType) {
        this(name, GBeanInfoBuilder.checkNotNull(gbeanType), null, j2eeType);
    }

    public GBeanInfoBuilder(Class gbeanType, GBeanInfo source) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, source);
    }

    public GBeanInfoBuilder(Class gbeanType, GBeanInfo source, String j2eeType) {
        this(GBeanInfoBuilder.checkNotNull(gbeanType).getName(), gbeanType, source, j2eeType);
    }

    public GBeanInfoBuilder(String name, ClassLoader classLoader) {
        this(GBeanInfoBuilder.checkNotNull(name), GBeanInfoBuilder.loadClass(classLoader, name), GBeanInfo.getGBeanInfo(name, classLoader));
    }

    public GBeanInfoBuilder(String name, Class gbeanType, GBeanInfo source) {
        this(name, gbeanType, source, null);
    }

    public GBeanInfoBuilder(String name, Class gbeanType, GBeanInfo source, String j2eeType) {
        GBeanInfoBuilder.checkNotNull(name);
        GBeanInfoBuilder.checkNotNull(gbeanType);
        this.name = name;
        this.gbeanType = gbeanType;
        if (source != null) {
            Iterator i = source.getAttributes().iterator();
            while (i.hasNext()) {
                GAttributeInfo attributeInfo = (GAttributeInfo)i.next();
                this.attributes.put(attributeInfo.getName(), attributeInfo);
            }
            i = source.getOperations().iterator();
            while (i.hasNext()) {
                GOperationInfo operationInfo = (GOperationInfo)i.next();
                this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
            }
            Iterator iterator = source.getReferences().iterator();
            while (iterator.hasNext()) {
                GReferenceInfo referenceInfo = (GReferenceInfo)iterator.next();
                this.references.put(referenceInfo.getName(), new RefInfo(referenceInfo.getReferenceType(), referenceInfo.getNameTypeName()));
            }
            iterator = source.getInterfaces().iterator();
            while (iterator.hasNext()) {
                String intf = (String)iterator.next();
                this.interfaces.add(intf);
            }
            this.constructor = source.getConstructor();
        }
        this.j2eeType = j2eeType != null ? j2eeType : (source != null ? source.getJ2eeType() : DEFAULT_J2EE_TYPE);
    }

    public void addInterface(Class intf) {
        this.addInterface(intf, new String[0]);
    }

    public void addInterface(Class intf, String[] persistentAttributes) {
        this.addInterface(intf, persistentAttributes, new String[0]);
    }

    public void addInterface(Class intf, String[] persistentAttributes, String[] manageableAttributes) {
        HashSet<String> persistentNames = new HashSet<String>(Arrays.asList(persistentAttributes));
        HashSet<String> manageableNames = new HashSet<String>(Arrays.asList(manageableAttributes));
        Method[] methods = intf.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String attributeName;
            Method method = methods[i];
            if (GBeanInfoBuilder.isGetter(method)) {
                attributeName = this.getAttributeName(method);
                GAttributeInfo attribute = (GAttributeInfo)this.attributes.get(attributeName);
                String attributeType = method.getReturnType().getName();
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, persistentNames.contains(attributeName), manageableNames.contains(attributeName), method.getName(), null));
                    continue;
                }
                if (!attributeType.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName);
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, attribute.isPersistent(), attribute.isManageable(), method.getName(), attribute.getSetterName()));
                continue;
            }
            if (this.isSetter(method)) {
                attributeName = this.getAttributeName(method);
                String attributeType = method.getParameterTypes()[0].getName();
                GAttributeInfo attribute = (GAttributeInfo)this.attributes.get(attributeName);
                if (attribute == null) {
                    this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, persistentNames.contains(attributeName), manageableNames.contains(attributeName), null, method.getName()));
                    continue;
                }
                if (!attributeType.equals(attribute.getType())) {
                    throw new IllegalArgumentException("Getter and setter type do not match: " + attributeName);
                }
                this.attributes.put(attributeName, new GAttributeInfo(attributeName, attributeType, attribute.isPersistent(), attribute.isManageable(), attribute.getGetterName(), method.getName()));
                continue;
            }
            this.addOperation(new GOperationInfo(method.getName(), method.getParameterTypes()));
        }
        if (intf.isInterface()) {
            GBeanInfoBuilder.addInterface(this.interfaces, intf);
        }
    }

    private static void addInterface(Set set, Class intf) {
        String name = intf.getName();
        if (set.contains(name)) {
            return;
        }
        set.add(name);
        Class<?>[] cls = intf.getInterfaces();
        for (int i = 0; i < cls.length; ++i) {
            GBeanInfoBuilder.addInterface(set, cls[i]);
        }
    }

    public void addAttribute(String name, Class type, boolean persistent) {
        this.addAttribute(name, type.getName(), persistent, true);
    }

    public void addAttribute(String name, String type, boolean persistent) {
        this.addAttribute(name, type, persistent, true);
    }

    public void addAttribute(String name, Class type, boolean persistent, boolean manageable) {
        this.addAttribute(name, type.getName(), persistent, manageable);
    }

    public void addAttribute(String name, String type, boolean persistent, boolean manageable) {
        String getter = GBeanInfoBuilder.searchForGetter(name, type, this.gbeanType);
        String setter = GBeanInfoBuilder.searchForSetter(name, type, this.gbeanType);
        this.addAttribute(new GAttributeInfo(name, type, persistent, manageable, getter, setter));
    }

    public void addAttribute(GAttributeInfo info) {
        this.attributes.put(info.getName(), info);
    }

    public void setConstructor(GConstructorInfo constructor) {
        if (!$assertionsDisabled && constructor == null) {
            throw new AssertionError();
        }
        this.constructor = constructor;
    }

    public void setConstructor(String[] names) {
        this.constructor = new GConstructorInfo(names);
    }

    public void addOperation(GOperationInfo operationInfo) {
        this.operations.put(new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList()), operationInfo);
    }

    public void addOperation(String name) {
        this.addOperation(new GOperationInfo(name, NO_ARGS));
    }

    public void addOperation(String name, Class[] paramTypes) {
        this.addOperation(new GOperationInfo(name, paramTypes));
    }

    public void addReference(GReferenceInfo info) {
        this.references.put(info.getName(), new RefInfo(info.getReferenceType(), info.getNameTypeName()));
    }

    public void addReference(String name, Class type, String namingType) {
        this.references.put(name, new RefInfo(type.getName(), namingType));
    }

    public void addReference(String name, Class type) {
        this.references.put(name, new RefInfo(type.getName(), null));
    }

    public GBeanInfo getBeanInfo() {
        Map constructorTypes = this.getConstructorTypes();
        HashSet<GReferenceInfo> referenceInfos = new HashSet<GReferenceInfo>();
        Iterator iterator = this.references.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String referenceName = (String)entry.getKey();
            RefInfo refInfo = (RefInfo)entry.getValue();
            String referenceType = refInfo.getJavaType();
            String namingType = refInfo.getNamingType();
            String proxyType = (String)constructorTypes.get(referenceName);
            String setterName = null;
            if (proxyType == null) {
                Method setter = GBeanInfoBuilder.searchForSetterMethod(referenceName, referenceType, this.gbeanType);
                if (setter == null && (setter = GBeanInfoBuilder.searchForSetterMethod(referenceName, (class$java$util$Collection == null ? GBeanInfoBuilder.class$("java.util.Collection") : class$java$util$Collection).getName(), this.gbeanType)) == null) {
                    throw new InvalidConfigurationException("Reference must be a constructor argument or have a setter: name=" + referenceName);
                }
                proxyType = setter.getParameterTypes()[0].getName();
                setterName = setter.getName();
            }
            if (!proxyType.equals((class$java$util$Collection == null ? GBeanInfoBuilder.class$("java.util.Collection") : class$java$util$Collection).getName()) && !proxyType.equals(referenceType)) {
                throw new InvalidConfigurationException("Reference proxy type must be Collection or " + referenceType + ": name=" + referenceName);
            }
            referenceInfos.add(new GReferenceInfo(referenceName, referenceType, proxyType, setterName, namingType));
        }
        return new GBeanInfo(this.name, this.gbeanType.getName(), this.j2eeType, this.attributes.values(), this.constructor, this.operations.values(), referenceInfos, this.interfaces);
    }

    private Map getConstructorTypes() throws InvalidConfigurationException {
        Constructor constructor;
        List arguments = this.constructor.getAttributeNames();
        String[] argumentTypes = new String[arguments.size()];
        boolean[] isReference = new boolean[arguments.size()];
        for (int i = 0; i < argumentTypes.length; ++i) {
            String argumentName = (String)arguments.get(i);
            if (this.attributes.containsKey(argumentName)) {
                GAttributeInfo attribute = (GAttributeInfo)this.attributes.get(argumentName);
                argumentTypes[i] = attribute.getType();
                isReference[i] = false;
                continue;
            }
            if (!this.references.containsKey(argumentName)) continue;
            argumentTypes[i] = ((RefInfo)this.references.get(argumentName)).getJavaType();
            isReference[i] = true;
        }
        Constructor<?>[] constructors = this.gbeanType.getConstructors();
        HashSet<Constructor> validConstructors = new HashSet<Constructor>();
        for (int i = 0; i < constructors.length; ++i) {
            constructor = constructors[i];
            if (!GBeanInfoBuilder.isValidConstructor(constructor, argumentTypes, isReference)) continue;
            validConstructors.add(constructor);
        }
        if (validConstructors.isEmpty()) {
            throw new InvalidConfigurationException("Could not find a valid constructor for GBean: " + this.name);
        }
        if (validConstructors.size() > 1) {
            throw new InvalidConfigurationException("More then one valid constructors found for GBean: " + this.name);
        }
        HashMap<String, String> constructorTypes = new HashMap<String, String>();
        constructor = (Constructor)validConstructors.iterator().next();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Iterator argumentIterator = arguments.iterator();
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i].getName();
            String argumentName = (String)argumentIterator.next();
            constructorTypes.put(argumentName, parameterType);
        }
        return constructorTypes;
    }

    private static String searchForGetter(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        Method getterMethod = null;
        String getterName = "get" + name;
        String isName = "is" + name;
        Method[] methods = gbeanType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getParameterTypes().length != 0 || methods[i].getReturnType() == Void.TYPE || !getterName.equalsIgnoreCase(methods[i].getName()) && !isName.equalsIgnoreCase(methods[i].getName())) continue;
            getterMethod = methods[i];
            break;
        }
        if (getterMethod != null && !type.equals(getterMethod.getReturnType().getName())) {
            throw new InvalidConfigurationException("Incorrect return type for getter method: name=" + name + ", targetClass=" + gbeanType.getName() + ", getter type=" + getterMethod.getReturnType() + ", expected type=" + type);
        }
        if (getterMethod == null) {
            return null;
        }
        return getterMethod.getName();
    }

    private static String searchForSetter(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        Method method = GBeanInfoBuilder.searchForSetterMethod(name, type, gbeanType);
        if (method == null) {
            return null;
        }
        return method.getName();
    }

    private static Method searchForSetterMethod(String name, String type, Class gbeanType) throws InvalidConfigurationException {
        String setterName = "set" + name;
        Method[] methods = gbeanType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals(type) || method.getReturnType() != Void.TYPE || !setterName.equalsIgnoreCase(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static boolean isValidConstructor(Constructor constructor, String[] argumentTypes, boolean[] isReference) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String parameterType = parameterTypes[i].getName();
            if (!(isReference[i] ? !parameterType.equals(argumentTypes[i]) && !parameterType.equals((class$java$util$Collection == null ? GBeanInfoBuilder.class$("java.util.Collection") : class$java$util$Collection).getName()) && !parameterType.equals((class$java$util$Set == null ? GBeanInfoBuilder.class$("java.util.Set") : class$java$util$Set).getName()) : !parameterType.equals(argumentTypes[i]))) continue;
            return false;
        }
        return true;
    }

    private String getAttributeName(Method method) {
        String name = method.getName();
        String attributeName = name.startsWith("get") || name.startsWith("set") ? name.substring(3) : name.substring(2);
        attributeName = Introspector.decapitalize(attributeName);
        return attributeName;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    private static boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && method.getParameterTypes().length == 0;
    }

    private static Class checkNotNull(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return clazz;
    }

    private static String checkNotNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null argument supplied");
        }
        return string;
    }

    private static Class loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load class " + name, e);
        }
    }

    static {
        $assertionsDisabled = !GBeanInfoBuilder.class.desiredAssertionStatus();
        NO_ARGS = new Class[0];
    }

    private static class RefInfo {
        private final String javaType;
        private final String namingType;

        public RefInfo(String javaType, String namingType) {
            this.javaType = javaType;
            this.namingType = namingType;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getNamingType() {
            return this.namingType;
        }
    }
}

