/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.management.State;

public class GBeanSingleReference
extends AbstractGBeanReference {
    private static final Log log = LogFactory.getLog((Class)GBeanSingleReference.class);
    private boolean waitingForMe = false;
    private ObjectName proxyTarget;

    public GBeanSingleReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, DependencyManager dependencyManager) throws InvalidConfigurationException {
        super(gbeanInstance, referenceInfo, kernel, dependencyManager);
    }

    public synchronized boolean start() {
        if (!this.getPatterns().isEmpty() && this.getProxy() == null) {
            ObjectName objectName = this.getGBeanInstance().getObjectNameObject();
            Set targets = this.getTargets();
            if (targets.size() == 0) {
                this.waitingForMe = true;
                log.debug((Object)("Waiting to start " + objectName + " because no targets are running for reference " + this.getName() + " matching the patternspatterns " + this.getPatternsText()));
                return false;
            }
            if (targets.size() > 1) {
                this.waitingForMe = true;
                log.debug((Object)("Waiting to start " + objectName + " because more then one targets are running for the single valued reference " + this.getName() + " matching the patternspatterns " + this.getPatternsText()));
                return false;
            }
            this.waitingForMe = false;
            DependencyManager dependencyManager = this.getDependencyManager();
            dependencyManager.addStartHolds(objectName, this.getPatterns());
            ObjectName target = (ObjectName)targets.iterator().next();
            this.setProxy(this.getKernel().getProxyManager().createProxy(target, this.getReferenceType()));
            this.proxyTarget = target;
            dependencyManager.addDependency(objectName, target);
        }
        return true;
    }

    private String getPatternsText() {
        StringBuffer buf = new StringBuffer();
        Set patterns = this.getPatterns();
        Iterator iterator = patterns.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            buf.append(objectName.getCanonicalName()).append(" ");
        }
        return buf.toString();
    }

    public synchronized void stop() {
        Object proxy;
        this.waitingForMe = false;
        ObjectName objectName = this.getGBeanInstance().getObjectNameObject();
        Set patterns = this.getPatterns();
        DependencyManager dependencyManager = this.getDependencyManager();
        if (!patterns.isEmpty()) {
            dependencyManager.removeStartHolds(objectName, patterns);
        }
        if ((proxy = this.getProxy()) != null) {
            dependencyManager.removeDependency(objectName, this.proxyTarget);
            this.getKernel().getProxyManager().destroyProxy(proxy);
            this.setProxy(null);
            this.proxyTarget = null;
        }
    }

    protected synchronized void targetAdded(ObjectName target) {
        Set targets;
        GBeanInstance gbeanInstance = this.getGBeanInstance();
        if (gbeanInstance.getStateInstance() == State.RUNNING) {
            log.error((Object)("Illegal state: two or more targets are not running for a signle valued reference: " + this.getDescription() + ", currentTarget=" + this.proxyTarget + ", newTarget=" + target));
            gbeanInstance.referenceFailed();
        } else if (this.waitingForMe && (targets = this.getTargets()).size() == 1) {
            this.attemptFullStart();
        }
    }

    protected synchronized void targetRemoved(ObjectName target) {
        Set targets;
        GBeanInstance gbeanInstance = this.getGBeanInstance();
        if (gbeanInstance.getStateInstance() == State.RUNNING) {
            log.error((Object)("Illegal state: current target for a signle valued reference stopped: " + this.getDescription() + ", currentTarget=" + target));
            gbeanInstance.referenceFailed();
        } else if (this.waitingForMe && (targets = this.getTargets()).size() == 1) {
            this.attemptFullStart();
        }
    }

    private synchronized void attemptFullStart() {
        try {
            this.waitingForMe = false;
            this.getGBeanInstance().start();
        }
        catch (Exception e) {
            log.warn((Object)("Exception occured while attempting to fully start: objectName=" + this.getGBeanInstance().getObjectName()), (Throwable)e);
        }
    }

    protected LifecycleListener createLifecycleListener() {
        return new LifecycleAdapter(){

            public void running(ObjectName objectName) {
                GBeanSingleReference.this.addTarget(objectName);
            }

            public void stopped(ObjectName objectName) {
                GBeanSingleReference.this.removeTarget(objectName);
            }

            public void failed(ObjectName objectName) {
                GBeanSingleReference.this.removeTarget(objectName);
            }

            public void unloaded(ObjectName objectName) {
                GBeanSingleReference.this.removeTarget(objectName);
            }
        };
    }
}

