/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import mx4j.log.CommonsLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.log.GeronimoLogFactory;

public class GeronimoLogging {
    public static final GeronimoLogging TRACE = new GeronimoLogging("TRACE");
    public static final GeronimoLogging DEBUG = new GeronimoLogging("DEBUG");
    public static final GeronimoLogging INFO = new GeronimoLogging("INFO");
    public static final GeronimoLogging WARN = new GeronimoLogging("WARN");
    public static final GeronimoLogging ERROR = new GeronimoLogging("ERROR");
    public static final GeronimoLogging FATAL = new GeronimoLogging("FATAL");
    private static boolean initialized = false;
    private static GeronimoLogging consoleLogLevel;
    private static GeronimoLogging defaultLevel;
    private final String level;

    public static void initialize(GeronimoLogging level) {
        if (!initialized) {
            defaultLevel = level;
            consoleLogLevel = level;
            System.setProperty("org.apache.commons.logging.LogFactory", GeronimoLogFactory.class.getName());
            LogFactory.getLog((Class)GeronimoLogging.class);
            Log.redirectTo((Logger)new CommonsLogger());
            initialized = true;
        }
    }

    public static GeronimoLogging getDefaultLevel() {
        return defaultLevel;
    }

    public static GeronimoLogging getConsoleLogLevel() {
        return consoleLogLevel;
    }

    public static void setConsoleLogLevel(GeronimoLogging consoleLogLevel) {
        GeronimoLogging.consoleLogLevel = consoleLogLevel;
    }

    private GeronimoLogging(String level) {
        this.level = level;
    }

    public String toString() {
        return this.level;
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

