/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;

public class GBeanData
implements Externalizable {
    private ObjectName name;
    private GBeanInfo gbeanInfo;
    private final Map attributes;
    private final Map references;
    private final Set dependencies;

    public GBeanData() {
        this.attributes = new HashMap();
        this.references = new HashMap();
        this.dependencies = new HashSet();
    }

    public GBeanData(GBeanInfo gbeanInfo) {
        this();
        this.gbeanInfo = gbeanInfo;
    }

    public GBeanData(ObjectName name, GBeanInfo gbeanInfo) {
        this();
        this.name = name;
        this.gbeanInfo = gbeanInfo;
    }

    public GBeanData(GBeanData gbeanData) {
        this.name = gbeanData.name;
        this.gbeanInfo = gbeanData.gbeanInfo;
        this.attributes = new HashMap(gbeanData.attributes);
        this.references = new HashMap(gbeanData.references);
        this.dependencies = new HashSet(gbeanData.dependencies);
    }

    public ObjectName getName() {
        return this.name;
    }

    public void setName(ObjectName name) {
        this.name = name;
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    public void setGBeanInfo(GBeanInfo gbeanInfo) {
        this.gbeanInfo = gbeanInfo;
    }

    public Map getAttributes() {
        return new HashMap(this.attributes);
    }

    public Set getAttributeNames() {
        return new HashSet(this.attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map getReferences() {
        return new HashMap(this.references);
    }

    public Set getReferencesNames() {
        return new HashSet(this.references.keySet());
    }

    public Set getReferencePatterns(String name) {
        return (Set)this.references.get(name);
    }

    public void setReferencePattern(String name, ObjectName pattern) {
        this.setReferencePatterns(name, Collections.singleton(pattern));
    }

    public void setReferencePatterns(String name, Set patterns) {
        this.references.put(name, patterns);
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object value;
        String name;
        Map.Entry entry;
        out.writeObject(this.gbeanInfo);
        out.writeObject(this.name);
        out.writeInt(this.attributes.size());
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            value = entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write attribute: " + name).initCause(e);
            }
        }
        out.writeInt(this.references.size());
        iterator = this.references.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            value = (Set)entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write reference pattern: " + name).initCause(e);
            }
        }
        out.writeInt(this.dependencies.size());
        iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)((Object)iterator.next());
            out.writeObject(objectName);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.gbeanInfo = (GBeanInfo)in.readObject();
        try {
            this.name = (ObjectName)in.readObject();
        }
        catch (IOException e) {
            throw (IOException)new IOException("Unable to deserialize ObjectName for GBeanData of type " + this.gbeanInfo.getClassName()).initCause(e);
        }
        try {
            int attributeCount = in.readInt();
            for (int i = 0; i < attributeCount; ++i) {
                this.setAttribute((String)in.readObject(), in.readObject());
            }
            int endpointCount = in.readInt();
            for (int i = 0; i < endpointCount; ++i) {
                this.setReferencePatterns((String)in.readObject(), (Set)in.readObject());
            }
            int dependencyCount = in.readInt();
            for (int i = 0; i < dependencyCount; ++i) {
                ObjectName objectName = (ObjectName)in.readObject();
                this.dependencies.add(objectName);
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("Unable to deserialize GBeanData " + this.name).initCause(e);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Unable to find class used in GBeanData " + this.name, e);
        }
    }
}

