/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GOperationSignature;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.AbstractGBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanAttribute;
import org.apache.geronimo.gbean.runtime.GBeanCollectionReference;
import org.apache.geronimo.gbean.runtime.GBeanDependency;
import org.apache.geronimo.gbean.runtime.GBeanInstanceState;
import org.apache.geronimo.gbean.runtime.GBeanOperation;
import org.apache.geronimo.gbean.runtime.GBeanReference;
import org.apache.geronimo.gbean.runtime.GBeanSingleReference;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.gbean.runtime.RawInvoker;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.kernel.NoSuchOperationException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.management.StateManageable;

public final class GBeanInstance
implements StateManageable {
    private static final Log log;
    private static final int DESTROYED = 0;
    private static final int CREATING = 1;
    private static final int RUNNING = 2;
    private static final int DESTROYING = 3;
    public static final String RAW_INVOKER = "$$RAW_INVOKER$$";
    private final Kernel kernel;
    private ManageableAttributeStore manageableStore;
    private final ObjectName objectName;
    private final GBeanInstanceState gbeanInstanceState;
    private final Constructor constructor;
    private final RawInvoker rawInvoker;
    private final LifecycleBroadcaster lifecycleBroadcaster;
    private final String[] interfaces;
    private final GBeanAttribute[] attributes;
    private final Map attributeIndex = new HashMap();
    private final GBeanReference[] references;
    private final Map referenceIndex = new HashMap();
    private final GBeanDependency[] dependencies;
    private final GBeanOperation[] operations;
    private final Map operationIndex = new HashMap();
    private final ClassLoader classLoader;
    private final GBeanInfo gbeanInfo;
    private final String name;
    private final Class type;
    private boolean dead = false;
    private int instanceState = 0;
    private Object target;
    private long startTime;
    private boolean enabled = true;
    private boolean shouldFail = false;
    static /* synthetic */ Class class$java$util$Collection;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GBeanInstance(GBeanData gbeanData, Kernel kernel, DependencyManager dependencyManager, LifecycleBroadcaster lifecycleBroadcaster, ClassLoader classLoader) throws InvalidConfigurationException {
        int i;
        this.objectName = gbeanData.getName();
        this.kernel = kernel;
        this.lifecycleBroadcaster = lifecycleBroadcaster;
        this.gbeanInstanceState = new GBeanInstanceState(this.objectName, kernel, dependencyManager, this, lifecycleBroadcaster);
        this.classLoader = classLoader;
        GBeanInfo gbeanInfo = gbeanData.getGBeanInfo();
        try {
            this.type = classLoader.loadClass(gbeanInfo.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load GBeanInfo class from classloader: " + classLoader + " className=" + gbeanInfo.getClassName());
        }
        this.name = gbeanInfo.getName();
        HashSet constructorArgs = new HashSet(gbeanInfo.getConstructor().getAttributeNames());
        this.interfaces = gbeanInfo.getInterfaces().toArray(new String[0]);
        HashMap<String, GBeanAttribute> attributesMap = new HashMap<String, GBeanAttribute>();
        Iterator iterator = gbeanInfo.getAttributes().iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attributeInfo = (GAttributeInfo)iterator.next();
            attributesMap.put(attributeInfo.getName(), new GBeanAttribute(this, attributeInfo, constructorArgs.contains(attributeInfo.getName())));
        }
        this.addManagedObjectAttributes(attributesMap);
        this.attributes = attributesMap.values().toArray(new GBeanAttribute[attributesMap.size()]);
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            this.attributeIndex.put(this.attributes[i2].getName(), new Integer(i2));
        }
        HashSet<AbstractGBeanReference> referencesSet = new HashSet<AbstractGBeanReference>();
        Iterator iterator2 = gbeanInfo.getReferences().iterator();
        while (iterator2.hasNext()) {
            GReferenceInfo referenceInfo = (GReferenceInfo)iterator2.next();
            if (referenceInfo.getProxyType().equals((class$java$util$Collection == null ? GBeanInstance.class$("java.util.Collection") : class$java$util$Collection).getName())) {
                referencesSet.add(new GBeanCollectionReference(this, referenceInfo, kernel, dependencyManager));
                continue;
            }
            referencesSet.add(new GBeanSingleReference(this, referenceInfo, kernel, dependencyManager));
        }
        this.references = referencesSet.toArray(new GBeanReference[gbeanInfo.getReferences().size()]);
        for (int i3 = 0; i3 < this.references.length; ++i3) {
            this.referenceIndex.put(this.references[i3].getName(), new Integer(i3));
        }
        this.dependencies = new GBeanDependency[gbeanData.getDependencies().size()];
        int j = 0;
        Iterator iterator3 = gbeanData.getDependencies().iterator();
        while (iterator3.hasNext()) {
            ObjectName dependencyName = (ObjectName)iterator3.next();
            GBeanDependency dependency = new GBeanDependency(this, dependencyName, kernel, dependencyManager);
            this.dependencies[j++] = dependency;
        }
        HashMap<GOperationSignature, GBeanOperation> operationsMap = new HashMap<GOperationSignature, GBeanOperation>();
        Iterator iterator4 = gbeanInfo.getOperations().iterator();
        while (iterator4.hasNext()) {
            GOperationInfo operationInfo = (GOperationInfo)iterator4.next();
            GOperationSignature signature = new GOperationSignature(operationInfo.getName(), operationInfo.getParameterList());
            if (operationsMap.containsKey(signature)) continue;
            GBeanOperation operation = new GBeanOperation(this, operationInfo);
            operationsMap.put(signature, operation);
        }
        this.operations = new GBeanOperation[operationsMap.size()];
        int opCounter = 0;
        Iterator iterator5 = operationsMap.entrySet().iterator();
        while (iterator5.hasNext()) {
            Map.Entry entry = iterator5.next();
            this.operations[opCounter] = (GBeanOperation)entry.getValue();
            this.operationIndex.put(entry.getKey(), new Integer(opCounter));
            ++opCounter;
        }
        List arguments = gbeanInfo.getConstructor().getAttributeNames();
        Class[] parameterTypes = new Class[arguments.size()];
        for (int i4 = 0; i4 < parameterTypes.length; ++i4) {
            Integer index;
            String argumentName = (String)arguments.get(i4);
            if (this.attributeIndex.containsKey(argumentName)) {
                index = (Integer)this.attributeIndex.get(argumentName);
                GBeanAttribute attribute = this.attributes[index];
                parameterTypes[i4] = attribute.getType();
                continue;
            }
            if (!this.referenceIndex.containsKey(argumentName)) continue;
            index = (Integer)this.referenceIndex.get(argumentName);
            GBeanReference reference = this.references[index];
            parameterTypes[i4] = reference.getProxyType();
        }
        try {
            this.constructor = this.type.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            StringBuffer buf = new StringBuffer("Could not find a valid constructor for GBean: ").append(gbeanInfo.getName()).append("\n");
            Constructor<?>[] constructors = this.type.getConstructors();
            for (int i5 = 0; i5 < constructors.length; ++i5) {
                Constructor<?> testConstructor = constructors[i5];
                buf.append("constructor types: " + testConstructor.getParameterTypes() + "\n");
                if (testConstructor.getParameterTypes().length != parameterTypes.length) continue;
                Class<?>[] testParameterTypes = testConstructor.getParameterTypes();
                for (int k = 0; k < testParameterTypes.length; ++k) {
                    Class<?> testParameterType = testParameterTypes[k];
                    if (parameterTypes[k].getName().equals(testParameterType.getName())) {
                        if (parameterTypes[k].getClassLoader() == testParameterType.getClassLoader()) continue;
                        buf.append("different classloaders in position: ").append(k).append(" class name: ").append(testParameterType.getName()).append("\n");
                        buf.append("parameter type classloader: ").append(parameterTypes[k].getClassLoader()).append("\n");
                        buf.append("constructor type classloader: ").append(testParameterType.getClassLoader()).append("\n");
                        continue;
                    }
                    buf.append("different type in position: ").append(k).append("\n");
                }
            }
            throw new InvalidConfigurationException(buf.toString());
        }
        this.gbeanInfo = this.rebuildGBeanInfo(gbeanInfo.getConstructor(), gbeanInfo.getJ2eeType());
        this.rawInvoker = new RawInvoker(this);
        try {
            Map dataAttributes = gbeanData.getAttributes();
            Iterator iterator6 = dataAttributes.entrySet().iterator();
            while (iterator6.hasNext()) {
                Map.Entry entry = iterator6.next();
                String attributeName = (String)entry.getKey();
                Object attributeValue = entry.getValue();
                if ("gbeanEnabled".equals(attributeName)) {
                    this.enabled = (Boolean)attributeValue;
                    continue;
                }
                if (entry.getValue() == null) continue;
                this.setAttribute(attributeName, attributeValue, false);
            }
            Map dataReferences = gbeanData.getReferences();
            Iterator iterator7 = dataReferences.entrySet().iterator();
            while (iterator7.hasNext()) {
                Map.Entry entry = iterator7.next();
                String referenceName = (String)entry.getKey();
                Set referencePattern = (Set)entry.getValue();
                this.getReferenceByName(referenceName).setPatterns(referencePattern);
            }
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("GBeanData could not be loaded into the GBeanMBean", e);
        }
        for (i = 0; i < this.references.length; ++i) {
            this.references[i].online();
        }
        for (i = 0; i < this.dependencies.length; ++i) {
            this.dependencies[i].online();
        }
        lifecycleBroadcaster.fireLoadedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() throws GBeanNotFoundException {
        int i;
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new GBeanNotFoundException(this.objectName);
            }
            this.dead = true;
        }
        int state = this.getState();
        if (state != 3 && state != 4) {
            log.error((Object)("GBeanInstance should already be stopped before die() is called: objectName=" + this.objectName + " state=" + State.fromInt(state)));
        }
        this.gbeanInstanceState.fail();
        for (i = 0; i < this.references.length; ++i) {
            this.references[i].offline();
        }
        for (i = 0; i < this.dependencies.length; ++i) {
            this.dependencies[i].offline();
        }
        this.lifecycleBroadcaster.fireUnloadedEvent();
        if (this.manageableStore != null) {
            this.kernel.getProxyManager().destroyProxy(this.manageableStore);
            this.manageableStore = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized boolean isDead() {
        return this.dead;
    }

    public Class getType() {
        return this.type;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public final String getObjectName() {
        return this.objectName.getCanonicalName();
    }

    public final ObjectName getObjectNameObject() {
        return this.objectName;
    }

    public final synchronized boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final synchronized long getStartTime() {
        return this.startTime;
    }

    public int getState() {
        return this.gbeanInstanceState.getState();
    }

    public final State getStateInstance() {
        return this.gbeanInstanceState.getStateInstance();
    }

    public Map getAttributeIndex() {
        return Collections.unmodifiableMap(new HashMap(this.attributeIndex));
    }

    public Map getOperationIndex() {
        return Collections.unmodifiableMap(new HashMap(this.operationIndex));
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new IllegalStateException("A dead GBean can not be started: objectName=" + this.objectName);
            }
            if (!this.enabled) {
                throw new IllegalStateException("A disabled GBean can not be started: objectName=" + this.objectName);
            }
        }
        this.gbeanInstanceState.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRecursive() {
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (this.dead) {
                throw new IllegalStateException("A dead GBean can not be started: objectName=" + this.objectName);
            }
            if (!this.enabled) {
                throw new IllegalStateException("A disabled GBean can not be started: objectName=" + this.objectName);
            }
        }
        this.gbeanInstanceState.startRecursive();
    }

    public final void stop() {
        this.gbeanInstanceState.stop();
    }

    final void referenceFailed() {
        this.gbeanInstanceState.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GBeanData getGBeanData() {
        String name;
        int i;
        Object instance;
        int state;
        GBeanData gbeanData = new GBeanData(this.objectName, this.gbeanInfo);
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        for (i = 0; i < this.attributes.length; ++i) {
            Object value;
            GBeanAttribute attribute = this.attributes[i];
            if (!attribute.isPersistent()) continue;
            name = attribute.getName();
            if ((state != 0 || attribute.isFramework()) && attribute.isReadable()) {
                try {
                    value = attribute.getValue(instance);
                }
                catch (Throwable throwable) {
                    value = attribute.getPersistentValue();
                    log.debug((Object)("Could not get the current value of persistent attribute.  The persistent attribute will not reflect the current state attribute. " + attribute.getDescription()), throwable);
                }
            } else {
                value = attribute.getPersistentValue();
            }
            gbeanData.setAttribute(name, value);
        }
        for (i = 0; i < this.references.length; ++i) {
            GBeanReference reference = this.references[i];
            name = reference.getName();
            Set patterns = reference.getPatterns();
            gbeanData.setReferencePatterns(name, patterns);
        }
        return gbeanData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(int index) throws Exception {
        Object instance;
        int state;
        GBeanAttribute attribute = this.attributes[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            return attribute.getValue(instance);
        }
        if (attribute.isPersistent()) {
            return attribute.getPersistentValue();
        }
        throw new IllegalStateException("Cannot retrieve the value for non-persistent attribute " + attribute.getName() + " when GBeanInstance is DESTROYED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attributeName) throws NoSuchAttributeException, Exception {
        Object instance;
        int state;
        GBeanAttribute attribute;
        try {
            attribute = this.getAttributeByName(attributeName);
        }
        catch (NoSuchAttributeException e) {
            if (attributeName.equals(RAW_INVOKER)) {
                return this.rawInvoker;
            }
            throw e;
        }
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            return attribute.getValue(instance);
        }
        if (attribute.isPersistent()) {
            return attribute.getPersistentValue();
        }
        throw new IllegalStateException("Cannot retrieve the value for non-persistent attribute " + attributeName + " when GBeanInstance is DESTROYED");
    }

    public void setAttribute(int index, Object value) throws Exception, IndexOutOfBoundsException {
        this.setAttribute(index, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(int index, Object value, boolean manage) throws Exception, IndexOutOfBoundsException {
        Object instance;
        int state;
        GBeanAttribute attribute = this.attributes[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            attribute.setValue(instance, value);
        } else {
            attribute.setPersistentValue(value);
        }
        if (manage && attribute.isManageable()) {
            this.updateManageableAttribute(attribute, value);
        }
    }

    public void setAttribute(String attributeName, Object value) throws Exception, NoSuchAttributeException {
        this.setAttribute(attributeName, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String attributeName, Object value, boolean manage) throws Exception, NoSuchAttributeException {
        Object instance;
        int state;
        GBeanAttribute attribute = this.getAttributeByName(attributeName);
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state != 0 || attribute.isFramework()) {
            attribute.setValue(instance, value);
        } else {
            attribute.setPersistentValue(value);
        }
        if (manage && attribute.isManageable()) {
            this.updateManageableAttribute(attribute, value);
        }
    }

    private void updateManageableAttribute(GBeanAttribute attribute, Object value) {
        if (this.manageableStore == null) {
            Set set = this.kernel.listGBeans(new GBeanQuery(null, ManageableAttributeStore.class.getName()));
            if (set.size() == 0) {
                return;
            }
            this.manageableStore = (ManageableAttributeStore)this.kernel.getProxyManager().createProxy((ObjectName)set.iterator().next(), ManageableAttributeStore.class);
        }
        String configName = null;
        Set set = this.kernel.getDependencyManager().getParents(this.objectName);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName name = (ObjectName)iterator.next();
            if (!Configuration.isConfigurationObjectName(name)) continue;
            configName = ObjectName.unquote(name.getKeyProperty("name"));
            break;
        }
        if (configName != null) {
            this.manageableStore.setValue(configName, this.objectName, attribute.getAttributeInfo(), value);
        } else {
            log.error((Object)("Unable to identify Configuration for GBean " + this.objectName + ".  Manageable attribute " + attribute.getName() + " was not updated in persistent store."));
        }
    }

    private GBeanAttribute getAttributeByName(String name) throws NoSuchAttributeException {
        Integer index = (Integer)this.attributeIndex.get(name);
        if (index == null) {
            throw new NoSuchAttributeException("Unknown attribute " + name + " in gbean " + this.objectName);
        }
        GBeanAttribute attribute = this.attributes[index];
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(int index, Object[] arguments) throws Exception {
        Object instance;
        int state;
        GBeanOperation operation = this.operations[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state == 0 && !operation.isFramework()) {
            throw new IllegalStateException("Operations can only be invoke while the GBean instance is running: " + this.objectName);
        }
        return operation.invoke(instance, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String operationName, Object[] arguments, String[] types) throws Exception, NoSuchOperationException {
        Object instance;
        int state;
        GOperationSignature signature = new GOperationSignature(operationName, types);
        Integer index = (Integer)this.operationIndex.get(signature);
        if (index == null) {
            throw new NoSuchOperationException("Unknown operation " + signature);
        }
        GBeanOperation operation = this.operations[index];
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            state = this.instanceState;
            instance = this.target;
        }
        if (state == 0 && !operation.isFramework()) {
            throw new IllegalStateException("Operations can only be invoke while the GBean is running: " + this.objectName);
        }
        return operation.invoke(instance, arguments);
    }

    private GBeanReference getReferenceByName(String name) {
        Integer index = (Integer)this.referenceIndex.get(name);
        if (index == null) {
            throw new IllegalArgumentException("Unknown reference " + name);
        }
        GBeanReference reference = this.references[index];
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createInstance() throws Exception {
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            int i;
            if (this.instanceState == 1 || this.instanceState == 2) {
                return false;
            }
            if (this.instanceState == 3) {
                throw new IllegalStateException("A stopping instance can not be started until fully stopped");
            }
            if (!$assertionsDisabled && this.instanceState != 0) {
                throw new AssertionError();
            }
            boolean allStarted = true;
            for (i = 0; i < this.references.length; ++i) {
                allStarted = this.references[i].start() && allStarted;
            }
            for (i = 0; i < this.dependencies.length; ++i) {
                allStarted = this.dependencies[i].start() && allStarted;
            }
            if (!allStarted) {
                return false;
            }
            this.instanceState = 1;
            this.startTime = System.currentTimeMillis();
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Object instance = null;
        try {
            int i;
            GConstructorInfo constructorInfo = this.gbeanInfo.getConstructor();
            Class<?>[] parameterTypes = this.constructor.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            Iterator names = constructorInfo.getAttributeNames().iterator();
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                String name = (String)names.next();
                if (this.attributeIndex.containsKey(name)) {
                    GBeanAttribute attribute = this.getAttributeByName(name);
                    parameters[i2] = attribute.getPersistentValue();
                    continue;
                }
                if (this.referenceIndex.containsKey(name)) {
                    parameters[i2] = this.getReferenceByName(name).getProxy();
                    continue;
                }
                throw new InvalidConfigurationException("Unknown attribute or reference name in constructor: name=" + name);
            }
            try {
                instance = this.constructor.newInstance(parameters);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                throw e;
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("Constructor mismatch for " + this.objectName), (Throwable)e);
                throw e;
            }
            GBeanInstance e = this;
            synchronized (e) {
                this.target = instance;
            }
            for (i = 0; i < this.attributes.length; ++i) {
                this.checkIfShouldFail();
                this.attributes[i].inject(instance);
            }
            for (i = 0; i < this.references.length; ++i) {
                this.checkIfShouldFail();
                this.references[i].inject(instance);
            }
            if (instance instanceof GBeanLifecycle) {
                this.checkIfShouldFail();
                ((GBeanLifecycle)instance).doStart();
            }
            GBeanInstance gBeanInstance2 = this;
            synchronized (gBeanInstance2) {
                this.checkIfShouldFail();
                this.instanceState = 2;
                this.notifyAll();
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            GBeanInstance parameterTypes = this;
            synchronized (parameterTypes) {
                this.instanceState = 3;
            }
            if (instance instanceof GBeanLifecycle) {
                try {
                    ((GBeanLifecycle)instance).doFail();
                }
                catch (Throwable ignored) {
                    log.error((Object)("Problem in doFail of " + this.objectName), ignored);
                }
            }
            GBeanInstance gBeanInstance3 = this;
            synchronized (gBeanInstance3) {
                int i;
                for (i = 0; i < this.references.length; ++i) {
                    this.references[i].stop();
                }
                for (i = 0; i < this.dependencies.length; ++i) {
                    this.dependencies[i].stop();
                }
                this.target = null;
                this.instanceState = 0;
                this.startTime = 0L;
                this.notifyAll();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private synchronized void checkIfShouldFail() throws Exception {
        if (this.shouldFail) {
            this.shouldFail = false;
            throw new Exception("A reference has failed so construction can not complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean destroyInstance(boolean stop) throws Exception {
        Object instance;
        GBeanInstance gBeanInstance = this;
        synchronized (gBeanInstance) {
            if (!stop && this.instanceState == 1) {
                this.shouldFail = true;
                return false;
            }
            while (this.instanceState == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw e;
                }
            }
            if (this.instanceState == 3 || this.instanceState == 0) {
                return false;
            }
            if (!$assertionsDisabled && this.instanceState != 2) {
                throw new AssertionError();
            }
            this.instanceState = 3;
            instance = this.target;
        }
        Exception problem = null;
        if (stop && instance != null) {
            try {
                Object value;
                GBeanAttribute attribute;
                int i;
                HashMap<GBeanAttribute, Object> data = new HashMap<GBeanAttribute, Object>();
                for (i = 0; i < this.attributes.length; ++i) {
                    attribute = this.attributes[i];
                    if (!attribute.isPersistent() || !attribute.isReadable()) continue;
                    value = null;
                    try {
                        value = attribute.getValue(instance);
                    }
                    catch (Throwable e) {
                        throw new Exception("Problem while updaing the persistent value of attibute: Attribute Name: " + attribute.getName() + ", " + "Type: " + attribute.getType() + ", " + "GBeanInstance: " + this.getName(), e);
                    }
                    data.put(attribute, value);
                }
                for (i = 0; i < this.attributes.length; ++i) {
                    attribute = this.attributes[i];
                    if (!attribute.isPersistent() || !attribute.isReadable()) continue;
                    value = data.get(attribute);
                    attribute.setPersistentValue(value);
                }
            }
            catch (Exception e) {
                stop = false;
                problem = e;
            }
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            if (instance instanceof GBeanLifecycle) {
                if (stop) {
                    try {
                        ((GBeanLifecycle)instance).doStop();
                    }
                    catch (Throwable ignored) {
                        log.error((Object)("Problem in doStop of " + this.objectName), ignored);
                    }
                } else {
                    try {
                        ((GBeanLifecycle)instance).doFail();
                    }
                    catch (Throwable ignored) {
                        log.error((Object)("Problem in doFail of " + this.objectName), ignored);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        GBeanInstance gBeanInstance2 = this;
        synchronized (gBeanInstance2) {
            int i;
            for (i = 0; i < this.references.length; ++i) {
                this.references[i].stop();
            }
            for (i = 0; i < this.dependencies.length; ++i) {
                this.dependencies[i].stop();
            }
            this.target = null;
            this.instanceState = 0;
            this.startTime = 0L;
        }
        if (problem != null) {
            throw problem;
        }
        return true;
    }

    private void addManagedObjectAttributes(Map attributesMap) {
        attributesMap.put("objectName", GBeanAttribute.createSpecialAttribute((GBeanAttribute)attributesMap.get("objectName"), this, "objectName", String.class, this.getObjectName()));
        attributesMap.put("classLoader", GBeanAttribute.createSpecialAttribute((GBeanAttribute)attributesMap.get("classLoader"), this, "classLoader", ClassLoader.class, this.classLoader));
        attributesMap.put("kernel", GBeanAttribute.createSpecialAttribute((GBeanAttribute)attributesMap.get("kernel"), this, "kernel", Kernel.class, this.kernel));
    }

    private GBeanInfo rebuildGBeanInfo(GConstructorInfo constructor, String j2eeType) {
        HashSet<GAttributeInfo> attributeInfos = new HashSet<GAttributeInfo>();
        for (int i = 0; i < this.attributes.length; ++i) {
            GBeanAttribute attribute = this.attributes[i];
            attributeInfos.add(attribute.getAttributeInfo());
        }
        HashSet<GOperationInfo> operationInfos = new HashSet<GOperationInfo>();
        for (int i = 0; i < this.operations.length; ++i) {
            operationInfos.add(this.operations[i].getOperationInfo());
        }
        HashSet<GReferenceInfo> referenceInfos = new HashSet<GReferenceInfo>();
        for (int i = 0; i < this.references.length; ++i) {
            referenceInfos.add(this.references[i].getReferenceInfo());
        }
        HashSet<String> interfaceInfos = new HashSet<String>();
        for (int i = 0; i < this.interfaces.length; ++i) {
            interfaceInfos.add(this.interfaces[i]);
        }
        return new GBeanInfo(this.name, this.type.getName(), j2eeType, attributeInfos, constructor, operationInfos, referenceInfos, interfaceInfos);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GBeanInstance)) {
            return false;
        }
        return this.objectName.equals(((GBeanInstance)obj).objectName);
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }

    public String toString() {
        return this.objectName.toString();
    }

    static {
        $assertionsDisabled = !GBeanInstance.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GBeanInstance.class);
    }
}

