/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.basic.BasicProxyMap;
import org.apache.geronimo.kernel.basic.ProxyMethodInterceptor;
import org.apache.geronimo.kernel.proxy.ProxyCreationException;
import org.apache.geronimo.kernel.proxy.ProxyFactory;
import org.apache.geronimo.kernel.proxy.ProxyManager;

public class BasicProxyManager
implements ProxyManager {
    private static final String MANAGED_BEAN_NAME = "org.apache.geronimo.kernel.proxy.GeronimoManagedBean";
    private static final Log log = LogFactory.getLog((Class)BasicProxyManager.class);
    private final Kernel kernel;
    private final Map interceptors = Collections.synchronizedMap(new BasicProxyMap());
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$proxy$MethodInterceptor;

    public BasicProxyManager(Kernel kernel) {
        this.kernel = kernel;
    }

    public ProxyFactory createProxyFactory(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        ClassLoader classLoader = type.getClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return this.createProxyFactory(new Class[]{type}, classLoader);
    }

    public ProxyFactory createProxyFactory(Class[] types, ClassLoader classLoader) {
        if (types == null) {
            throw new NullPointerException("type is null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("interface list is empty");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        Class<?> managedBean = null;
        try {
            managedBean = classLoader.loadClass(MANAGED_BEAN_NAME);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Unable to add GeronimoManagedBean to proxy (specified class loader does not have class)");
        }
        if (managedBean != null) {
            Class[] adjusted = new Class[types.length + 1];
            System.arraycopy(types, 0, adjusted, 0, types.length);
            adjusted[types.length] = managedBean;
            types = adjusted;
        }
        return new ManagedProxyFactory(types, classLoader);
    }

    public Object createProxy(ObjectName target, Class type) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        ProxyFactory proxyFactory = this.createProxyFactory(type);
        Object proxy = proxyFactory.createProxy(target);
        return proxy;
    }

    public Object createProxy(ObjectName target, ClassLoader classLoader) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(target);
            Set interfaces = info.getInterfaces();
            if (interfaces.size() == 0) {
                log.warn((Object)("No interfaces found for " + target + " (" + info.getClassName() + ")"));
                return null;
            }
            String[] names = interfaces.toArray(new String[0]);
            ArrayList intfs = new ArrayList();
            for (int i = 0; i < names.length; ++i) {
                try {
                    intfs.add(classLoader.loadClass(names[i]));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Could not load interface " + names[i] + " in provided ClassLoader for " + target.getKeyProperty("name")));
                }
            }
            return this.createProxyFactory(intfs.toArray(new Class[intfs.size()]), classLoader).createProxy(target);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalArgumentException("Could not get GBeanInfo for target object: " + target);
        }
    }

    public Object[] createProxies(String[] objectNameStrings, ClassLoader classLoader) throws MalformedObjectNameException {
        Object[] result = new Object[objectNameStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createProxy(ObjectName.getInstance(objectNameStrings[i]), classLoader);
        }
        return result;
    }

    public void destroyProxy(Object proxy) {
        if (proxy == null) {
            return;
        }
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.remove(proxy);
        if (methodInterceptor != null) {
            this.doDestroy(methodInterceptor);
        }
    }

    public boolean isProxy(Object proxy) {
        return this.interceptors.containsKey(proxy);
    }

    public ObjectName getProxyTarget(Object proxy) {
        MethodInterceptor methodInterceptor = (MethodInterceptor)this.interceptors.get(proxy);
        if (methodInterceptor == null) {
            return null;
        }
        return this.getObjectName(methodInterceptor);
    }

    protected Callback getMethodInterceptor(Class proxyType, Kernel kernel, ObjectName target) {
        return new ProxyMethodInterceptor(proxyType, kernel, target);
    }

    protected void doDestroy(MethodInterceptor methodInterceptor) {
        ((ProxyMethodInterceptor)methodInterceptor).destroy();
    }

    protected ObjectName getObjectName(MethodInterceptor methodInterceptor) {
        return ((ProxyMethodInterceptor)methodInterceptor).getObjectName();
    }

    private class ManagedProxyFactory
    implements ProxyFactory {
        private final Class proxyType;
        private final FastClass fastClass;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ManagedProxyFactory(Class type, ClassLoader classLoader) {
            this(new Class[]{type}, classLoader);
        }

        public ManagedProxyFactory(Class[] type, ClassLoader classLoader) {
            Enhancer enhancer = new Enhancer();
            if (type.length > 1) {
                type = this.reduceInterfaces(type);
            }
            if (type.length == 0) {
                throw new IllegalArgumentException("Cannot generate proxy for 0 interfaces!");
            }
            if (type.length == 1) {
                enhancer.setSuperclass(type[0]);
            } else if (type[0].isInterface()) {
                enhancer.setSuperclass(class$java$lang$Object == null ? (class$java$lang$Object = BasicProxyManager.class$("java.lang.Object")) : class$java$lang$Object);
                enhancer.setInterfaces(type);
            } else {
                Class[] intfs = new Class[type.length - 1];
                System.arraycopy(type, 1, intfs, 0, intfs.length);
                enhancer.setSuperclass(type[0]);
                enhancer.setInterfaces(intfs);
            }
            enhancer.setClassLoader(classLoader);
            enhancer.setCallbackType(class$net$sf$cglib$proxy$MethodInterceptor == null ? (class$net$sf$cglib$proxy$MethodInterceptor = BasicProxyManager.class$("net.sf.cglib.proxy.MethodInterceptor")) : class$net$sf$cglib$proxy$MethodInterceptor);
            enhancer.setUseFactory(false);
            this.proxyType = enhancer.createClass();
            this.fastClass = FastClass.create((Class)this.proxyType);
        }

        public Object createProxy(ObjectName target) {
            if (!$assertionsDisabled && target == null) {
                throw new AssertionError((Object)"target is null");
            }
            Callback callback = BasicProxyManager.this.getMethodInterceptor(this.proxyType, BasicProxyManager.this.kernel, target);
            Enhancer.registerCallbacks((Class)this.proxyType, (Callback[])new Callback[]{callback});
            try {
                Object proxy = this.fastClass.newInstance();
                BasicProxyManager.this.interceptors.put(proxy, callback);
                return proxy;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (RuntimeException)cause;
                }
                if (cause != null) {
                    throw new ProxyCreationException(cause);
                }
                throw new ProxyCreationException(e);
            }
        }

        private Class[] reduceInterfaces(Class[] source) {
            int i;
            boolean changed = false;
            Class cls = null;
            block0: for (i = 0; i < source.length - 1; ++i) {
                Class original = source[i];
                if (original == null) continue;
                if (!original.isInterface()) {
                    if (cls != null) {
                        throw new IllegalArgumentException(original.getName() + " is not an interface (already have " + cls.getName() + "); can only have one non-interface class for proxy");
                    }
                    cls = original;
                }
                for (int j = i + 1; j < source.length; ++j) {
                    Class other = source[j];
                    if (other == null) continue;
                    if (!other.isInterface()) {
                        if (cls != null) {
                            throw new IllegalArgumentException(other.getName() + " is not an interface (already have " + cls.getName() + "); can only have one non-interface class for proxy");
                        }
                        cls = other;
                    }
                    if (other.isAssignableFrom(original)) {
                        source[j] = null;
                        changed = true;
                        continue;
                    }
                    if (!original.isAssignableFrom(other)) continue;
                    source[i] = null;
                    changed = true;
                    continue block0;
                }
            }
            if (cls != null && cls != source[0]) {
                for (i = 0; i < source.length; ++i) {
                    if (cls != source[i]) continue;
                    Class temp = source[0];
                    source[0] = source[i];
                    source[i] = temp;
                    break;
                }
                changed = true;
            }
            if (!changed) {
                return source;
            }
            ArrayList<Class> list = new ArrayList<Class>(source.length);
            for (int i2 = 0; i2 < source.length; ++i2) {
                if (source[i2] == null) continue;
                list.add(source[i2]);
            }
            return list.toArray(new Class[list.size()]);
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$kernel$basic$BasicProxyManager == null ? (class$org$apache$geronimo$kernel$basic$BasicProxyManager = BasicProxyManager.class$("org.apache.geronimo.kernel.basic.BasicProxyManager")) : class$org$apache$geronimo$kernel$basic$BasicProxyManager).desiredAssertionStatus();
        }
    }
}

