/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class ConfigurationManagerImpl
implements ConfigurationManager,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ConfigurationManagerImpl.class);
    protected final Kernel kernel;
    private final Collection stores;
    protected final ManageableAttributeStore attributeStore;
    protected final PersistentConfigurationList configurationList;
    private final ShutdownHook shutdownHook;
    private static final ObjectName CONFIGURATION_NAME_QUERY;
    private static final ObjectName CONFIG_QUERY;
    public static final GBeanInfo GBEAN_INFO;

    public ConfigurationManagerImpl(Kernel kernel, Collection stores, ManageableAttributeStore attributeStore, PersistentConfigurationList configurationList) {
        this.kernel = kernel;
        this.stores = stores;
        this.attributeStore = attributeStore;
        this.configurationList = configurationList;
        this.shutdownHook = new ShutdownHook(kernel);
    }

    public List listStores() {
        List storeSnapshot = this.getStores();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(storeSnapshot.size());
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            result.add(JMXUtil.getObjectName(store.getObjectName()));
        }
        return result;
    }

    public List listConfigurations(ObjectName storeName) throws NoSuchStoreException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!storeName.equals(JMXUtil.getObjectName(store.getObjectName()))) continue;
            return store.listConfigurations();
        }
        throw new NoSuchStoreException("No such store: " + storeName);
    }

    public boolean isLoaded(URI configID) {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            return this.kernel.isLoaded(name);
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
    }

    public ObjectName load(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        List storeSnapshot = this.getStores();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configID)) continue;
            ObjectName configName = store.loadConfiguration(configID);
            return configName;
        }
        throw new NoSuchConfigException("No configuration with id: " + configID);
    }

    public void loadGBeans(URI configID) throws InvalidConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert ID to ObjectName: ", e);
        }
        try {
            this.kernel.startGBean(configName);
            this.kernel.invoke(configName, "loadGBeans", new Object[]{this.attributeStore}, new String[]{ManageableAttributeStore.class.getName()});
        }
        catch (Exception e) {
            throw new InvalidConfigException("Could not extract gbean data from configuration", e);
        }
    }

    public void start(URI configID) throws InvalidConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert ID to ObjectName: ", e);
        }
        try {
            this.kernel.invoke(configName, "startRecursiveGBeans");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Could not start gbeans in configuration", e);
        }
        if (this.configurationList != null) {
            this.configurationList.addConfiguration(configID.toString());
        }
    }

    public void stop(URI configID) throws InvalidConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException("Cannot convert ID to ObjectName: ", e);
        }
        try {
            this.kernel.invoke(configName, "stopGBeans");
        }
        catch (Exception e) {
            throw new InvalidConfigException("Could not stop gbeans in configuration", e);
        }
        if (this.configurationList != null) {
            this.configurationList.removeConfiguration(configID.toString());
        }
    }

    public List loadRecursive(URI configID) throws NoSuchConfigException, IOException, InvalidConfigException {
        LinkedList ancestors = new LinkedList();
        Set preloaded = this.kernel.listGBeans(CONFIGURATION_NAME_QUERY);
        Iterator it = preloaded.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            try {
                if (this.kernel.getGBeanState(name) == 1) continue;
                it.remove();
            }
            catch (GBeanNotFoundException e) {
                it.remove();
            }
        }
        this.loadRecursive(configID, ancestors, preloaded);
        return ancestors;
    }

    private void loadRecursive(URI configID, LinkedList ancestors, Set preloaded) throws NoSuchConfigException, IOException, InvalidConfigException {
        try {
            ObjectName name = Configuration.getConfigurationObjectName(configID);
            if (preloaded.contains(name)) {
                return;
            }
            if (!this.isLoaded(configID)) {
                this.load(configID);
            }
            ancestors.remove(configID);
            ancestors.addFirst(configID);
            URI[] parents = (URI[])this.kernel.getAttribute(name, "parentId");
            if (parents != null) {
                for (int i = 0; i < parents.length; ++i) {
                    URI parent = parents[i];
                    this.loadRecursive(parent, ancestors, preloaded);
                }
            }
        }
        catch (NoSuchConfigException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidConfigException(e);
        }
    }

    public void unload(URI configID) throws NoSuchConfigException {
        ObjectName configName;
        try {
            configName = Configuration.getConfigurationObjectName(configID);
        }
        catch (MalformedObjectNameException e) {
            throw new NoSuchConfigException("Cannot convert ID to ObjectName: ", e);
        }
        try {
            if (1 == this.kernel.getGBeanState(configName)) {
                this.kernel.invoke(configName, "unloadGBeans");
                this.kernel.stopGBean(configName);
            }
            this.kernel.unloadGBean(configName);
        }
        catch (GBeanNotFoundException e) {
            throw new NoSuchConfigException("No config registered: " + configName, e);
        }
        catch (Exception e) {
            throw new NoSuchConfigException("Problem unloading config: " + configName, e);
        }
    }

    private List getStores() {
        return new ArrayList(this.stores);
    }

    public void doStart() {
        this.kernel.registerShutdownHook(this.shutdownHook);
    }

    public void doStop() {
        this.kernel.unregisterShutdownHook(this.shutdownHook);
    }

    public void doFail() {
        log.error((Object)"Cofiguration manager failed");
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        try {
            CONFIGURATION_NAME_QUERY = new ObjectName("geronimo.config:*");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("could not create object name... bug", e);
        }
        CONFIG_QUERY = JMXUtil.getObjectName("geronimo.config:*");
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(ConfigurationManagerImpl.class, "ConfigurationManager");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addReference("Stores", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addReference("AttributeStore", ManageableAttributeStore.class, "AttributeStore");
        infoFactory.addReference("PersistentConfigurationList", PersistentConfigurationList.class, "PersistentConfigurationList");
        infoFactory.addInterface(ConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores", "AttributeStore", "PersistentConfigurationList"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class ShutdownHook
    implements Runnable {
        private final Kernel kernel;

        public ShutdownHook(Kernel kernel) {
            this.kernel = kernel;
        }

        public void run() {
            Set configs;
            block5: while (!(configs = this.kernel.listGBeans(CONFIG_QUERY)).isEmpty()) {
                Iterator i = configs.iterator();
                while (true) {
                    if (!i.hasNext()) continue block5;
                    ObjectName configName = (ObjectName)i.next();
                    if (!this.kernel.isLoaded(configName)) continue;
                    try {
                        this.kernel.stopGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                    catch (InternalKernelException e) {
                        log.warn((Object)("Could not stop configuration: " + configName), (Throwable)e);
                    }
                    try {
                        this.kernel.unloadGBean(configName);
                    }
                    catch (GBeanNotFoundException e) {
                    }
                }
                break;
            }
            return;
        }
    }
}

