/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;

public final class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    public static ConfigurationManager getConfigurationManager(Kernel kernel) {
        Set names = kernel.listGBeans(new GBeanQuery(null, ConfigurationManager.class.getName()));
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            try {
                if (kernel.getGBeanState(objectName) == 1) continue;
                iterator.remove();
            }
            catch (GBeanNotFoundException e) {
                iterator.remove();
            }
        }
        if (names.isEmpty()) {
            throw new IllegalStateException("Configuration mananger could not be found in kernel");
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More than one configuration mananger was found in kernel");
        }
        ObjectName configurationManagerName = (ObjectName)names.iterator().next();
        return (ConfigurationManager)kernel.getProxyManager().createProxy(configurationManagerName, ConfigurationManager.class);
    }

    public static EditableConfigurationManager getEditableConfigurationManager(Kernel kernel) {
        Set names = kernel.listGBeans(new GBeanQuery(null, EditableConfigurationManager.class.getName()));
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            try {
                if (kernel.getGBeanState(objectName) == 1) continue;
                iterator.remove();
            }
            catch (GBeanNotFoundException e) {
                iterator.remove();
            }
        }
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("More than one configuration mananger was found in kernel");
        }
        ObjectName configurationManagerName = (ObjectName)names.iterator().next();
        return (EditableConfigurationManager)kernel.getProxyManager().createProxy(configurationManagerName, EditableConfigurationManager.class);
    }

    public static void releaseConfigurationManager(Kernel kernel, ConfigurationManager configurationManager) {
        kernel.getProxyManager().destroyProxy(configurationManager);
    }
}

