/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import org.apache.commons.logging.Log;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class BootstrapLog4jLog
implements Log {
    private static final String FQCN;
    private Logger logger;

    public BootstrapLog4jLog(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public void trace(Object message) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, null);
    }

    public void trace(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, throwable);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    public void debug(Object message) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, null);
    }

    public void debug(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    public void info(Object message) {
        this.logger.log(FQCN, (Priority)Level.INFO, message, null);
    }

    public void info(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.INFO, message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(Object message) {
        this.logger.log(FQCN, (Priority)Level.WARN, message, null);
    }

    public void warn(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.WARN, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(Object message) {
        this.logger.log(FQCN, (Priority)Level.ERROR, message, null);
    }

    public void error(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, (Priority)Level.FATAL, message, null);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.FATAL, message, throwable);
    }

    static {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%d{ABSOLUTE} %-5p [%c{1}] %m%n")));
        GeronimoLogging level = GeronimoLogging.getDefaultLevel();
        if (level == null) {
            root.setLevel(Level.ERROR);
        } else if (level == GeronimoLogging.TRACE) {
            root.setLevel(Level.DEBUG);
        } else if (level == GeronimoLogging.DEBUG) {
            root.setLevel(Level.DEBUG);
        } else if (level == GeronimoLogging.INFO) {
            root.setLevel(Level.INFO);
        } else if (level == GeronimoLogging.WARN) {
            root.setLevel(Level.WARN);
        } else if (level == GeronimoLogging.ERROR) {
            root.setLevel(Level.ERROR);
        } else if (level == GeronimoLogging.FATAL) {
            root.setLevel(Level.FATAL);
        }
        FQCN = BootstrapLog4jLog.class.getName();
    }
}

