/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import java.lang.reflect.Method;
import org.apache.commons.logging.LogFactory;

public class GeronimoLogging {
    public static final GeronimoLogging TRACE = new GeronimoLogging("TRACE");
    public static final GeronimoLogging DEBUG = new GeronimoLogging("DEBUG");
    public static final GeronimoLogging INFO = new GeronimoLogging("INFO");
    public static final GeronimoLogging WARN = new GeronimoLogging("WARN");
    public static final GeronimoLogging ERROR = new GeronimoLogging("ERROR");
    public static final GeronimoLogging FATAL = new GeronimoLogging("FATAL");
    private static boolean initialized = false;
    private static GeronimoLogging consoleLogLevel;
    private static GeronimoLogging defaultLevel;
    private final String level;

    public static void initialize(GeronimoLogging level) {
        if (!initialized) {
            defaultLevel = level;
            consoleLogLevel = level;
            LogFactory.getLog((Class)GeronimoLogging.class);
            try {
                Class<?> clazz = Class.forName("mx4j.log.Log");
                Class<?> paramClazz = Class.forName("mx4j.log.Logger");
                Method method = clazz.getDeclaredMethod("redirectTo", paramClazz);
                paramClazz = Class.forName("mx4j.log.CommonsLogger");
                method.invoke(null, paramClazz.newInstance());
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Cannot force MX4J to use commons logging."))).initCause(e));
            }
            initialized = true;
        }
    }

    public static void setDefaultLogLevel(GeronimoLogging level) {
        defaultLevel = level;
    }

    public static GeronimoLogging getDefaultLevel() {
        return defaultLevel;
    }

    public static GeronimoLogging getConsoleLogLevel() {
        return consoleLogLevel;
    }

    public static void setConsoleLogLevel(GeronimoLogging consoleLogLevel) {
        GeronimoLogging.consoleLogLevel = consoleLogLevel;
    }

    private GeronimoLogging(String level) {
        this.level = level;
    }

    public String toString() {
        return this.level;
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

