/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.UserTransaction;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingContext;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.java.ComponentContextBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerCssType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefHandlerType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.geronimo.xbeans.j2ee.XsdStringType;

public class ENCConfigBuilder {
    private static final String JAXR_CONNECTION_FACTORY_CLASS = "javax.xml.registry.ConnectionFactory";
    static /* synthetic */ Class class$java$net$URL;

    public static void registerMessageDestinations(RefContext refContext, String moduleName, MessageDestinationType[] specDestinations, GerMessageDestinationType[] destinations) throws DeploymentException {
        HashMap<String, GerMessageDestinationType> nameMap = new HashMap<String, GerMessageDestinationType>();
        for (int i = 0; i < destinations.length; ++i) {
            GerMessageDestinationType destination = destinations[i];
            String name = destination.getMessageDestinationName().trim();
            nameMap.put(name, destination);
            boolean found = false;
            for (int j = 0; j < specDestinations.length; ++j) {
                MessageDestinationType specDestination = specDestinations[j];
                if (!specDestination.getMessageDestinationName().getStringValue().trim().equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("No spec DD message-destination for " + name);
        }
        refContext.registerMessageDestionations(moduleName, nameMap);
    }

    public static ObjectName getGBeanId(String j2eeType, GerGbeanLocatorType gerGbeanLocator, J2eeContext j2eeContext, DeploymentContext context, Kernel kernel) throws DeploymentException {
        ObjectName containerId = null;
        if (gerGbeanLocator.isSetGbeanLink()) {
            String linkName = gerGbeanLocator.getGbeanLink().trim();
            ObjectName exact = null;
            try {
                exact = NameFactory.getComponentName(null, null, null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Could not construct gbean name", (Throwable)e);
            }
            if (context.listGBeans(exact).size() == 1) {
                containerId = exact;
            } else {
                ObjectName query = null;
                try {
                    query = NameFactory.getComponentNameQuery(null, null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct query for gbean name", (Throwable)e);
                }
                Set localMatches = context.listGBeans(query);
                if (localMatches.size() > 1) {
                    throw new DeploymentException("More than one local match for gbean link, " + localMatches);
                }
                if (localMatches.size() == 1) {
                    containerId = (ObjectName)localMatches.iterator().next();
                }
                if (containerId == null) {
                    try {
                        query = NameFactory.getComponentRestrictedQueryName(null, null, (String)linkName, (String)j2eeType, (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct query for gbean name", (Throwable)e);
                    }
                    Set matches = kernel.listGBeans(query);
                    if (matches.size() != 1) {
                        throw new DeploymentException("No or ambiguous match for gbean link: " + linkName + " using query " + query + ", matches: " + matches);
                    }
                    containerId = (ObjectName)matches.iterator().next();
                }
            }
        } else {
            if (gerGbeanLocator.isSetTargetName()) {
                try {
                    containerId = ObjectName.getInstance(ENCConfigBuilder.getStringValue(gerGbeanLocator.getTargetName()));
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct object name from specified string", (Throwable)e);
                }
            }
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getDomain()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getServer()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getApplication()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getModule()), (String)ENCConfigBuilder.getStringValue(gerGbeanLocator.getName()), (String)j2eeType, (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for jms resource", (Throwable)e);
            }
        }
        return containerId;
    }

    static void addEnvEntries(EnvEntryType[] envEntries, ComponentContextBuilder builder, ClassLoader classLoader) throws DeploymentException {
        for (int i = 0; i < envEntries.length; ++i) {
            EnvEntryType envEntry = envEntries[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)envEntry.getEnvEntryType());
            String text = ENCConfigBuilder.getStringValue(envEntry.getEnvEntryValue());
            try {
                builder.addEnvEntry(name, type, text, classLoader);
                continue;
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Invalid env-entry value for name: " + name, (Throwable)e);
            }
            catch (NamingException e) {
                throw new DeploymentException("Invalid env-entry definition for name: " + name, (Throwable)e);
            }
        }
    }

    static void addResourceRefs(EARContext earContext, URI moduleURI, ResourceRefType[] resourceRefs, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        RefContext refContext = earContext.getRefContext();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRef = resourceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRef.getResType());
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(name);
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            Reference ref = null;
            if (iface == (class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL)) {
                if (gerResourceRef == null || !gerResourceRef.isSetUrl()) {
                    throw new DeploymentException("No url supplied to resolve: " + name);
                }
                try {
                    builder.bind(name, (Object)new URL(gerResourceRef.getUrl()));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not convert " + gerResourceRef.getUrl() + " to URL", (Throwable)e);
                }
            }
            String j2eeType = "javax.mail.Session".equals(type) ? "JavaMailResource" : (JAXR_CONNECTION_FACTORY_CLASS.equals(type) ? "JAXRConnectionFactory" : "JCAManagedConnectionFactory");
            try {
                String containerId = ENCConfigBuilder.getResourceContainerId(name, j2eeType, moduleURI, gerResourceRef, earContext);
                ref = refContext.getConnectionFactoryRef(containerId, iface);
                builder.bind(name, (Object)ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")");
            }
        }
    }

    private static String getResourceContainerId(String name, String type, URI moduleURI, GerResourceRefType gerResourceRef, EARContext context) throws DeploymentException {
        String containerId = null;
        RefContext refContext = context.getRefContext();
        if (gerResourceRef == null) {
            containerId = refContext.getConnectionFactoryContainerId(moduleURI, name, type, (NamingContext)context);
        } else if (gerResourceRef.isSetResourceLink()) {
            containerId = refContext.getConnectionFactoryContainerId(moduleURI, gerResourceRef.getResourceLink().trim(), type, (NamingContext)context);
        } else if (gerResourceRef.isSetTargetName()) {
            containerId = gerResourceRef.getTargetName().trim();
        } else {
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerResourceRef.getDomain()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getServer()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getApplication()), (String)"JCAResource", (String)ENCConfigBuilder.getStringValue(gerResourceRef.getModule()), (String)ENCConfigBuilder.getStringValue(gerResourceRef.getName()), (String)(gerResourceRef.getType() == null ? type : gerResourceRef.getType().trim()), (J2eeContext)context.getJ2eeContext()).getCanonicalName();
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for resource", (Throwable)e);
            }
        }
        return containerId;
    }

    static void addResourceEnvRefs(EARContext earContext, ResourceEnvRefType[] resourceEnvRefArray, Map refMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        if (refMap == null) {
            refMap = Collections.EMPTY_MAP;
        }
        for (int i = 0; i < resourceEnvRefArray.length; ++i) {
            ResourceEnvRefType resourceEnvRef = resourceEnvRefArray[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefName());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceEnvRef.getResourceEnvRefType());
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            GerResourceEnvRefType gerResourceEnvRef = (GerResourceEnvRefType)refMap.get(name);
            try {
                String containerId = ENCConfigBuilder.getAdminObjectContainerId(name, gerResourceEnvRef, earContext);
                Reference ref = earContext.getRefContext().getAdminObjectRef(containerId, iface);
                builder.bind(name, (Object)ref);
                continue;
            }
            catch (UnresolvedReferenceException e) {
                throw new DeploymentException("Unable to resolve resource env reference '" + name + "' (" + (e.isMultiple() ? "found multiple matching resources" : "no matching resources found") + ")");
            }
        }
    }

    private static String getAdminObjectContainerId(String name, GerResourceEnvRefType gerResourceEnvRef, EARContext context) throws DeploymentException {
        String containerId = null;
        RefContext refContext = context.getRefContext();
        URI moduleURI = URI.create("");
        if (gerResourceEnvRef == null) {
            containerId = refContext.getAdminObjectContainerId(moduleURI, name, (NamingContext)context);
        } else if (gerResourceEnvRef.isSetMessageDestinationLink()) {
            containerId = refContext.getAdminObjectContainerId(moduleURI, gerResourceEnvRef.getMessageDestinationLink().trim(), (NamingContext)context);
        } else if (gerResourceEnvRef.isSetAdminObjectLink()) {
            if (gerResourceEnvRef.isSetAdminObjectModule()) {
                try {
                    moduleURI = new URI(gerResourceEnvRef.getAdminObjectModule().trim());
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct module URI", (Throwable)e);
                }
            }
            containerId = refContext.getAdminObjectContainerId(moduleURI, gerResourceEnvRef.getMessageDestinationLink().trim(), (NamingContext)context);
        } else if (gerResourceEnvRef.isSetTargetName()) {
            containerId = ENCConfigBuilder.getStringValue(gerResourceEnvRef.getTargetName());
        } else {
            try {
                containerId = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getDomain()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getServer()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getApplication()), (String)"JCAResource", (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getModule()), (String)ENCConfigBuilder.getStringValue(gerResourceEnvRef.getName()), (String)"JMSResource", (J2eeContext)context.getJ2eeContext()).getCanonicalName();
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("could not construct object name for jms resource", (Throwable)e);
            }
        }
        return containerId;
    }

    static void addMessageDestinationRefs(RefContext refContext, NamingContext namingContext, MessageDestinationRefType[] messageDestinationRefs, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        for (int i = 0; i < messageDestinationRefs.length; ++i) {
            MessageDestinationRefType messageDestinationRef = messageDestinationRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationRefName());
            String linkName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationLink());
            String type = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)messageDestinationRef.getMessageDestinationType());
            Class<?> iface = null;
            try {
                iface = cl.loadClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load class " + type, (Throwable)e);
            }
            URI moduleURI = URI.create("");
            GerMessageDestinationType destination = (GerMessageDestinationType)refContext.getMessageDestination(linkName);
            if (destination != null) {
                if (destination.isSetAdminObjectLink()) {
                    if (destination.isSetAdminObjectModule()) {
                        String module = destination.getAdminObjectModule().trim();
                        try {
                            moduleURI = new URI(module);
                        }
                        catch (URISyntaxException e) {
                            throw new DeploymentException("Could not construct module URI", (Throwable)e);
                        }
                    }
                    linkName = destination.getAdminObjectLink().trim();
                }
            } else {
                int pos = linkName.indexOf(35);
                if (pos > -1) {
                    linkName = linkName.substring(pos + 1);
                }
            }
            String containerId = refContext.getAdminObjectContainerId(moduleURI, linkName, namingContext);
            Reference ref = refContext.getAdminObjectRef(containerId, iface);
            builder.bind(name, (Object)ref);
        }
    }

    static void addEJBRefs(NamingContext earContext, NamingContext ejbContext, RefContext refContext, URI moduleURI, EjbRefType[] ejbRefs, Map ejbRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        J2eeContext j2eeContext = ejbContext.getJ2eeContext();
        for (int i = 0; i < ejbRefs.length; ++i) {
            Reference ejbReference;
            EjbRefType ejbRef = ejbRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefName());
            String remote = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getRemote());
            try {
                ENCConfigBuilder.assureEJBObjectInterface(remote, cl);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error processing 'remote' element for EJB Reference '" + ejbRefName + "' for module '" + moduleURI + "': " + e.getMessage());
            }
            String home = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getHome());
            try {
                ENCConfigBuilder.assureEJBHomeInterface(home, cl);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error processing 'home' element for EJB Reference '" + ejbRefName + "' for module '" + moduleURI + "': " + e.getMessage());
            }
            boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbRefType()));
            if (isSession && remote.equals("javax.management.j2ee.Management") && home.equals("javax.management.j2ee.ManagementHome")) {
                String mejbName = refContext.getMEJBName();
                ejbReference = refContext.getEJBRemoteRef(mejbName, isSession, home, remote);
            } else {
                String ejbLink = null;
                GerEjbRefType remoteRef = (GerEjbRefType)ejbRefMap.get(ejbRefName);
                if (remoteRef != null && remoteRef.isSetNsCorbaloc()) {
                    try {
                        ObjectName cssBean;
                        if (remoteRef.isSetCssName()) {
                            cssBean = ObjectName.getInstance(ENCConfigBuilder.getStringValue(remoteRef.getCssName()));
                        } else if (remoteRef.isSetCssLink()) {
                            String cssLink = remoteRef.getCssLink().trim();
                            String moduleType = null;
                            cssBean = refContext.locateComponentName(cssLink, moduleURI, moduleType, "CORBACSS", earContext.getJ2eeContext(), earContext, "css gbean");
                        } else {
                            GerCssType css = remoteRef.getCss();
                            cssBean = NameFactory.getComponentName((String)ENCConfigBuilder.getStringValue(css.getDomain()), (String)ENCConfigBuilder.getStringValue(css.getServer()), (String)ENCConfigBuilder.getStringValue(css.getApplication()), (String)ENCConfigBuilder.getStringValue(css.getModule()), (String)ENCConfigBuilder.getStringValue(css.getName()), (String)ENCConfigBuilder.getStringValue("CORBACSS"), (J2eeContext)earContext.getJ2eeContext());
                        }
                        ejbReference = refContext.getCORBARemoteRef(new URI(ENCConfigBuilder.getStringValue(remoteRef.getNsCorbaloc())), ENCConfigBuilder.getStringValue(remoteRef.getName()), ObjectName.getInstance(cssBean), home);
                    }
                    catch (URISyntaxException e) {
                        throw new DeploymentException("Could not construct CORBA NameServer URI: " + remoteRef.getNsCorbaloc(), (Throwable)e);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct CSS container name: " + remoteRef.getCssName(), (Throwable)e);
                    }
                }
                if (remoteRef != null && remoteRef.isSetEjbLink()) {
                    ejbLink = remoteRef.getEjbLink();
                } else if (ejbRef.isSetEjbLink()) {
                    ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbRef.getEjbLink());
                }
                if (ejbLink != null) {
                    ejbReference = refContext.getEJBRemoteRef(moduleURI, ejbLink, isSession, home, remote, ejbContext);
                } else if (remoteRef != null) {
                    if (remoteRef.isSetTargetName()) {
                        ejbReference = refContext.getEJBRemoteRef(ENCConfigBuilder.getStringValue(remoteRef.getTargetName()), isSession, home, remote);
                    } else {
                        String containerId = null;
                        try {
                            containerId = NameFactory.getEjbComponentNameString((String)ENCConfigBuilder.getStringValue(remoteRef.getDomain()), (String)ENCConfigBuilder.getStringValue(remoteRef.getServer()), (String)ENCConfigBuilder.getStringValue(remoteRef.getApplication()), (String)ENCConfigBuilder.getStringValue(remoteRef.getModule()), (String)ENCConfigBuilder.getStringValue(remoteRef.getName()), (String)ENCConfigBuilder.getStringValue(remoteRef.getType()), (J2eeContext)j2eeContext);
                        }
                        catch (MalformedObjectNameException e) {
                            throw new DeploymentException("Could not construct ejb object name: " + remoteRef.getName(), (Throwable)e);
                        }
                        ejbReference = refContext.getEJBRemoteRef(containerId, isSession, home, remote);
                    }
                } else {
                    ejbReference = refContext.getImplicitEJBRemoteRef(moduleURI, ejbRefName, isSession, home, remote, ejbContext);
                }
            }
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    static void addEJBLocalRefs(NamingContext ejbContext, RefContext refContext, URI moduleURI, EjbLocalRefType[] ejbLocalRefs, Map ejbLocalRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        J2eeContext j2eeContext = ejbContext.getJ2eeContext();
        for (int i = 0; i < ejbLocalRefs.length; ++i) {
            Reference ejbReference;
            EjbLocalRefType ejbLocalRef = ejbLocalRefs[i];
            String ejbRefName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefName());
            String local = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocal());
            try {
                ENCConfigBuilder.assureEJBLocalObjectInterface(local, cl);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error processing 'local' element for EJB Local Reference '" + ejbRefName + "' for module '" + moduleURI + "': " + e.getMessage());
            }
            String localHome = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getLocalHome());
            try {
                ENCConfigBuilder.assureEJBLocalHomeInterface(localHome, cl);
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error processing 'local-home' element for EJB Local Reference '" + ejbRefName + "' for module '" + moduleURI + "': " + e.getMessage());
            }
            boolean isSession = "Session".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbRefType()));
            String ejbLink = null;
            GerEjbLocalRefType localRef = (GerEjbLocalRefType)ejbLocalRefMap.get(ejbRefName);
            if (localRef != null && localRef.isSetEjbLink()) {
                ejbLink = localRef.getEjbLink();
            } else if (ejbLocalRef.isSetEjbLink()) {
                ejbLink = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)ejbLocalRef.getEjbLink());
            }
            if (ejbLink != null) {
                ejbReference = refContext.getEJBLocalRef(moduleURI, ejbLink, isSession, localHome, local, ejbContext);
            } else if (localRef != null) {
                if (localRef.isSetTargetName()) {
                    ejbReference = refContext.getEJBLocalRef(ENCConfigBuilder.getStringValue(localRef.getTargetName()), isSession, localHome, local);
                } else {
                    String containerId = null;
                    try {
                        containerId = NameFactory.getEjbComponentNameString((String)ENCConfigBuilder.getStringValue(localRef.getDomain()), (String)ENCConfigBuilder.getStringValue(localRef.getServer()), (String)ENCConfigBuilder.getStringValue(localRef.getApplication()), (String)ENCConfigBuilder.getStringValue(localRef.getModule()), (String)ENCConfigBuilder.getStringValue(localRef.getName()), (String)ENCConfigBuilder.getStringValue(localRef.getType()), (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct ejb object name: " + localRef.getName(), (Throwable)e);
                    }
                    ejbReference = refContext.getEJBLocalRef(containerId, isSession, localHome, local);
                }
            } else {
                ejbReference = refContext.getImplicitEJBLocalRef(moduleURI, ejbLink, isSession, localHome, local, ejbContext);
            }
            builder.bind(ejbRefName, (Object)ejbReference);
        }
    }

    static void addServiceRefs(EARContext earContext, Module module, ServiceRefType[] serviceRefs, Map serviceRefMap, ClassLoader cl, ComponentContextBuilder builder) throws DeploymentException {
        RefContext refContext = earContext.getRefContext();
        for (int i = 0; i < serviceRefs.length; ++i) {
            ServiceRefType serviceRef = serviceRefs[i];
            String name = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceRefName());
            GerServiceRefType serviceRefType = (GerServiceRefType)serviceRefMap.get(name);
            String serviceInterfaceName = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getServiceInterface());
            ENCConfigBuilder.assureInterface(serviceInterfaceName, "javax.xml.rpc.Service", "[Web]Service", cl);
            Class<?> serviceInterface = null;
            try {
                serviceInterface = cl.loadClass(serviceInterfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load service interface class: " + serviceInterfaceName, (Throwable)e);
            }
            URI wsdlURI = null;
            if (serviceRef.isSetWsdlFile()) {
                try {
                    wsdlURI = new URI(ENCConfigBuilder.getStringValue(serviceRef.getWsdlFile().getStringValue()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("could not construct wsdl uri from " + serviceRef.getWsdlFile().getStringValue(), (Throwable)e);
                }
            }
            URI jaxrpcMappingURI = null;
            if (serviceRef.isSetJaxrpcMappingFile()) {
                try {
                    jaxrpcMappingURI = new URI(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)serviceRef.getJaxrpcMappingFile()));
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Could not construct jaxrpc mapping uri from " + serviceRef.getJaxrpcMappingFile(), (Throwable)e);
                }
            }
            QName serviceQName = null;
            if (serviceRef.isSetServiceQname()) {
                serviceQName = serviceRef.getServiceQname().getQNameValue();
            }
            HashMap portComponentRefMap = new HashMap();
            PortComponentRefType[] portComponentRefs = serviceRef.getPortComponentRefArray();
            if (portComponentRefs != null) {
                for (int j = 0; j < portComponentRefs.length; ++j) {
                    Class<?> serviceEndpointClass;
                    PortComponentRefType portComponentRef = portComponentRefs[j];
                    String portComponentLink = ENCConfigBuilder.getStringValue(portComponentRef.getPortComponentLink());
                    String serviceEndpointInterfaceType = ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)portComponentRef.getServiceEndpointInterface());
                    ENCConfigBuilder.assureInterface(serviceEndpointInterfaceType, "java.rmi.Remote", "ServiceEndpoint", cl);
                    try {
                        serviceEndpointClass = cl.loadClass(serviceEndpointInterfaceType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentException("could not load service endpoint class " + serviceEndpointInterfaceType, (Throwable)e);
                    }
                    portComponentRefMap.put(serviceEndpointClass, portComponentLink);
                }
            }
            ServiceRefHandlerType[] handlers = serviceRef.getHandlerArray();
            List handlerInfos = ENCConfigBuilder.buildHandlerInfoList(handlers, cl);
            Object ref = refContext.getServiceReference(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, (Object)serviceRefType, (DeploymentContext)earContext, module, cl);
            builder.bind(name, ref);
        }
    }

    private static List buildHandlerInfoList(ServiceRefHandlerType[] handlers, ClassLoader classLoader) throws DeploymentException {
        ArrayList<ServiceReferenceBuilder.HandlerInfoInfo> handlerInfos = new ArrayList<ServiceReferenceBuilder.HandlerInfoInfo>();
        for (int i = 0; i < handlers.length; ++i) {
            ServiceRefHandlerType handler = handlers[i];
            org.apache.geronimo.xbeans.j2ee.String[] portNameArray = handler.getPortNameArray();
            ArrayList<String> portNames = new ArrayList<String>();
            for (int j = 0; j < portNameArray.length; ++j) {
                portNames.add(portNameArray[j].getStringValue().trim());
            }
            String handlerClassName = handler.getHandlerClass().getStringValue().trim();
            Class handlerClass = null;
            try {
                handlerClass = ClassLoading.loadClass((String)handlerClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load handler class", (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            ParamValueType[] paramValues = handler.getInitParamArray();
            for (int j = 0; j < paramValues.length; ++j) {
                ParamValueType paramValue = paramValues[j];
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headerQNames = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headerQNames[j] = soapHeaderQName.getQNameValue();
            }
            HashSet<String> soapRoles = new HashSet<String>();
            for (int j = 0; j < handler.getSoapRoleArray().length; ++j) {
                String soapRole = handler.getSoapRoleArray(j).getStringValue().trim();
                soapRoles.add(soapRole);
            }
            ServiceReferenceBuilder.HandlerInfoInfo handlerInfoInfo = new ServiceReferenceBuilder.HandlerInfoInfo(new HashSet(portNames), handlerClass, config, headerQNames, soapRoles);
            handlerInfos.add(handlerInfoInfo);
        }
        return handlerInfos;
    }

    public static Class assureEJBObjectInterface(String remote, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(remote, "javax.ejb.EJBObject", "Remote", cl);
    }

    public static Class assureEJBHomeInterface(String home, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(home, "javax.ejb.EJBHome", "Home", cl);
    }

    public static Class assureEJBLocalObjectInterface(String local, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(local, "javax.ejb.EJBLocalObject", "Local", cl);
    }

    public static Class assureEJBLocalHomeInterface(String localHome, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.assureInterface(localHome, "javax.ejb.EJBLocalHome", "LocalHome", cl);
    }

    public static Class assureInterface(String interfaceName, String superInterfaceName, String interfaceType, ClassLoader cl) throws DeploymentException {
        if (interfaceName == null || interfaceName.equals("")) {
            throw new DeploymentException("interface name cannot be blank");
        }
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(interfaceType + " interface class not found: " + interfaceName);
        }
        if (!clazz.isInterface()) {
            throw new DeploymentException(interfaceType + " interface is not an interface: " + interfaceName);
        }
        Class<?> superInterface = null;
        try {
            superInterface = cl.loadClass(superInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Class " + superInterfaceName + " could not be loaded");
        }
        if (!superInterface.isAssignableFrom(clazz)) {
            throw new DeploymentException(interfaceType + " interface does not extend " + superInterfaceName + ": " + interfaceName);
        }
        return clazz;
    }

    private static String getStringValue(org.apache.geronimo.xbeans.j2ee.String string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(XsdStringType string) {
        if (string == null) {
            return null;
        }
        String s = string.getStringValue();
        return s == null ? null : s.trim();
    }

    private static String getStringValue(String string) {
        return string == null ? null : string.trim();
    }

    public static void setResourceEnvironment(EARContext earContext, URI uri, ResourceEnvironmentBuilder builder, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRefs) throws DeploymentException {
        Map refMap = ENCConfigBuilder.mapResourceRefs(gerResourceRefs);
        HashSet<String> unshareableResources = new HashSet<String>();
        HashSet<String> applicationManagedSecurityResources = new HashSet<String>();
        for (int i = 0; i < resourceRefs.length; ++i) {
            ResourceRefType resourceRefType = resourceRefs[i];
            String type = resourceRefType.getResType().getStringValue().trim();
            if ((class$java$net$URL == null ? ENCConfigBuilder.class$("java.net.URL") : class$java$net$URL).getName().equals(type) || "javax.mail.Session".equals(type) || JAXR_CONNECTION_FACTORY_CLASS.equals(type)) continue;
            GerResourceRefType gerResourceRef = (GerResourceRefType)refMap.get(resourceRefType.getResRefName().getStringValue());
            String containerId = ENCConfigBuilder.getResourceContainerId(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResRefName()), "JCAManagedConnectionFactory", uri, gerResourceRef, earContext);
            if ("Unshareable".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResSharingScope()))) {
                unshareableResources.add(containerId);
            }
            if (!"Application".equals(ENCConfigBuilder.getStringValue((org.apache.geronimo.xbeans.j2ee.String)resourceRefType.getResAuth()))) continue;
            applicationManagedSecurityResources.add(containerId);
        }
        builder.setUnshareableResources(unshareableResources);
        builder.setApplicationManagedSecurityResources(applicationManagedSecurityResources);
    }

    public static Map buildComponentContext(EARContext earContext, NamingContext ejbContext, Module module, UserTransaction userTransaction, EnvEntryType[] envEntries, EjbRefType[] ejbRefs, GerEjbRefType[] gerEjbRefs, EjbLocalRefType[] ejbLocalRefs, GerEjbLocalRefType[] gerEjbLocalRef, ResourceRefType[] resourceRefs, GerResourceRefType[] gerResourceRef, ResourceEnvRefType[] resourceEnvRefs, GerResourceEnvRefType[] gerResourceEnvRef, MessageDestinationRefType[] messageDestinationRefs, ServiceRefType[] serviceRefs, GerServiceRefType[] gerServiceRefs, ClassLoader cl) throws DeploymentException {
        Object handleDelegateReference;
        ObjectName corbaGBean;
        ComponentContextBuilder builder = new ComponentContextBuilder();
        RefContext refContext = earContext.getRefContext();
        if (userTransaction != null) {
            builder.addUserTransaction(userTransaction);
        }
        if ((corbaGBean = earContext.getCORBAGBeanObjectName()) != null) {
            if (corbaGBean.isPattern()) {
                corbaGBean = refContext.locateUniqueName((NamingContext)earContext, corbaGBean);
            }
            builder.addORB(corbaGBean);
        }
        if ((handleDelegateReference = earContext.getRefContext().getHandleDelegateReference()) != null) {
            builder.addHandleDelegateReference(handleDelegateReference);
        }
        URI moduleURI = module.getConfigId();
        ENCConfigBuilder.addEnvEntries(envEntries, builder, cl);
        if (ejbContext == null) {
            ejbContext = earContext;
        }
        ENCConfigBuilder.addEJBRefs((NamingContext)earContext, ejbContext, refContext, moduleURI, ejbRefs, ENCConfigBuilder.mapEjbRefs(gerEjbRefs), cl, builder);
        ENCConfigBuilder.addEJBLocalRefs(ejbContext, refContext, moduleURI, ejbLocalRefs, ENCConfigBuilder.mapEjbLocalRefs(gerEjbLocalRef), cl, builder);
        ENCConfigBuilder.addResourceRefs(earContext, moduleURI, resourceRefs, ENCConfigBuilder.mapResourceRefs(gerResourceRef), cl, builder);
        ENCConfigBuilder.addResourceEnvRefs(earContext, resourceEnvRefs, ENCConfigBuilder.mapResourceEnvRefs(gerResourceEnvRef), cl, builder);
        ENCConfigBuilder.addMessageDestinationRefs(earContext.getRefContext(), (NamingContext)earContext, messageDestinationRefs, cl, builder);
        Map serviceRefMap = ENCConfigBuilder.mapServiceRefs(gerServiceRefs);
        ENCConfigBuilder.addServiceRefs(earContext, module, serviceRefs, serviceRefMap, cl, builder);
        return builder.getContext();
    }

    private static Map mapEjbRefs(GerEjbRefType[] refs) {
        HashMap<String, GerEjbRefType> refMap = new HashMap<String, GerEjbRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapEjbLocalRefs(GerEjbLocalRefType[] refs) {
        HashMap<String, GerEjbLocalRefType> refMap = new HashMap<String, GerEjbLocalRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerEjbLocalRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceRefs(GerResourceRefType[] refs) {
        HashMap<String, GerResourceRefType> refMap = new HashMap<String, GerResourceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapResourceEnvRefs(GerResourceEnvRefType[] refs) {
        HashMap<String, GerResourceEnvRefType> refMap = new HashMap<String, GerResourceEnvRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerResourceEnvRefType ref = refs[i];
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private static Map mapServiceRefs(GerServiceRefType[] refs) {
        HashMap<String, GerServiceRefType> refMap = new HashMap<String, GerServiceRefType>();
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                GerServiceRefType ref = refs[i];
                String serviceRefName = ref.getServiceRefName().trim();
                refMap.put(serviceRefName, ref);
            }
        }
        return refMap;
    }
}

