/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.XmlReferenceBuilder;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.security.jaas.JaasLoginModuleUse;
import org.apache.geronimo.security.jaas.LoginModuleGBean;
import org.apache.geronimo.xbeans.geronimo.loginconfig.GerAbstractLoginModuleType;
import org.apache.geronimo.xbeans.geronimo.loginconfig.GerLoginConfigType;
import org.apache.geronimo.xbeans.geronimo.loginconfig.GerLoginModuleRefType;
import org.apache.geronimo.xbeans.geronimo.loginconfig.GerLoginModuleType;
import org.apache.geronimo.xbeans.geronimo.loginconfig.GerOptionType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class LoginConfigBuilder
implements XmlReferenceBuilder {
    public static final String LOGIN_CONFIG_NAMESPACE = "http://geronimo.apache.org/xml/ns/loginconfig-1.0";
    public static final GBeanInfo GBEAN_INFO;

    public String getNamespace() {
        return LOGIN_CONFIG_NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Set getReferences(XmlObject xmlObject, DeploymentContext context, J2eeContext j2eeContext, ClassLoader classLoader) throws DeploymentException {
        GerLoginConfigType loginConfig = (GerLoginConfigType)xmlObject.copy().changeType(GerLoginConfigType.type);
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        ArrayList errors = new ArrayList();
        xmlOptions.setErrorListener(errors);
        if (!loginConfig.validate(xmlOptions)) {
            throw new DeploymentException("Invalid login configuration:\n" + errors + "\nDescriptor: " + loginConfig.toString());
        }
        XmlCursor xmlCursor = loginConfig.newCursor();
        ObjectName nextName = null;
        try {
            boolean atStart = true;
            while (atStart && xmlCursor.toFirstChild() || !atStart && xmlCursor.toNextSibling()) {
                void var14_14;
                ObjectName thisName;
                ObjectName loginModuleName;
                String name;
                atStart = false;
                XmlObject child = xmlCursor.getObject();
                GerAbstractLoginModuleType abstractLoginModule = (GerAbstractLoginModuleType)child;
                String controlFlag = abstractLoginModule.getControlFlag().toString();
                if (abstractLoginModule instanceof GerLoginModuleRefType) {
                    GerLoginModuleRefType loginModuleRef = (GerLoginModuleRefType)abstractLoginModule;
                    String domain = this.trim(loginModuleRef.getDomain());
                    String server = this.trim(loginModuleRef.getServer());
                    String application = this.trim(loginModuleRef.getApplication());
                    String module = this.trim(loginModuleRef.getModule());
                    String type = this.trim(loginModuleRef.getType());
                    if (type == null) {
                        type = "LoginModule";
                    }
                    name = this.trim(loginModuleRef.getName());
                    try {
                        loginModuleName = NameFactory.getComponentName((String)domain, (String)server, (String)application, (String)module, (String)name, (String)type, (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("cannot construct login module name from parts,", (Throwable)e);
                    }
                }
                if (abstractLoginModule instanceof GerLoginModuleType) {
                    name = null;
                    loginModuleName = null;
                    GerLoginModuleType loginModule = (GerLoginModuleType)abstractLoginModule;
                    name = this.trim(loginModule.getLoginDomainName());
                    String className = this.trim(loginModule.getLoginModuleClass());
                    boolean serverSide = loginModule.getServerSide();
                    Properties options = new Properties();
                    GerOptionType[] optionArray = loginModule.getOptionArray();
                    for (int j = 0; j < optionArray.length; ++j) {
                        GerOptionType gerOptionType = optionArray[j];
                        String key = gerOptionType.getName();
                        String value = this.trim(gerOptionType.getStringValue());
                        options.setProperty(key, value);
                    }
                    try {
                        loginModuleName = NameFactory.getComponentName(null, null, null, null, (String)name, (String)"LoginModule", (J2eeContext)j2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("cannot construct login module use name from parts,", (Throwable)e);
                    }
                    GBeanData loginModuleGBeanData = new GBeanData(loginModuleName, LoginModuleGBean.GBEAN_INFO);
                    loginModuleGBeanData.setAttribute("loginDomainName", (Object)name);
                    loginModuleGBeanData.setAttribute("loginModuleClass", (Object)className);
                    loginModuleGBeanData.setAttribute("options", (Object)options);
                    loginModuleGBeanData.setAttribute("serverSide", (Object)new Boolean(serverSide));
                    context.addGBean(loginModuleGBeanData);
                } else {
                    throw new DeploymentException("Unknown abstract login module type: " + abstractLoginModule.getClass());
                }
                try {
                    void var15_15;
                    thisName = NameFactory.getComponentName(null, null, null, null, (String)var15_15, (String)"LoginModuleUse", (J2eeContext)j2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("cannot construct login module use name from parts,", (Throwable)e);
                }
                GBeanData loginModuleUseGBeanData = new GBeanData(thisName, JaasLoginModuleUse.GBEAN_INFO);
                loginModuleUseGBeanData.setAttribute("controlFlag", (Object)controlFlag);
                loginModuleUseGBeanData.setReferencePattern("LoginModule", (ObjectName)var14_14);
                if (nextName != null) {
                    loginModuleUseGBeanData.setReferencePattern("Next", nextName);
                }
                context.addGBean(loginModuleUseGBeanData);
                nextName = thisName;
            }
        }
        finally {
            xmlCursor.dispose();
        }
        return Collections.singleton(nextName);
    }

    private String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(LoginConfigBuilder.class, "XmlReferenceBuilder");
        infoBuilder.addInterface(XmlReferenceBuilder.class);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

