/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.security.RealmPrincipal;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deploy.DistinguishedName;
import org.apache.geronimo.security.deploy.Principal;
import org.apache.geronimo.security.deploy.Realm;
import org.apache.geronimo.security.deploy.Role;
import org.apache.geronimo.security.deploy.Security;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.apache.geronimo.xbeans.geronimo.security.GerDefaultPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerDistinguishedNameType;
import org.apache.geronimo.xbeans.geronimo.security.GerNamedUsernamePasswordCredentialType;
import org.apache.geronimo.xbeans.geronimo.security.GerPrincipalType;
import org.apache.geronimo.xbeans.geronimo.security.GerRealmType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleMappingsType;
import org.apache.geronimo.xbeans.geronimo.security.GerRoleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;

public class SecurityBuilder {
    public static SecurityConfiguration buildSecurityConfiguration(GerSecurityType securityType) throws DeploymentException {
        Security security = SecurityBuilder.buildSecurityConfig(securityType);
        return SecurityBuilder.buildSecurityConfiguration(security);
    }

    public static SecurityConfiguration buildSecurityConfiguration(Security security) throws DeploymentException {
        HashMap roleDesignates = new HashMap();
        HashMap principalRoleMap = new HashMap();
        HashMap roleToPrincipalMap = new HashMap();
        SecurityBuilder.buildRolePrincipalMap(security, roleDesignates, roleToPrincipalMap);
        SecurityBuilder.invertMap(roleToPrincipalMap, principalRoleMap);
        SecurityConfiguration securityConfiguration = new SecurityConfiguration(principalRoleMap, roleDesignates, security.getDefaultPrincipal(), security.getDefaultRole(), security.isDoAsCurrentCaller(), security.isUseContextHandler());
        return securityConfiguration;
    }

    private static Map invertMap(Map roleToPrincipalMap, Map principalRoleMapping) {
        Iterator roles = roleToPrincipalMap.entrySet().iterator();
        while (roles.hasNext()) {
            Map.Entry entry = roles.next();
            String role = (String)entry.getKey();
            Set principals = (Set)entry.getValue();
            Iterator iter = principals.iterator();
            while (iter.hasNext()) {
                java.security.Principal principal = (java.security.Principal)iter.next();
                HashSet<String> roleSet = (HashSet<String>)principalRoleMapping.get(principal);
                if (roleSet == null) {
                    roleSet = new HashSet<String>();
                    principalRoleMapping.put(principal, roleSet);
                }
                roleSet.add(role);
            }
        }
        return principalRoleMapping;
    }

    private static void buildRolePrincipalMap(Security security, Map roleDesignates, Map roleToPrincipalMap) throws DeploymentException {
        Iterator roleMappings = security.getRoleMappings().values().iterator();
        while (roleMappings.hasNext()) {
            Role role = (Role)roleMappings.next();
            String roleName = role.getRoleName();
            Subject roleDesignate = new Subject();
            HashSet<Object> principalSet = new HashSet<Object>();
            Iterator realms = role.getRealms().values().iterator();
            while (realms.hasNext()) {
                Realm realm = (Realm)realms.next();
                Iterator principals = realm.getPrincipals().iterator();
                while (principals.hasNext()) {
                    Principal principal = (Principal)principals.next();
                    RealmPrincipal realmPrincipal = ConfigurationUtil.generateRealmPrincipal((Principal)principal, (String)realm.getRealmName());
                    if (realmPrincipal == null) {
                        throw new DeploymentException("Unable to create realm principal");
                    }
                    principalSet.add(realmPrincipal);
                    if (!principal.isDesignatedRunAs()) continue;
                    roleDesignate.getPrincipals().add((java.security.Principal)realmPrincipal);
                }
            }
            Iterator names = role.getDNames().iterator();
            while (names.hasNext()) {
                DistinguishedName dn = (DistinguishedName)names.next();
                X500Principal x500Principal = ConfigurationUtil.generateX500Principal((String)dn.getName());
                principalSet.add(x500Principal);
                if (!dn.isDesignatedRunAs()) continue;
                roleDesignate.getPrincipals().add(x500Principal);
            }
            HashSet roleMapping = (HashSet)roleToPrincipalMap.get(roleName);
            if (roleMapping == null) {
                roleMapping = new HashSet();
                roleToPrincipalMap.put(roleName, roleMapping);
            }
            roleMapping.addAll(principalSet);
            if (roleDesignate.getPrincipals().size() <= 0) continue;
            roleDesignates.put(roleName, roleDesignate);
        }
    }

    private static Security buildSecurityConfig(GerSecurityType securityType) {
        Security security = null;
        if (securityType == null) {
            return null;
        }
        security = new Security();
        security.setDoAsCurrentCaller(securityType.getDoasCurrentCaller());
        security.setUseContextHandler(securityType.getUseContextHandler());
        if (securityType.isSetDefaultRole()) {
            security.setDefaultRole(securityType.getDefaultRole().trim());
        }
        if (securityType.isSetRoleMappings()) {
            GerRoleMappingsType roleMappingsType = securityType.getRoleMappings();
            for (int i = 0; i < roleMappingsType.sizeOfRoleArray(); ++i) {
                int j;
                GerRoleType roleType = roleMappingsType.getRoleArray(i);
                Role role = new Role();
                String roleName = roleType.getRoleName().trim();
                role.setRoleName(roleName);
                for (j = 0; j < roleType.sizeOfRealmArray(); ++j) {
                    GerRealmType realmType = roleType.getRealmArray(j);
                    String realmName = realmType.getRealmName().trim();
                    Realm realm = new Realm();
                    realm.setRealmName(realmName);
                    for (int k = 0; k < realmType.sizeOfPrincipalArray(); ++k) {
                        realm.getPrincipals().add(SecurityBuilder.buildPrincipal(realmType.getPrincipalArray(k)));
                    }
                    role.getRealms().put(realmName, realm);
                }
                for (j = 0; j < roleType.sizeOfDistinguishedNameArray(); ++j) {
                    GerDistinguishedNameType dnType = roleType.getDistinguishedNameArray(j);
                    DistinguishedName name = new DistinguishedName(dnType.getName());
                    name.setDesignatedRunAs(dnType.getDesignatedRunAs());
                    role.append(name);
                }
                security.getRoleMappings().put(roleName, role);
            }
        }
        security.setDefaultPrincipal(SecurityBuilder.buildDefaultPrincipal(securityType.getDefaultPrincipal()));
        return security;
    }

    public static DefaultPrincipal buildDefaultPrincipal(GerDefaultPrincipalType defaultPrincipalType) {
        DefaultPrincipal defaultPrincipal = new DefaultPrincipal();
        defaultPrincipal.setRealmName(defaultPrincipalType.getRealmName().trim());
        defaultPrincipal.setPrincipal(SecurityBuilder.buildPrincipal(defaultPrincipalType.getPrincipal()));
        GerNamedUsernamePasswordCredentialType[] namedCredentials = defaultPrincipalType.getNamedUsernamePasswordCredentialArray();
        if (namedCredentials.length > 0) {
            HashSet<NamedUsernamePasswordCredential> defaultCredentialSet = new HashSet<NamedUsernamePasswordCredential>();
            for (int i = 0; i < namedCredentials.length; ++i) {
                GerNamedUsernamePasswordCredentialType namedCredentialType = namedCredentials[i];
                NamedUsernamePasswordCredential namedCredential = new NamedUsernamePasswordCredential(namedCredentialType.getUsername(), namedCredentialType.getPassword().toCharArray(), namedCredentialType.getName());
                defaultCredentialSet.add(namedCredential);
            }
            defaultPrincipal.setNamedUserPasswordCredentials(defaultCredentialSet);
        }
        return defaultPrincipal;
    }

    public static Principal buildPrincipal(GerPrincipalType principalType) {
        Principal principal = new Principal();
        principal.setClassName(principalType.getClass1());
        principal.setPrincipalName(principalType.getName());
        principal.setDesignatedRunAs(principalType.isSetDesignatedRunAs());
        return principal;
    }

    public static GBeanData configureApplicationPolicyManager(ObjectName name, Map contextIDToPermissionsMap, SecurityConfiguration securityConfiguration) {
        GBeanData jaccBeanData = new GBeanData(name, ApplicationPolicyConfigurationManager.GBEAN_INFO);
        jaccBeanData.setAttribute("contextIdToPermissionsMap", (Object)contextIDToPermissionsMap);
        jaccBeanData.setAttribute("principalRoleMap", (Object)securityConfiguration.getPrincipalRoleMap());
        jaccBeanData.setAttribute("roleDesignates", (Object)securityConfiguration.getRoleDesignates());
        return jaccBeanData;
    }
}

