/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.GBeanBuilder;
import org.apache.geronimo.deployment.service.XmlAttributeBuilder;
import org.apache.geronimo.deployment.service.XmlReferenceBuilder;
import org.apache.geronimo.deployment.xbeans.AttributeType;
import org.apache.geronimo.deployment.xbeans.ConfigurationDocument;
import org.apache.geronimo.deployment.xbeans.ConfigurationType;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xbeans.ReferenceType;
import org.apache.geronimo.deployment.xbeans.ReferencesType;
import org.apache.geronimo.deployment.xbeans.ServiceDocument;
import org.apache.geronimo.deployment.xbeans.XmlAttributeType;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferenceMap;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class ServiceConfigBuilder
implements ConfigurationBuilder {
    private final URI defaultParentId;
    private final Repository repository;
    private final Kernel kernel;
    private static final Map xmlAttributeBuilderMap = new HashMap();
    private static final Map xmlReferenceBuilderMap = new HashMap();
    private Map attrRefMap;
    private Map refRefMap;
    private static final QName SERVICE_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment", "configuration");
    public static final GBeanInfo GBEAN_INFO;

    public ServiceConfigBuilder(URI defaultParentId, Repository repository) {
        this(defaultParentId, repository, null, null, null);
    }

    public ServiceConfigBuilder(URI defaultParentId, Repository repository, Collection xmlAttributeBuilders, Collection xmlReferenceBuilders, Kernel kernel) {
        Object key;
        this.defaultParentId = defaultParentId;
        this.repository = repository;
        this.kernel = kernel;
        if (xmlAttributeBuilders != null) {
            key = new ReferenceMap.Key(){

                public Object getKey(Object object) {
                    return ((XmlAttributeBuilder)object).getNamespace();
                }
            };
            this.attrRefMap = new ReferenceMap(xmlAttributeBuilders, xmlAttributeBuilderMap, key);
        }
        if (xmlReferenceBuilders != null) {
            key = new ReferenceMap.Key(){

                public Object getKey(Object object) {
                    return ((XmlReferenceBuilder)object).getNamespace();
                }
            };
            this.refRefMap = new ReferenceMap(xmlReferenceBuilders, xmlReferenceBuilderMap, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDeploymentPlan(File planFile, JarFile module) throws DeploymentException {
        if (planFile == null) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((File)planFile);
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toFirstChild();
                if (!SERVICE_QNAME.equals(cursor.getName())) {
                    Object var5_7 = null;
                    return var5_7;
                }
            }
            finally {
                cursor.dispose();
            }
            ConfigurationDocument configurationDoc = xmlObject instanceof ConfigurationDocument ? (ConfigurationDocument)xmlObject : (ConfigurationDocument)xmlObject.changeType(ConfigurationDocument.type);
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setLoadLineNumbers();
            ArrayList errors = new ArrayList();
            xmlOptions.setErrorListener(errors);
            if (configurationDoc.validate(xmlOptions)) return configurationDoc.getConfiguration();
            throw new DeploymentException("Invalid deployment descriptor: " + errors + "\nDescriptor: " + configurationDoc.toString());
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse xml in plan", (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("no plan at " + planFile, (Throwable)e);
        }
    }

    public ConfigurationData buildConfiguration(Object plan, JarFile unused, File outfile) throws IOException, DeploymentException {
        ConfigurationType configType = (ConfigurationType)plan;
        String domain = null;
        String server = null;
        return this.buildConfiguration(configType, domain, server, outfile);
    }

    public ConfigurationData buildConfiguration(ConfigurationType configType, String domain, String server, File outfile) throws DeploymentException, IOException {
        URI configID;
        URI parentID = null;
        if (configType.isSetParentId()) {
            try {
                parentID = new URI(configType.getParentId());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid parentId " + configType.getParentId(), (Throwable)e);
            }
        } else if (configType.isSetDomain()) {
            if (!configType.isSetServer()) {
                throw new DeploymentException("You must set both domain and server");
            }
            domain = configType.getDomain();
            server = configType.getServer();
        } else {
            parentID = this.defaultParentId;
        }
        if (domain == null && this.kernel == null) {
            throw new DeploymentException("You must supply a kernel or the domain and server names");
        }
        try {
            configID = new URI(configType.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + configType.getConfigId(), (Throwable)e);
        }
        DeploymentContext context = null;
        try {
            context = new DeploymentContext(outfile, configID, ConfigurationModuleType.SERVICE, parentID, domain, server, this.kernel);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException((Throwable)e);
        }
        J2eeContextImpl j2eeContext = new J2eeContextImpl(context.getDomain(), context.getServer(), NameFactory.NULL, NameFactory.J2EE_MODULE, configID.toString(), null, null);
        DependencyType[] includes = configType.getIncludeArray();
        ServiceConfigBuilder.addIncludes(context, includes, this.repository);
        ServiceConfigBuilder.addDependencies(context, configType.getDependencyArray(), this.repository);
        ClassLoader cl = context.getClassLoader(this.repository);
        GbeanType[] gbeans = configType.getGbeanArray();
        ServiceConfigBuilder.addGBeans(gbeans, cl, (J2eeContext)j2eeContext, context);
        context.close();
        return context.getConfigurationData();
    }

    public static void addIncludes(DeploymentContext context, DependencyType[] includes, Repository repository) throws DeploymentException {
        for (int i = 0; i < includes.length; ++i) {
            URI path;
            DependencyType include = includes[i];
            URI uri = ServiceConfigBuilder.getDependencyURI(include, repository);
            String name = uri.toString();
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                name = name.substring(idx + 1);
            }
            try {
                path = new URI(name);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Unable to generate path for include: " + uri, (Throwable)e);
            }
            try {
                URL url = repository.getURL(uri);
                context.addInclude(path, url);
                continue;
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to add include: " + uri, (Throwable)e);
            }
        }
    }

    public static void addDependencies(DeploymentContext context, DependencyType[] deps, Repository repository) throws DeploymentException {
        for (int i = 0; i < deps.length; ++i) {
            URL url;
            URI dependencyURI = ServiceConfigBuilder.getDependencyURI(deps[i], repository);
            context.addDependency(dependencyURI);
            try {
                url = repository.getURL(dependencyURI);
            }
            catch (MalformedURLException e) {
                throw new DeploymentException("Unable to get URL for dependency " + dependencyURI, (Throwable)e);
            }
            URLClassLoader depCL = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
            InputStream is = ((ClassLoader)depCL).getResourceAsStream("META-INF/geronimo-service.xml");
            if (is == null) continue;
            ServiceDocument serviceDoc = null;
            try {
                serviceDoc = ServiceDocument.Factory.parse(is);
            }
            catch (XmlException e) {
                throw new DeploymentException("Invalid geronimo-service.xml file in " + url, (Throwable)e);
            }
            catch (IOException e) {
                throw new DeploymentException("Unable to parse geronimo-service.xml file in " + url, (Throwable)e);
            }
            DependencyType[] dependencyDeps = serviceDoc.getService().getDependencyArray();
            if (dependencyDeps == null) continue;
            ServiceConfigBuilder.addDependencies(context, dependencyDeps, repository);
        }
    }

    public static void addGBeans(GbeanType[] gbeans, ClassLoader cl, J2eeContext j2eeContext, DeploymentContext context) throws DeploymentException {
        for (int i = 0; i < gbeans.length; ++i) {
            ServiceConfigBuilder.addGBeanData(gbeans[i], j2eeContext, cl, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName addGBeanData(GbeanType gbean, J2eeContext j2eeContext, ClassLoader cl, DeploymentContext context) throws DeploymentException {
        XmlAttributeType[] xmlReferenceArray;
        ReferencesType[] referencesArray;
        ReferenceType[] referenceArray;
        XmlAttributeType[] xmlAttributeArray;
        ObjectName objectName;
        GBeanInfo gBeanInfo = GBeanInfo.getGBeanInfo((String)gbean.getClass1(), (ClassLoader)cl);
        if (gbean.isSetGbeanName()) {
            try {
                objectName = ObjectName.getInstance(gbean.getGbeanName());
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Invalid ObjectName: " + gbean.getName(), (Throwable)e);
            }
        }
        String namePart = gbean.getName();
        try {
            String j2eeType = gBeanInfo.getJ2eeType();
            objectName = NameFactory.getComponentName(null, null, null, null, (String)namePart, (String)j2eeType, (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Invalid ObjectName: " + namePart, (Throwable)e);
        }
        GBeanBuilder builder = new GBeanBuilder(objectName, gBeanInfo, cl, context, j2eeContext, xmlAttributeBuilderMap, xmlReferenceBuilderMap);
        AttributeType[] attributeArray = gbean.getAttributeArray();
        if (attributeArray != null) {
            for (int j = 0; j < attributeArray.length; ++j) {
                builder.setAttribute(attributeArray[j].getName().trim(), attributeArray[j].getType(), attributeArray[j].getStringValue());
            }
        }
        if ((xmlAttributeArray = gbean.getXmlAttributeArray()) != null) {
            for (int i = 0; i < xmlAttributeArray.length; ++i) {
                XmlAttributeType xmlAttributeType = xmlAttributeArray[i];
                String name = xmlAttributeType.getName().trim();
                XmlCursor xmlCursor = xmlAttributeType.newCursor();
                try {
                    xmlCursor.toFirstChild();
                    builder.setXmlAttribute(name, xmlCursor);
                    continue;
                }
                finally {
                    xmlCursor.dispose();
                }
            }
        }
        if ((referenceArray = gbean.getReferenceArray()) != null) {
            for (int j = 0; j < referenceArray.length; ++j) {
                builder.setReference(referenceArray[j].getName2(), referenceArray[j], j2eeContext);
            }
        }
        if ((referencesArray = gbean.getReferencesArray()) != null) {
            for (int j = 0; j < referencesArray.length; ++j) {
                builder.setReference(referencesArray[j].getName(), referencesArray[j].getPatternArray(), j2eeContext);
            }
        }
        if ((xmlReferenceArray = gbean.getXmlReferenceArray()) != null) {
            for (int i = 0; i < xmlReferenceArray.length; ++i) {
                XmlAttributeType xmlAttributeType = xmlReferenceArray[i];
                String name = xmlAttributeType.getName().trim();
                XmlCursor xmlCursor = xmlAttributeType.newCursor();
                try {
                    xmlCursor.toFirstChild();
                    builder.setXmlReference(name, xmlCursor);
                    continue;
                }
                finally {
                    xmlCursor.dispose();
                }
            }
        }
        GBeanData gBeanData = builder.getGBeanData();
        context.addGBean(gBeanData);
        return objectName;
    }

    private static URI getDependencyURI(DependencyType dep, Repository repository) throws DeploymentException {
        URI uri;
        if (dep.isSetUri()) {
            try {
                uri = new URI(dep.getUri());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid dependency URI " + dep.getUri(), (Throwable)e);
            }
        }
        String id = dep.getGroupId() + "/jars/" + dep.getArtifactId() + '-' + dep.getVersion() + ".jar";
        try {
            uri = new URI(id);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Unable to construct URI for groupId=" + dep.getGroupId() + ", artifactId=" + dep.getArtifactId() + ", version=" + dep.getVersion(), (Throwable)e);
        }
        if (!repository.hasURI(uri)) {
            throw new DeploymentException((Throwable)new MissingDependencyException("uri " + uri + " not found in repository"));
        }
        return uri;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ServiceConfigBuilder.class, "ConfigBuilder");
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.addAttribute("defaultParentId", URI.class, true);
        infoFactory.addReference("Repository", Repository.class, "GBean");
        infoFactory.addReference("XmlAttributeBuilders", XmlAttributeBuilder.class, "XmlAttributeBuilder");
        infoFactory.addReference("XmlReferenceBuilders", XmlReferenceBuilder.class, "XmlReferenceBuilder");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"defaultParentId", "Repository", "XmlAttributeBuilders", "XmlReferenceBuilders", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

