/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.InvalidConfigException;

public final class ExecutableConfigurationUtil {
    private ExecutableConfigurationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createExecutableConfiguration(ConfigurationData configurationData, Manifest manifest, File configurationDir, File destinationFile) throws IOException, InvalidConfigException {
        JarOutputStream out = null;
        try {
            out = new JarOutputStream((OutputStream)new FileOutputStream(destinationFile), manifest);
            byte[] buffer = new byte[4096];
            out.putNextEntry(new ZipEntry("META-INF/startup-jar"));
            out.closeEntry();
            ExecutableConfigurationUtil.writeConfiguration(configurationData, out);
            URI baseURI = configurationDir.getAbsoluteFile().toURI();
            Collection files = ExecutableConfigurationUtil.listRecursiveFiles(configurationDir);
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String relativePath = baseURI.relativize(file.toURI()).getPath();
                FileInputStream in = new FileInputStream(file);
                try {
                    out.putNextEntry(new ZipEntry(relativePath));
                    try {
                        int count;
                        while ((count = ((InputStream)in).read(buffer)) > 0) {
                            out.write(buffer, 0, count);
                        }
                    }
                    finally {
                        out.closeEntry();
                    }
                }
                finally {
                    ExecutableConfigurationUtil.close(in);
                }
            }
        }
        catch (Throwable throwable) {
            ExecutableConfigurationUtil.close(out);
            throw throwable;
        }
        ExecutableConfigurationUtil.close(out);
    }

    /*
     * Loose catch block
     */
    public static void writeConfiguration(ConfigurationData configurationData, JarOutputStream out) throws IOException, InvalidConfigException {
        block9: {
            GBeanData configurationGBeanData = ExecutableConfigurationUtil.getConfigurationGBeanData(configurationData);
            out.putNextEntry(new ZipEntry("META-INF/config.ser"));
            ObjectOutputStream objectOutputStream = null;
            objectOutputStream = new ObjectOutputStream(out);
            configurationGBeanData.writeExternal((ObjectOutput)objectOutputStream);
            Object var6_4 = null;
            if (objectOutputStream == null) break block9;
            try {
                objectOutputStream.flush();
                break block9;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            {
                break block9;
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvalidConfigException("Unable to save configuration state", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.flush();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                out.closeEntry();
                throw throwable;
            }
        }
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeConfiguration(ConfigurationData configurationData, File source) throws InvalidConfigException, IOException {
        block12: {
            GBeanData configurationGBeanData = ExecutableConfigurationUtil.getConfigurationGBeanData(configurationData);
            File metaInf = new File(source, "META-INF");
            metaInf.mkdirs();
            File configSer = new File(metaInf, "config.ser");
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(configSer));
                try {
                    configurationGBeanData.writeExternal((ObjectOutput)out);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvalidConfigException("Unable to save configuration state", (Throwable)e);
                }
                Object var8_8 = null;
                if (out == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                out.flush();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception ignored) {}
        }
    }

    public static GBeanData getConfigurationGBeanData(ConfigurationData configurationData) throws InvalidConfigException {
        try {
            URI id = configurationData.getId();
            GBeanData config = new GBeanData(Configuration.getConfigurationObjectName((URI)id), Configuration.GBEAN_INFO);
            config.setAttribute("id", (Object)id);
            config.setAttribute("type", (Object)configurationData.getModuleType());
            config.setAttribute("domain", (Object)configurationData.getDomain());
            config.setAttribute("server", (Object)configurationData.getServer());
            URI parentId = configurationData.getParentId();
            if (parentId != null) {
                config.setAttribute("parentId", (Object)parentId);
                ObjectName parentName = Configuration.getConfigurationObjectName((URI)parentId);
                config.setReferencePattern("Parent", parentName);
            }
            config.setAttribute("gBeanState", (Object)Configuration.storeGBeans((List)configurationData.getGBeans()));
            config.setReferencePatterns("Repositories", Collections.singleton(new ObjectName("*:name=Repository,*")));
            config.setAttribute("dependencies", (Object)configurationData.getDependencies());
            config.setAttribute("classPath", (Object)configurationData.getClassPath());
            return config;
        }
        catch (MalformedObjectNameException e) {
            throw new InvalidConfigException((Throwable)e);
        }
    }

    private static Collection listRecursiveFiles(File file) {
        LinkedList list = new LinkedList();
        ExecutableConfigurationUtil.listRecursiveFiles(file, list);
        return Collections.unmodifiableCollection(list);
    }

    private static void listRecursiveFiles(File file, Collection collection) {
        File[] files = file.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ExecutableConfigurationUtil.listRecursiveFiles(files[i], collection);
                continue;
            }
            collection.add(files[i]);
        }
    }

    private static void close(InputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream thing) {
        if (thing != null) {
            try {
                thing.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

