/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.logging.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.log.GeronimoLogFactory;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.system.logging.log4j.CachingLog4jLog;
import org.apache.geronimo.system.logging.log4j.URLConfigurator;
import org.apache.geronimo.system.logging.log4j.XLevel;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jService
implements GBeanLifecycle {
    private String configurationFile;
    private int refreshPeriod;
    private final ServerInfo serverInfo;
    private Timer timer = new Timer(true);
    private TimerTask monitor;
    private long lastChanged = -1L;
    private boolean running = false;
    public static final GBeanInfo GBEAN_INFO;

    public Log4jService(String configurationFile, int refreshPeriod, ServerInfo serverInfo) {
        this.refreshPeriod = refreshPeriod;
        this.configurationFile = configurationFile;
        this.serverInfo = serverInfo;
    }

    public synchronized String getRootLoggerLevel() {
        Level level = LogManager.getRootLogger().getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public synchronized void setRootLoggerLevel(String level) {
        LogManager.getRootLogger().setLevel(XLevel.toLevel(level));
    }

    public String getLoggerEffectiveLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = LogManager.getLogger((String)logger).getEffectiveLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public String getLoggerLevel(String logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        Level level = LogManager.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    public void setLoggerLevel(String logger, String level) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        Logger.getLogger((String)logger).setLevel(XLevel.toLevel(level));
    }

    public synchronized int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public synchronized void setRefreshPeriod(int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Refresh period must be > 0");
        }
        if (this.refreshPeriod != period) {
            this.refreshPeriod = period;
            this.schedule();
        }
    }

    public synchronized String getConfigurationFile() {
        return this.configurationFile;
    }

    public synchronized void setConfigurationFile(String configurationFile) {
        if (this.configurationFile == null) {
            throw new IllegalArgumentException("configurationFile is null");
        }
        this.configurationFile = configurationFile;
        this.lastChanged = -1L;
    }

    public synchronized String getConfiguration() {
        File file = this.resolveConfigurationFile();
        if (file == null || !file.canRead()) {
            return null;
        }
        Reader in = null;
        try {
            StringBuffer configuration = new StringBuffer();
            in = new InputStreamReader(new FileInputStream(file));
            char[] buffer = new char[4096];
            int size = in.read(buffer);
            while (size >= 0) {
                configuration.append(buffer, 0, size);
                size = in.read(buffer);
            }
            return configuration.toString();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setConfiguration(String configuration) throws IOException {
        if (configuration == null || configuration.length() == 0) {
            throw new IllegalArgumentException("configuration is null or an empty string");
        }
        File file = this.resolveConfigurationFile();
        if (file == null) {
            throw new IllegalStateException("Configuration file is null");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create parent directory of log configuration file: " + file.getParent());
        }
        if (file.exists() && !file.canWrite()) {
            throw new IllegalStateException("Configuration file is not writable: " + file.getAbsolutePath());
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(configuration.getBytes());
            Object var5_4 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reconfigure() {
        File file = this.resolveConfigurationFile();
        if (file == null) {
            return;
        }
        System.setProperty("org.apache.geronimo.log.ConsoleLogLevel", GeronimoLogging.getConsoleLogLevel().toString());
        try {
            URLConfigurator.configure(file.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        GeronimoLogFactory logFactory = (GeronimoLogFactory)LogFactory.getFactory();
        Set instances = logFactory.getInstances();
        Iterator iterator = instances.iterator();
        while (iterator.hasNext()) {
            Object log = iterator.next();
            if (!(log instanceof CachingLog4jLog)) continue;
            ((CachingLog4jLog)log).updateLevelInfo();
        }
    }

    private synchronized void schedule() {
        if (this.timer != null) {
            if (this.monitor != null) {
                this.monitor.cancel();
            }
            TimerTask task = this.monitor = new URLMonitorTask();
            this.timer.schedule(this.monitor, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        Log4jService log4jService;
        LogFactory logFactory = LogFactory.getFactory();
        if (logFactory instanceof GeronimoLogFactory) {
            GeronimoLogFactory geronimoLogFactory;
            log4jService = this;
            synchronized (log4jService) {
                this.timer = new Timer(true);
                this.schedule();
                LogManager.getRootLogger();
                this.reconfigure();
                File file = this.resolveConfigurationFile();
                if (file != null) {
                    this.lastChanged = file.lastModified();
                }
            }
            GeronimoLogFactory geronimoLogFactory2 = geronimoLogFactory = (GeronimoLogFactory)logFactory;
            synchronized (geronimoLogFactory2) {
                if (!(geronimoLogFactory.getLogFactory() instanceof CachingLog4jLogFactory)) {
                    geronimoLogFactory.setLogFactory((LogFactory)new CachingLog4jLogFactory());
                }
            }
        }
        log4jService = this;
        synchronized (log4jService) {
            this.running = true;
        }
    }

    public synchronized void doStop() {
        this.running = false;
        if (this.monitor != null) {
            this.monitor.cancel();
            this.monitor = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void doFail() {
        this.doStop();
    }

    private synchronized File resolveConfigurationFile() {
        try {
            return this.serverInfo.resolve(this.configurationFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(Log4jService.class);
        infoFactory.addAttribute("configurationFile", String.class, true);
        infoFactory.addAttribute("refreshPeriod", Integer.TYPE, true);
        infoFactory.addAttribute("configuration", String.class, false);
        infoFactory.addAttribute("rootLoggerLevel", String.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addOperation("reconfigure");
        infoFactory.addOperation("setLoggerLevel", new Class[]{String.class, String.class});
        infoFactory.addOperation("getLoggerLevel", new Class[]{String.class});
        infoFactory.addOperation("getLoggerEffectiveLevel", new Class[]{String.class});
        infoFactory.setConstructor(new String[]{"configurationFile", "refreshPeriod", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class CachingLog4jLogFactory
    extends LogFactory {
        private CachingLog4jLogFactory() {
        }

        public Log getInstance(Class clazz) throws LogConfigurationException {
            return this.getInstance(clazz.getName());
        }

        public Log getInstance(String name) throws LogConfigurationException {
            return new CachingLog4jLog(name);
        }

        public Object getAttribute(String name) {
            return null;
        }

        public String[] getAttributeNames() {
            return new String[0];
        }

        public void release() {
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object value) {
        }
    }

    private class URLMonitorTask
    extends TimerTask {
        private URLMonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long lastModified;
                URLMonitorTask uRLMonitorTask = this;
                synchronized (uRLMonitorTask) {
                    if (!Log4jService.this.running) {
                        return;
                    }
                    File file = Log4jService.this.resolveConfigurationFile();
                    if (file == null) {
                        return;
                    }
                    lastModified = file.lastModified();
                }
                if (Log4jService.this.lastChanged < lastModified) {
                    Log4jService.this.lastChanged = lastModified;
                    Log4jService.this.reconfigure();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

