/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.system.main.CommandLine;

public class CommandLineManifest {
    public static final Attributes.Name MAIN_GBEAN = new Attributes.Name("Main-GBean");
    public static final Attributes.Name MAIN_METHOD = new Attributes.Name("Main-Method");
    public static final Attributes.Name CONFIGURATIONS = new Attributes.Name("Configurations");
    public static final Attributes.Name ENDORSED_DIRS = new Attributes.Name("Endorsed-Dirs");
    private final ObjectName mainGBean;
    private final String mainMethod;
    private final List configurations;
    private final List endorsedDirs;

    public static CommandLineManifest getManifestEntries() {
        Manifest manifest;
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        URL url = classLoader.getResource("META-INF/startup-jar");
        if (url == null) {
            throw new IllegalArgumentException("Unable to determine location of startup jar");
        }
        try {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            manifest = jarConnection.getManifest();
        }
        catch (IOException e) {
            System.err.println("Startup jar does not contain a manifest: " + url);
            System.exit(1);
            throw new AssertionError();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        String mainGBeanString = mainAttributes.getValue(MAIN_GBEAN);
        ObjectName mainGBean = null;
        if (mainGBeanString != null) {
            try {
                mainGBean = new ObjectName(mainGBeanString);
            }
            catch (MalformedObjectNameException e) {
                System.err.println("Invalid Main-GBean name: " + mainGBeanString);
                System.exit(1);
                throw new AssertionError();
            }
        }
        String mainMethod = mainAttributes.getValue(MAIN_METHOD);
        ArrayList<URI> configurations = new ArrayList<URI>();
        String configurationsString = mainAttributes.getValue(CONFIGURATIONS);
        if (configurationsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(configurationsString, " ");
            while (tokenizer.hasMoreTokens()) {
                String configuration = tokenizer.nextToken();
                try {
                    configurations.add(new URI(configuration));
                }
                catch (URISyntaxException e) {
                    System.err.println("Invalid URI in Manifest Configurations entry: " + configuration);
                    System.exit(1);
                    throw new AssertionError();
                }
            }
        }
        ArrayList<String> endorsedDirs = new ArrayList<String>();
        String endorsedDirsString = mainAttributes.getValue(ENDORSED_DIRS);
        if (endorsedDirsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(endorsedDirsString, " ");
            while (tokenizer.hasMoreTokens()) {
                String configuration = tokenizer.nextToken();
                endorsedDirs.add(configuration);
            }
        }
        CommandLineManifest commandLineManifest = new CommandLineManifest(mainGBean, mainMethod, configurations, endorsedDirs);
        return commandLineManifest;
    }

    public CommandLineManifest(ObjectName mainGBean, String mainMethod, List configurations, List endorsedDirs) {
        this.mainGBean = mainGBean;
        this.mainMethod = mainMethod;
        this.configurations = Collections.unmodifiableList(configurations);
        this.endorsedDirs = endorsedDirs;
    }

    public ObjectName getMainGBean() {
        return this.mainGBean;
    }

    public String getMainMethod() {
        return this.mainMethod;
    }

    public List getConfigurations() {
        return this.configurations;
    }

    public List getEndorsedDirs() {
        return this.endorsedDirs;
    }
}

