/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactory;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.kernel.log.GeronimoLogging;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.system.jmx.MBeanServerKernelBridge;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.geronimo.system.main.ProgressBarStartupMonitor;
import org.apache.geronimo.system.main.SilentStartupMonitor;
import org.apache.geronimo.system.main.StartupMonitor;
import org.apache.geronimo.system.main.ToolsJarHack;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;
import org.apache.geronimo.system.url.GeronimoURLFactory;

public class Daemon {
    private static final String ARGUMENT_NO_PROGRESS = "-quiet";
    private static final String ARGUMENT_VERBOSE = "-v";
    private static final String ARGUMENT_MORE_VERBOSE = "-vv";
    private static boolean started = false;
    private static Log log;
    private static final ObjectName PERSISTENT_CONFIGURATION_LIST_NAME_QUERY;
    private StartupMonitor monitor;
    private List configs = new ArrayList();
    private String verboseArg = null;
    private String progressArg = null;

    private Daemon(String[] args) {
        long start = System.currentTimeMillis();
        System.out.println("Booting Geronimo Kernel (in Java " + System.getProperty("java.version") + ")...");
        System.out.flush();
        this.processArguments(args);
        this.initializeSystem();
        log.info((Object)"Server startup begun");
        this.monitor.systemStarting(start);
        this.doStartup();
    }

    private void processArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(ARGUMENT_NO_PROGRESS)) {
                this.progressArg = ARGUMENT_NO_PROGRESS;
                continue;
            }
            if (args[i].equals(ARGUMENT_VERBOSE)) {
                if (this.verboseArg != null) continue;
                this.verboseArg = ARGUMENT_VERBOSE;
                continue;
            }
            if (args[i].equals(ARGUMENT_MORE_VERBOSE)) {
                if (this.verboseArg != null) continue;
                this.verboseArg = ARGUMENT_MORE_VERBOSE;
                continue;
            }
            try {
                this.configs.add(new URI(args[i]));
                continue;
            }
            catch (URISyntaxException e) {
                System.err.println("Invalid configuration-id: " + args[i]);
                e.printStackTrace();
                System.exit(1);
                throw new AssertionError();
            }
        }
    }

    private void initializeSystem() {
        if (!started) {
            started = true;
            GeronimoLogging.initialize((GeronimoLogging)(this.verboseArg == null ? GeronimoLogging.WARN : (this.verboseArg == ARGUMENT_VERBOSE ? GeronimoLogging.INFO : GeronimoLogging.DEBUG)));
            log = LogFactory.getLog((String)Daemon.class.getName());
            GeronimoURLFactory.install();
            ToolsJarHack.install();
            this.monitor = this.verboseArg != null || this.progressArg != null ? new SilentStartupMonitor() : new ProgressBarStartupMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartup() {
        try {
            ObjectName configListName;
            Iterator i;
            Set configLists;
            File geronimoInstallDirectory = DirectoryUtils.getGeronimoInstallDirectory();
            if (geronimoInstallDirectory == null) {
                System.err.println("Could not determine geronimo installation directory");
                System.exit(1);
                throw new AssertionError();
            }
            CommandLineManifest manifestEntries = CommandLineManifest.getManifestEntries();
            String endorsedDirs = System.getProperty("java.endorsed.dirs", "");
            Iterator iterator = manifestEntries.getEndorsedDirs().iterator();
            while (iterator.hasNext()) {
                String directoryName = (String)iterator.next();
                File directory = new File(directoryName);
                if (!directory.isAbsolute()) {
                    directory = new File(geronimoInstallDirectory, directoryName);
                }
                if (endorsedDirs.length() > 0) {
                    endorsedDirs = endorsedDirs + File.pathSeparatorChar;
                }
                endorsedDirs = endorsedDirs + directory.getAbsolutePath();
            }
            if (endorsedDirs.length() > 0) {
                System.setProperty("java.endorsed.dirs", endorsedDirs);
            }
            log.debug((Object)("java.endorsed.dirs=" + System.getProperty("java.endorsed.dirs")));
            ClassLoader classLoader = Daemon.class.getClassLoader();
            GBeanData configuration = new GBeanData();
            ObjectInputStream ois = new ObjectInputStream(classLoader.getResourceAsStream("META-INF/config.ser"));
            try {
                configuration.readExternal((ObjectInput)ois);
            }
            finally {
                ois.close();
            }
            URI configurationId = (URI)configuration.getAttribute("id");
            ObjectName configName = Configuration.getConfigurationObjectName((URI)configurationId);
            configuration.setName(configName);
            MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer("geronimo");
            String mbeanServerId = (String)mbeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
            final Kernel kernel = KernelFactory.newInstance().createKernel("geronimo");
            try {
                kernel.boot();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(2);
                throw new AssertionError();
            }
            kernel.loadGBean(configuration, classLoader);
            kernel.setAttribute(configName, "baseURL", (Object)classLoader.getResource("/"));
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown Thread"){

                public void run() {
                    log.info((Object)"Server shutdown begun");
                    System.out.println("Server shutdown begun");
                    kernel.shutdown();
                    log.info((Object)"Server shutdown completed");
                    System.out.println("Server shutdown completed");
                }
            });
            ObjectName mbeanServerKernelBridgeName = new ObjectName("geronimo.boot:role=MBeanServerKernelBridge");
            GBeanData mbeanServerKernelBridge = new GBeanData(mbeanServerKernelBridgeName, MBeanServerKernelBridge.GBEAN_INFO);
            mbeanServerKernelBridge.setAttribute("mbeanServerId", (Object)mbeanServerId);
            kernel.loadGBean(mbeanServerKernelBridge, classLoader);
            kernel.startGBean(mbeanServerKernelBridgeName);
            kernel.startRecursiveGBean(configuration.getName());
            this.monitor.systemStarted(kernel);
            if (this.configs.isEmpty()) {
                configLists = kernel.listGBeans(PERSISTENT_CONFIGURATION_LIST_NAME_QUERY);
                i = configLists.iterator();
                while (i.hasNext()) {
                    configListName = (ObjectName)i.next();
                    try {
                        this.configs.addAll((List)kernel.invoke(configListName, "restore"));
                    }
                    catch (IOException e) {
                        System.err.println("Unable to restore last known configurations");
                        e.printStackTrace();
                        kernel.shutdown();
                        System.exit(3);
                        throw new AssertionError();
                    }
                }
            }
            this.monitor.foundConfigurations(this.configs.toArray(new URI[this.configs.size()]));
            try {
                ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
                i = this.configs.iterator();
                while (i.hasNext()) {
                    URI configID = (URI)i.next();
                    this.monitor.configurationLoading(configID);
                    List list = configurationManager.loadRecursive(configID);
                    this.monitor.configurationLoaded(configID);
                    this.monitor.configurationStarting(configID);
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        ObjectName name = (ObjectName)iterator2.next();
                        kernel.startRecursiveGBean(name);
                    }
                    this.monitor.configurationStarted(configID);
                }
            }
            catch (Exception e) {
                this.monitor.serverStartFailed(e);
                try {
                    kernel.shutdown();
                }
                catch (Exception e1) {
                    System.err.println("Exception caught during kernel shutdown");
                    e1.printStackTrace();
                }
                System.exit(3);
                throw new AssertionError();
            }
            configLists = kernel.listGBeans(PERSISTENT_CONFIGURATION_LIST_NAME_QUERY);
            i = configLists.iterator();
            while (i.hasNext()) {
                configListName = (ObjectName)i.next();
                kernel.setAttribute(configListName, "kernelFullyStarted", (Object)Boolean.TRUE);
            }
            Set allGBeans = kernel.listGBeans(JMXUtil.getObjectName((String)"*:*"));
            Kernel iterator3 = allGBeans.iterator();
            while (iterator3.hasNext()) {
                ObjectName objectName = (ObjectName)iterator3.next();
                try {
                    int state = kernel.getGBeanState(objectName);
                    if (state == 1) continue;
                    log.info((Object)("GBean " + objectName + " is not running. Current state: " + State.fromInt((int)state).getName()));
                }
                catch (GBeanNotFoundException e) {
                    log.info((Object)("Alleged GBean " + objectName + " is not a GBean"));
                }
            }
            this.monitor.startupFinished();
            this.monitor = null;
            log.info((Object)"Server startup completed");
            while (kernel.isRunning()) {
                try {
                    iterator3 = kernel;
                    synchronized (iterator3) {
                        kernel.wait();
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (Exception e) {
            if (this.monitor != null) {
                this.monitor.serverStartFailed(e);
            }
            e.printStackTrace();
            System.exit(3);
            throw new AssertionError();
        }
    }

    public static void main(String[] args) {
        new Daemon(args);
    }

    static {
        PERSISTENT_CONFIGURATION_LIST_NAME_QUERY = JMXUtil.getObjectName((String)"*:j2eeType=PersistentConfigurationList,*");
    }
}

